/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import $ from"jquery";import{DateTime}from"luxon";import Md5 from"@typo3/backend/hashing/md5.js";import DocumentSaveActions from"@typo3/backend/document-save-actions.js";import Modal from"@typo3/backend/modal.js";import Severity from"@typo3/backend/severity.js";import{selector}from"@typo3/core/literals.js";export default(function(){const FormEngineValidation={rulesSelector:"[data-formengine-validation-rules]",inputSelector:"[data-formengine-input-params]",markerSelector:".t3js-formengine-validation-marker",groupFieldHiddenElement:".t3js-formengine-field-group input[type=hidden]",relatedFieldSelector:"[data-relatedfieldname]",errorClass:"has-error",lastYear:0,lastDate:0,lastTime:0,passwordDummy:"********"},customEvaluations=new Map;return FormEngineValidation.initialize=function(){$(document).find("."+FormEngineValidation.errorClass).removeClass(FormEngineValidation.errorClass),FormEngineValidation.initializeInputFields().promise().done(function(){$(document).on("change",FormEngineValidation.rulesSelector,e=>{FormEngineValidation.validateField(e.currentTarget),FormEngineValidation.markFieldAsChanged(e.currentTarget)}),FormEngineValidation.registerSubmitCallback()}),FormEngineValidation.validate()},FormEngineValidation.initializeInputFields=function(){return $(document).find(FormEngineValidation.inputSelector).each(function(e,n){const a=$(n).data("formengine-input-params"),t=a.field,i=$(selector`[name="${t}"]`);void 0===i.data("main-field")&&(i.data("main-field",t),i.data("config",a),FormEngineValidation.initializeInputField(t))})},FormEngineValidation.initializeInputField=function(e){const n=$(selector`[name="${e}"]`),a=$(selector`[data-formengine-input-name="${e}"]`);let t=$(selector`[name="${n.data("main-field")}"]`);0===t.length&&(t=n);const i=t.data("config");if(void 0!==i){const e=FormEngineValidation.formatByEvals(i,n.val());e.length&&a.val(e)}a.data("main-field",e),a.data("config",i),a.on("change",function(){FormEngineValidation.updateInputField(a.attr("data-formengine-input-name"))}),a.attr("data-formengine-input-initialized","true")},FormEngineValidation.registerCustomEvaluation=function(e,n){customEvaluations.has(e)||customEvaluations.set(e,n)},FormEngineValidation.formatByEvals=function(e,n){if(void 0!==e.evalList){const a=FormEngineValidation.trimExplode(",",e.evalList);for(const e of a)n=FormEngineValidation.formatValue(e,n)}return n},FormEngineValidation.formatValue=function(e,n){switch(e){case"date":case"datetime":case"time":case"timesec":if(""===n||"0"===n)return"";const e=DateTime.fromISO(String(n),{zone:"utc"});if(!e.isValid)throw new Error("Invalid ISO8601 DateTime string: "+n);return e.toISO({suppressMilliseconds:!0});case"password":return n?FormEngineValidation.passwordDummy:"";default:return n.toString()}},FormEngineValidation.updateInputField=function(e){const n=$(selector`[name="${e}"]`);let a=$(selector`[name="${n.data("main-field")}"]`);0===a.length&&(a=n);const t=$(selector`[data-formengine-input-name="${a.attr("name")}"]`),i=a.data("config");if(void 0!==i){const e=FormEngineValidation.processByEvals(i,t.val()),n=FormEngineValidation.formatByEvals(i,e);a.prop("disabled")&&a.data("enableOnModification")&&a.prop("disabled",!1),a.val(e),a.get(0).dispatchEvent(new Event("change")),t.val(n)}},FormEngineValidation.validateField=function(e,n){const a=e instanceof $?e.get(0):e;if(n=n||a.value||"",void 0===a.dataset.formengineValidationRules)return n;const t=JSON.parse(a.dataset.formengineValidationRules);let i=!1,o=0;const r=n;let l,s,m;Array.isArray(n)||(n=n.trimStart());for(const e of t){if(i)break;switch(e.type){case"required":""===n&&(i=!0,a.closest(FormEngineValidation.markerSelector).classList.add(FormEngineValidation.errorClass));break;case"range":if(""!==n){if((e.minItems||e.maxItems)&&(l=$(document).find(selector`[name="${a.dataset.relatedfieldname}"]`),o=l.length?FormEngineValidation.trimExplode(",",l.val()).length:parseInt(a.value,10),void 0!==e.minItems&&(s=1*e.minItems,!isNaN(s)&&o<s&&(i=!0)),void 0!==e.maxItems&&(m=1*e.maxItems,!isNaN(m)&&o>m&&(i=!0))),void 0!==e.lower)if("datetimepicker"===a.dataset.inputType){const a=DateTime.fromISO(n,{zone:"utc"}),t=DateTime.fromISO(e.lower,{zone:"utc"});(!a.isValid||a<t.minus(1e3*t.second))&&(i=!0)}else{const a=1*e.lower;!isNaN(a)&&parseInt(n,10)<a&&(i=!0)}if(void 0!==e.upper)if("datetimepicker"===a.dataset.inputType){const a=DateTime.fromISO(n,{zone:"utc"}),t=DateTime.fromISO(e.upper,{zone:"utc"});(!a.isValid||a>t.plus(1e3*(59-t.second)))&&(i=!0)}else{const a=1*e.upper;!isNaN(a)&&parseInt(n,10)>a&&(i=!0)}}break;case"select":case"category":(e.minItems||e.maxItems)&&(l=$(document).find(selector`[name="${a.dataset.relatedfieldname}"]`),o=l.length?FormEngineValidation.trimExplode(",",l.val()).length:a instanceof HTMLSelectElement?a.querySelectorAll("option:checked").length:a.querySelectorAll("input[value]:checked").length,void 0!==e.minItems&&(s=1*e.minItems,!isNaN(s)&&o<s&&(i=!0)),void 0!==e.maxItems&&(m=1*e.maxItems,!isNaN(m)&&o>m&&(i=!0)));break;case"group":case"folder":case"inline":(e.minItems||e.maxItems)&&(o=FormEngineValidation.trimExplode(",",a.value).length,void 0!==e.minItems&&(s=1*e.minItems,!isNaN(s)&&o<s&&(i=!0)),void 0!==e.maxItems&&(m=1*e.maxItems,!isNaN(m)&&o>m&&(i=!0)));break;case"min":(a instanceof HTMLInputElement||a instanceof HTMLTextAreaElement)&&a.value.length>0&&a.value.length<a.minLength&&(i=!0)}}const d=!i,c=a.closest(FormEngineValidation.markerSelector);return null!==c&&c.classList.toggle(FormEngineValidation.errorClass,!d),FormEngineValidation.markParentTab($(a),d),$(document).trigger("t3-formengine-postfieldvalidation"),r},FormEngineValidation.processByEvals=function(e,n){if(void 0!==e.evalList){const a=FormEngineValidation.trimExplode(",",e.evalList);for(const t of a)n=FormEngineValidation.processValue(t,n,e)}return n},FormEngineValidation.processValue=function(e,n,a){let t="",i="",o=0,r=n;switch(e){case"alpha":case"num":case"alphanum":case"alphanum_x":for(t="",o=0;o<n.length;o++){const a=n.substr(o,1);let i="_"===a||"-"===a,r=a>="a"&&a<="z"||a>="A"&&a<="Z",l=a>="0"&&a<="9";switch(e){case"alphanum":i=!1;break;case"alpha":l=!1,i=!1;break;case"num":r=!1,i=!1}(r||l||i)&&(t+=a)}t!==n&&(r=t);break;case"is_in":if(a.is_in){i=""+n,a.is_in=a.is_in.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");const e=new RegExp("[^"+a.is_in+"]+","g");t=i.replace(e,"")}else t=i;r=t;break;case"nospace":r=(""+n).replace(/ /g,"");break;case"md5":""!==n&&(r=Md5.hash(n));break;case"upper":r=n.toUpperCase();break;case"lower":r=n.toLowerCase();break;case"integer":""!==n&&(r=FormEngineValidation.parseInt(n));break;case"decimal":""!==n&&(r=FormEngineValidation.parseDouble(n));break;case"trim":r=String(n).trim();break;case"time":case"timesec":if(""!==n){r=DateTime.fromISO(n,{zone:"utc"}).set({year:1970,month:1,day:1}).toISO({suppressMilliseconds:!0})}break;case"year":if(""!==n){let e=parseInt(n,10);isNaN(e)&&(e=(new Date).getUTCFullYear()),r=e.toString(10)}break;case"null":case"password":break;default:customEvaluations.has(e)?r=customEvaluations.get(e).call(null,n):"object"==typeof TBE_EDITOR&&void 0!==TBE_EDITOR.customEvalFunctions&&"function"==typeof TBE_EDITOR.customEvalFunctions[e]&&(r=TBE_EDITOR.customEvalFunctions[e](n))}return r},FormEngineValidation.validate=function(e){(void 0===e||e instanceof Document)&&$(document).find(FormEngineValidation.markerSelector+", .t3js-tabmenu-item").removeClass(FormEngineValidation.errorClass).removeClass("has-validation-error");const n=e||document;for(const e of n.querySelectorAll(FormEngineValidation.rulesSelector)){const n=$(e);if(!n.closest(".t3js-flex-section-deleted, .t3js-inline-record-deleted, .t3js-file-reference-deleted").length){let e=!1;const a=n.val(),t=FormEngineValidation.validateField(n,a);if(Array.isArray(t)&&Array.isArray(a)){if(t.length!==a.length)e=!0;else for(let n=0;n<t.length;n++)if(t[n]!==a[n]){e=!0;break}}else t.length&&a!==t&&(e=!0);e&&(n.prop("disabled")&&n.data("enableOnModification")&&n.prop("disabled",!1),n.val(t))}}},FormEngineValidation.markFieldAsChanged=function(e){if(e instanceof $&&(e=e.get(0)),!(e instanceof HTMLElement))return;const n=e.closest(".t3js-formengine-palette-field");null!==n&&n.classList.add("has-change")},FormEngineValidation.trimExplode=function(e,n){const a=[],t=n.split(e);for(let e=0;e<t.length;e++){const n=t[e].trim();n.length>0&&a.push(n)}return a},FormEngineValidation.parseInt=function(e){if(!e)return 0;const n=parseInt(""+e,10);return isNaN(n)?0:n},FormEngineValidation.parseDouble=function(e,n=2){let a=""+e;a=a.replace(/[^0-9,.-]/g,"");const t=a.startsWith("-");a=a.replace(/-/g,""),a=a.replace(/,/g,"."),-1===a.indexOf(".")&&(a+=".0");const i=a.split("."),o=i.pop();let r=Number(i.join("")+"."+o);return t&&(r*=-1),a=r.toFixed(n),a},FormEngineValidation.pol=function(foreign,value){return eval(("-"==foreign?"-":"")+value)},FormEngineValidation.markParentTab=function(e,n){e.parents(".tab-pane").each(function(e,a){const t=$(a);n&&(n=0===t.find(".has-error").length);const i=t.attr("id");$(document).find('a[href="#'+i+'"]').closest(".t3js-tabmenu-item").toggleClass("has-validation-error",!n)})},FormEngineValidation.isValid=function(){return null===document.querySelector("."+FormEngineValidation.errorClass)},FormEngineValidation.showErrorModal=function(){const e=Modal.confirm(TYPO3.lang.alert||"Alert",TYPO3.lang["FormEngine.fieldsMissing"],Severity.error,[{text:TYPO3.lang["button.ok"]||"OK",active:!0,btnClass:"btn-default",name:"ok"}]);e.addEventListener("button.clicked",()=>e.hideModal())},FormEngineValidation.registerSubmitCallback=function(){DocumentSaveActions.getInstance().addPreSubmitCallback(function(e){FormEngineValidation.isValid()||(FormEngineValidation.showErrorModal(),e.stopImmediatePropagation())})},FormEngineValidation}());