/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import Icons from"@typo3/backend/icons.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import Viewport from"@typo3/backend/viewport.js";import SecurityUtility from"@typo3/core/security-utility.js";import{ModuleStateStorage}from"@typo3/backend/storage/module-state-storage.js";import"@typo3/backend/element/spinner-element.js";import{Sizes}from"@typo3/backend/enum/icon-types.js";import RegularEvent from"@typo3/core/event/regular-event.js";var Identifiers;!function(e){e.containerSelector="#typo3-cms-backend-backend-toolbaritems-shortcuttoolbaritem",e.toolbarIconSelector=".dropdown-toggle span.icon",e.toolbarMenuSelector=".dropdown-menu",e.shortcutItemSelector=".t3js-topbar-shortcut",e.shortcutJumpSelector=".t3js-shortcut-jump",e.shortcutDeleteSelector=".t3js-shortcut-delete",e.shortcutEditSelector=".t3js-shortcut-edit",e.shortcutFormSelector=".t3js-shortcut-form",e.createShortcutSelector='[data-dispatch-action="TYPO3.ShortcutMenu.createShortcut"]'}(Identifiers||(Identifiers={}));class ShortcutMenu{constructor(){this.initializeEvents=()=>{const e=document.querySelector(Identifiers.containerSelector);new RegularEvent("click",(e,t)=>{e.preventDefault(),e.stopImmediatePropagation();const o=t.closest(Identifiers.shortcutItemSelector);this.deleteShortcut(parseInt(o.dataset.shortcutid,10))}).delegateTo(e,Identifiers.shortcutDeleteSelector),new RegularEvent("click",(e,t)=>{e.preventDefault(),e.stopImmediatePropagation();const o=t.closest(Identifiers.shortcutItemSelector);this.editShortcut(parseInt(o.dataset.shortcutid,10),o.dataset.shortcutgroup)}).delegateTo(e,Identifiers.shortcutEditSelector),new RegularEvent("submit",(e,t)=>{e.preventDefault(),e.stopImmediatePropagation(),this.saveShortcutForm(t)}).delegateTo(e,Identifiers.shortcutFormSelector),new RegularEvent("reset",e=>{e.preventDefault(),e.stopImmediatePropagation(),this.refreshMenu()}).delegateTo(e,Identifiers.shortcutFormSelector),new RegularEvent("click",(e,t)=>{e.preventDefault();const o=t.dataset.pageId;o&&ModuleStateStorage.updateWithCurrentMount("web",o,!0);const r=document.querySelector("typo3-backend-module-router");r.setAttribute("endpoint",t.href),r.setAttribute("module",t.dataset.module)}).delegateTo(e,Identifiers.shortcutJumpSelector)},Viewport.Topbar.Toolbar.registerEvent(this.initializeEvents)}createShortcut(e,t,o,r,s){new AjaxRequest(TYPO3.settings.ajaxUrls.shortcut_create).post({routeIdentifier:e,arguments:t,displayName:o}).then(async e=>{const t=await e.resolve();if("success"===t.result?Notification.success(TYPO3.lang["bookmark.savedTitle"],TYPO3.lang["bookmark.savedMessage"]):"alreadyExists"===t.result&&Notification.info(TYPO3.lang["bookmark.alreadyExistsTitle"],TYPO3.lang["bookmark.alreadyExistsMessage"]),this.refreshMenu(),"object"!=typeof s)return void console.warn("Expected argument shortcutButton to be an object, got "+typeof s);const o=s.classList.contains("dropdown-item"),r=new SecurityUtility;Icons.getIcon("actions-system-shortcut-active",Icons.sizes.small).then(e=>{s.innerHTML=e+(o?" "+r.encodeHtml(TYPO3.lang["labels.alreadyBookmarked"]):"")}),o?s.setAttribute("disabled","disabled"):s.classList.add("active"),s.dataset.dispatchDisabled="disabled",s.title=r.encodeHtml(TYPO3.lang["labels.alreadyBookmarked"])}).catch(()=>{Notification.error(TYPO3.lang["bookmark.failedTitle"],TYPO3.lang["bookmark.failedMessage"])})}deleteShortcut(e){const t=Modal.confirm(TYPO3.lang["bookmark.delete"],TYPO3.lang["bookmark.confirmDelete"]);t.addEventListener("confirm.button.ok",()=>{new AjaxRequest(TYPO3.settings.ajaxUrls.shortcut_remove).post({shortcutId:e}).then(async e=>{const t=await e.resolve();this.refreshMenu(),this.checkIfEnableBookmarkLink(t.data)}),t.hideModal()}),t.addEventListener("confirm.button.cancel",()=>{t.hideModal()})}editShortcut(e,t){new AjaxRequest(TYPO3.settings.ajaxUrls.shortcut_editform).withQueryArguments({shortcutId:e,shortcutGroup:t}).get({cache:"no-cache"}).then(async e=>{document.querySelector(Identifiers.containerSelector+" "+Identifiers.toolbarMenuSelector).innerHTML=await e.resolve()})}saveShortcutForm(e){new AjaxRequest(TYPO3.settings.ajaxUrls.shortcut_saveform).post(new FormData(e)).then(()=>{Notification.success(TYPO3.lang["bookmark.savedTitle"],TYPO3.lang["bookmark.savedMessage"]),this.refreshMenu()})}refreshMenu(){const e=document.querySelector(Identifiers.containerSelector+" "+Identifiers.toolbarIconSelector),t=e.cloneNode(!0),o=document.createElement("typo3-backend-spinner");o.setAttribute("size",Sizes.small),e.replaceWith(o),new AjaxRequest(TYPO3.settings.ajaxUrls.shortcut_list).get({cache:"no-cache"}).then(async e=>{document.querySelector(Identifiers.containerSelector+" "+Identifiers.toolbarMenuSelector).innerHTML=await e.resolve()}).finally(()=>{document.querySelector(Identifiers.containerSelector+" typo3-backend-spinner").replaceWith(t)})}checkIfEnableBookmarkLink(e){const t=top.list_frame?.document.querySelector(Identifiers.createShortcutSelector);if(!t)return;const o=JSON.parse(t.dataset.dispatchArgs.replace(/&quot;/g,'"'));if(o[0]!==e.route||o[1]!==e.args)return;const r=new SecurityUtility,s=t.classList.contains("dropdown-item");Icons.getIcon("actions-system-shortcut-new",Icons.sizes.small).then(e=>{t.innerHTML=e+(s?" "+r.encodeHtml(TYPO3.lang["labels.makeBookmark"]):"")}),t.title=r.encodeHtml(TYPO3.lang["labels.makeBookmark"]),delete t.dataset.dispatchDisabled,s?t.removeAttribute("disabled"):t.classList.remove("active")}}top.TYPO3.ShortcutMenu&&"object"==typeof top.TYPO3.ShortcutMenu||(top.TYPO3.ShortcutMenu=new ShortcutMenu);const shortcutMenuObject=top.TYPO3.ShortcutMenu;export default shortcutMenuObject;