/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import SortableTable from"@typo3/backend/sortable-table.js";import DocumentSaveActions from"@typo3/backend/document-save-actions.js";import RegularEvent from"@typo3/core/event/regular-event.js";import Modal from"@typo3/backend/modal.js";import Icons from"@typo3/backend/icons.js";import{MessageUtility}from"@typo3/backend/utility/message-utility.js";import PersistentStorage from"@typo3/backend/storage/persistent.js";import DateTimePicker from"@typo3/backend/date-time-picker.js";import{MultiRecordSelectionSelectors}from"@typo3/backend/multi-record-selection.js";import Severity from"@typo3/backend/severity.js";import DocumentService from"@typo3/core/document-service.js";class Scheduler{constructor(){DocumentService.ready().then((()=>{this.initializeEvents(),this.initializeDefaultStates(),this.initializeCloseConfirm()})),DocumentSaveActions.getInstance().addPreSubmitCallback((()=>{document.querySelector("#extraFieldsHidden").append(...document.querySelectorAll(".extraFields[hidden]"))}))}static updateClearableInputs(){const e=document.querySelectorAll(".t3js-clearable");e.length>0&&import("@typo3/backend/input/clearable.js").then((function(){e.forEach((e=>e.clearable()))}))}static updateDateTimePickers(){document.querySelectorAll("#tx_scheduler_form .t3js-datetimepicker").forEach((e=>DateTimePicker.initialize(e)))}static updateElementBrowserTriggers(){document.querySelectorAll(".t3js-element-browser").forEach((e=>{const t=document.getElementById(e.dataset.triggerFor);e.dataset.params=t.name+"|||pages"}))}static resolveDefaultNumberOfDays(){const e=document.getElementById("task_tableGarbageCollection_numberOfDays");return null===e||void 0===e.dataset.defaultNumberOfDays?null:JSON.parse(e.dataset.defaultNumberOfDays)}static storeCollapseState(e,t){let a={};PersistentStorage.isset("moduleData.scheduler_manage")&&(a=PersistentStorage.get("moduleData.scheduler_manage"));const n={};n[e]=t?1:0,a={...a,...n},PersistentStorage.set("moduleData.scheduler_manage",a)}actOnChangedTaskClass(e){let t=e.value;t=t.toLowerCase().replace(/\\/g,"-");for(const e of document.querySelectorAll(".extraFields"))e.hidden=!e.classList.contains("extra_fields_"+t)}actOnChangeSchedulerTableGarbageCollectionAllTables(e){const t=document.querySelector("#task_tableGarbageCollection_numberOfDays"),a=document.querySelector("#task_tableGarbageCollection_table");if(e.checked)a.disabled=!0,t.disabled=!0;else{let e=parseInt(t.value,10);if(e<1){const t=a.value,n=Scheduler.resolveDefaultNumberOfDays();null!==n&&(e=n[t])}a.disabled=!1,e>0&&(t.disabled=!1)}}actOnChangeSchedulerTableGarbageCollectionTable(e){const t=document.querySelector("#task_tableGarbageCollection_numberOfDays"),a=Scheduler.resolveDefaultNumberOfDays();null!==a&&a[e.value]>0?(t.disabled=!1,t.value=a[e.value].toString(10)):(t.disabled=!0,t.value="0")}toggleFieldsByTaskType(e){const t=2===(e=parseInt(e+"",10));document.querySelector("#task_end_col").hidden=!t,document.querySelector("#task_frequency_row").hidden=!t,document.querySelector("#task_multiple_row").hidden=!t}initializeEvents(){const e=document.querySelector("#task_class");e&&new RegularEvent("change",(e=>{this.actOnChangedTaskClass(e.target)})).bindTo(e);const t=document.querySelector("#task_type");t&&new RegularEvent("change",(e=>{this.toggleFieldsByTaskType(e.target.value)})).bindTo(t);const a=document.querySelector("#task_tableGarbageCollection_allTables");a&&new RegularEvent("change",(e=>{this.actOnChangeSchedulerTableGarbageCollectionAllTables(e.target)})).bindTo(a);const n=document.querySelector("#task_tableGarbageCollection_table");n&&new RegularEvent("change",(e=>{this.actOnChangeSchedulerTableGarbageCollectionTable(e.target)})).bindTo(n);const o=document.querySelector("[data-update-task-frequency]");o&&new RegularEvent("change",(e=>{const t=e.target;document.querySelector("#task_frequency").value=t.value,t.value="",t.blur()})).bindTo(o),document.querySelectorAll("[data-scheduler-table]").forEach((e=>{new SortableTable(e)})),new RegularEvent("click",((e,t)=>{e.preventDefault();const a=new URL(t.href,window.origin);a.searchParams.set("mode",t.dataset.mode),a.searchParams.set("bparams",t.dataset.params),Modal.advanced({type:Modal.types.iframe,content:a.toString(),size:Modal.sizes.large})})).delegateTo(document,".t3js-element-browser"),new RegularEvent("show.bs.collapse",this.toggleCollapseIcon.bind(this)).bindTo(document),new RegularEvent("hide.bs.collapse",this.toggleCollapseIcon.bind(this)).bindTo(document),new RegularEvent("multiRecordSelection:action:go",this.executeTasks.bind(this)).bindTo(document),new RegularEvent("multiRecordSelection:action:go_cron",this.executeTasks.bind(this)).bindTo(document),window.addEventListener("message",this.listenOnElementBrowser.bind(this))}initializeDefaultStates(){const e=document.querySelector("#task_type");null!==e&&this.toggleFieldsByTaskType(e.value);const t=document.querySelector("#task_class");null!==t&&(this.actOnChangedTaskClass(t),Scheduler.updateClearableInputs(),Scheduler.updateDateTimePickers(),Scheduler.updateElementBrowserTriggers())}listenOnElementBrowser(e){if(!MessageUtility.verifyOrigin(e.origin))throw"Denied message sent by "+e.origin;if("typo3:elementBrowser:elementAdded"===e.data.actionName){if(void 0===e.data.fieldName)throw"fieldName not defined in message";if(void 0===e.data.value)throw"value not defined in message";document.querySelector('input[name="'+e.data.fieldName+'"]').value=e.data.value.split("_").pop()}}toggleCollapseIcon(e){const t="hide.bs.collapse"===e.type,a=document.querySelector('.t3js-toggle-table[data-bs-target="#'+e.target.id+'"] .t3js-icon');null!==a&&Icons.getIcon(t?"actions-view-list-expand":"actions-view-list-collapse",Icons.sizes.small).then((e=>{a.replaceWith(document.createRange().createContextualFragment(e))})),Scheduler.storeCollapseState(e.target.dataset.table,t)}executeTasks(e){const t=document.querySelector('[data-multi-record-selection-form="'+e.detail.identifier+'"]');if(null===t)return;const a=[];if(e.detail.checkboxes.forEach((e=>{const t=e.closest(MultiRecordSelectionSelectors.elementSelector);null!==t&&t.dataset.taskId&&a.push(t.dataset.taskId)})),a.length){if("multiRecordSelection:action:go_cron"===e.type){const e=document.createElement("input");e.setAttribute("type","hidden"),e.setAttribute("name","scheduleCron"),e.setAttribute("value",a.join(",")),t.append(e)}else{const e=document.createElement("input");e.setAttribute("type","hidden"),e.setAttribute("name","execute"),e.setAttribute("value",a.join(",")),t.append(e)}t.submit()}}initializeCloseConfirm(){const e=document.querySelector("form[name=tx_scheduler_form]");if(!e)return;const t=new FormData(e);new RegularEvent("click",(a=>{const n=new FormData(e),o=Object.fromEntries(t.entries()),l=Object.fromEntries(n.entries());if(JSON.stringify(o)!==JSON.stringify(l)||e.querySelector('input[value="add"]')){a.preventDefault();const t=a.currentTarget.href;Modal.confirm(TYPO3.lang["label.confirm.close_without_save.title"]||"Do you want to close without saving?",TYPO3.lang["label.confirm.close_without_save.content"]||"You currently have unsaved changes. Are you sure you want to discard these changes?",Severity.warning,[{text:TYPO3.lang["buttons.confirm.close_without_save.no"]||"No, I will continue editing",btnClass:"btn-default",name:"no",trigger:()=>Modal.dismiss()},{text:TYPO3.lang["buttons.confirm.close_without_save.yes"]||"Yes, discard my changes",btnClass:"btn-default",name:"yes",trigger:()=>{Modal.dismiss(),window.location.href=t}},{text:TYPO3.lang["buttons.confirm.save_and_close"]||"Save and close",btnClass:"btn-primary",name:"save",active:!0,trigger:()=>{Modal.dismiss();const t=document.createElement("input");t.type="hidden",t.value="saveclose",t.name="CMD",e.append(t),e.submit()}}])}})).bindTo(document.querySelector(".t3js-scheduler-close"))}}export default new Scheduler;