<?php

namespace garethp\ews\API\Type;

/**
 * Class representing WeeklyRecurrencePatternType
 *
 *
 * XSD Type: WeeklyRecurrencePatternType
 */
class WeeklyRecurrencePatternType extends IntervalRecurrencePatternBaseType
{

    /**
     * @var string[]
     */
    protected $daysOfWeek = null;

    /**
     * @var string
     */
    protected $firstDayOfWeek = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return WeeklyRecurrencePatternType
     */
    public function addDaysOfWeek($value)
    {
        if ($this->daysOfWeek === null) {
                        $this->daysOfWeek = array();
        }

        if (!is_array($this->daysOfWeek)) {
            $this->daysOfWeek = array($this->daysOfWeek);
        }

        $this->daysOfWeek[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getDaysOfWeek()
    {
        return $this->daysOfWeek;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return WeeklyRecurrencePatternType
     */
    public function setDaysOfWeek(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->daysOfWeek = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getFirstDayOfWeek()
    {
        return $this->firstDayOfWeek;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return WeeklyRecurrencePatternType
     */
    public function setFirstDayOfWeek($value)
    {
        $this->firstDayOfWeek = $value;
        return $this;
    }
}
