<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing UserMailboxType
 *
 * User Mailbox.
 * XSD Type: UserMailboxType
 */
class UserMailboxType extends Type
{

    /**
     * @var string
     */
    protected $id = null;

    /**
     * @var boolean
     */
    protected $isArchive = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserMailboxType
     */
    public function setId($value)
    {
        $this->id = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isArchive()
    {
        return ((bool) $this->isArchive);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsArchive()
    {
        return $this->isArchive;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return UserMailboxType
     */
    public function setIsArchive($value)
    {
        $this->isArchive = $value;
        return $this;
    }
}
