<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing UserIdType
 *
 *
 * XSD Type: UserIdType
 */
class UserIdType extends Type
{

    /**
     * @var string
     */
    protected $sID = null;

    /**
     * @var string
     */
    protected $primarySmtpAddress = null;

    /**
     * @var string
     */
    protected $displayName = null;

    /**
     * @var string
     */
    protected $distinguishedUser = null;

    /**
     * @var string
     */
    protected $externalUserIdentity = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSID()
    {
        return $this->sID;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserIdType
     */
    public function setSID($value)
    {
        $this->sID = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPrimarySmtpAddress()
    {
        return $this->primarySmtpAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserIdType
     */
    public function setPrimarySmtpAddress($value)
    {
        $this->primarySmtpAddress = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserIdType
     */
    public function setDisplayName($value)
    {
        $this->displayName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDistinguishedUser()
    {
        return $this->distinguishedUser;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserIdType
     */
    public function setDistinguishedUser($value)
    {
        $this->distinguishedUser = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getExternalUserIdentity()
    {
        return $this->externalUserIdentity;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserIdType
     */
    public function setExternalUserIdentity($value)
    {
        $this->externalUserIdentity = $value;
        return $this;
    }
}
