<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing UserConfigurationType
 *
 *
 * XSD Type: UserConfigurationType
 */
class UserConfigurationType extends Type
{

    /**
     * @var \garethp\ews\API\Type\UserConfigurationNameType
     */
    protected $userConfigurationName = null;

    /**
     * @var \garethp\ews\API\Type\ItemIdType
     */
    protected $itemId = null;

    /**
     * @var \garethp\ews\API\Type\UserConfigurationDictionaryEntryType[]
     */
    protected $dictionary = null;

    /**
     * @var string
     */
    protected $xmlData = null;

    /**
     * @var string
     */
    protected $binaryData = null;

    /**
     * @autogenerated This method is safe to replace
     * @return UserConfigurationNameType
     */
    public function getUserConfigurationName()
    {
        return $this->userConfigurationName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value UserConfigurationNameType
     * @return UserConfigurationType
     */
    public function setUserConfigurationName(UserConfigurationNameType $value)
    {
        $this->userConfigurationName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemIdType
     */
    public function getItemId()
    {
        return $this->itemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType
     * @return UserConfigurationType
     */
    public function setItemId(ItemIdType $value)
    {
        $this->itemId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value UserConfigurationDictionaryEntryType
     * @return UserConfigurationType
     */
    public function addDictionary(UserConfigurationDictionaryEntryType $value)
    {
        if ($this->dictionary === null) {
                        $this->dictionary = array();
        }

        if (!is_array($this->dictionary)) {
            $this->dictionary = array($this->dictionary);
        }

        $this->dictionary[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return UserConfigurationDictionaryEntryType[]
     */
    public function getDictionary()
    {
        return $this->dictionary;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * UserConfigurationDictionaryEntryType[]|UserConfigurationDictionaryEntryType
     * @return UserConfigurationType
     */
    public function setDictionary(array|UserConfigurationDictionaryEntryType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->dictionary = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getXmlData()
    {
        return $this->xmlData;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserConfigurationType
     */
    public function setXmlData($value)
    {
        $this->xmlData = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getBinaryData()
    {
        return $this->binaryData;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UserConfigurationType
     */
    public function setBinaryData($value)
    {
        $this->binaryData = $value;
        return $this;
    }
}
