<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing UploadItemType
 *
 *
 * XSD Type: UploadItemType
 */
class UploadItemType extends Type
{

    /**
     * @var string
     */
    protected $createAction = null;

    /**
     * @var boolean
     */
    protected $isAssociated = null;

    /**
     * @var \garethp\ews\API\Type\FolderIdType
     */
    protected $parentFolderId = null;

    /**
     * @var \garethp\ews\API\Type\ItemIdType
     */
    protected $itemId = null;

    /**
     * @var string
     */
    protected $data = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getCreateAction()
    {
        return $this->createAction;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UploadItemType
     */
    public function setCreateAction($value)
    {
        $this->createAction = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isAssociated()
    {
        return ((bool) $this->isAssociated);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsAssociated()
    {
        return $this->isAssociated;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return UploadItemType
     */
    public function setIsAssociated($value)
    {
        $this->isAssociated = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FolderIdType
     */
    public function getParentFolderId()
    {
        return $this->parentFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FolderIdType
     * @return UploadItemType
     */
    public function setParentFolderId(FolderIdType $value)
    {
        $this->parentFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemIdType
     */
    public function getItemId()
    {
        return $this->itemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType
     * @return UploadItemType
     */
    public function setItemId(ItemIdType $value)
    {
        $this->itemId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UploadItemType
     */
    public function setData($value)
    {
        $this->data = $value;
        return $this;
    }
}
