<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing TimeZoneType
 *
 *
 * XSD Type: TimeZoneType
 */
class TimeZoneType extends Type
{

    /**
     * @var string
     */
    protected $timeZoneName = null;

    /**
     * @var \DateInterval
     */
    protected $baseOffset = null;

    /**
     * @var \garethp\ews\API\Type\TimeChangeType
     */
    protected $standard = null;

    /**
     * @var \garethp\ews\API\Type\TimeChangeType
     */
    protected $daylight = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getTimeZoneName()
    {
        return $this->timeZoneName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return TimeZoneType
     */
    public function setTimeZoneName($value)
    {
        $this->timeZoneName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateInterval
     */
    public function getBaseOffset()
    {
        return $this->baseOffset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateInterval|string
     * @return TimeZoneType
     */
    public function setBaseOffset(\DateInterval|string $value)
    {
        if (is_string($value)) {
            $invert = false;
            if (str_starts_with($value, "-")) {
                $invert = true;
                $value = substr($value, 1);
            }
            $value = new \DateInterval($value);
            $value->invert = $invert;
        }

        $this->baseOffset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TimeChangeType
     */
    public function getStandard()
    {
        return $this->standard;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TimeChangeType
     * @return TimeZoneType
     */
    public function setStandard(TimeChangeType $value)
    {
        $this->standard = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TimeChangeType
     */
    public function getDaylight()
    {
        return $this->daylight;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TimeChangeType
     * @return TimeZoneType
     */
    public function setDaylight(TimeChangeType $value)
    {
        $this->daylight = $value;
        return $this;
    }
}
