<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing SmtpDomainType
 *
 *
 * XSD Type: SmtpDomain
 */
class SmtpDomainType extends Type
{

    /**
     * @var string
     */
    protected $name = null;

    /**
     * @var boolean
     */
    protected $includeSubdomains = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return SmtpDomainType
     */
    public function setName($value)
    {
        $this->name = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludeSubdomains()
    {
        return ((bool) $this->includeSubdomains);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludeSubdomains()
    {
        return $this->includeSubdomains;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return SmtpDomainType
     */
    public function setIncludeSubdomains($value)
    {
        $this->includeSubdomains = $value;
        return $this;
    }
}
