<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing RecipientTrackingEventType
 *
 *
 * XSD Type: RecipientTrackingEventType
 */
class RecipientTrackingEventType extends Type
{

    /**
     * @var \DateTime
     */
    protected $date = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $recipient = null;

    /**
     * @var string
     */
    protected $deliveryStatus = null;

    /**
     * @var string
     */
    protected $eventDescription = null;

    /**
     * @var string[]
     */
    protected $eventData = null;

    /**
     * @var string
     */
    protected $server = null;

    /**
     * @var integer
     */
    protected $internalId = null;

    /**
     * @var boolean
     */
    protected $bccRecipient = null;

    /**
     * @var boolean
     */
    protected $hiddenRecipient = null;

    /**
     * @var string
     */
    protected $uniquePathId = null;

    /**
     * @var string
     */
    protected $rootAddress = null;

    /**
     * @var \garethp\ews\API\Type\TrackingPropertyType[]
     */
    protected $properties = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return RecipientTrackingEventType
     */
    public function setDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->date = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getRecipient()
    {
        return $this->recipient;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return RecipientTrackingEventType
     */
    public function setRecipient(EmailAddressType $value)
    {
        $this->recipient = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDeliveryStatus()
    {
        return $this->deliveryStatus;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RecipientTrackingEventType
     */
    public function setDeliveryStatus($value)
    {
        $this->deliveryStatus = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getEventDescription()
    {
        return $this->eventDescription;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RecipientTrackingEventType
     */
    public function setEventDescription($value)
    {
        $this->eventDescription = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RecipientTrackingEventType
     */
    public function addEventData($value)
    {
        if ($this->eventData === null) {
                        $this->eventData = array();
        }

        if (!is_array($this->eventData)) {
            $this->eventData = array($this->eventData);
        }

        $this->eventData[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getEventData()
    {
        return $this->eventData;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return RecipientTrackingEventType
     */
    public function setEventData(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->eventData = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getServer()
    {
        return $this->server;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RecipientTrackingEventType
     */
    public function setServer($value)
    {
        $this->server = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getInternalId()
    {
        return $this->internalId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return RecipientTrackingEventType
     */
    public function setInternalId($value)
    {
        $this->internalId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isBccRecipient()
    {
        return ((bool) $this->bccRecipient);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getBccRecipient()
    {
        return $this->bccRecipient;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return RecipientTrackingEventType
     */
    public function setBccRecipient($value)
    {
        $this->bccRecipient = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isHiddenRecipient()
    {
        return ((bool) $this->hiddenRecipient);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getHiddenRecipient()
    {
        return $this->hiddenRecipient;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return RecipientTrackingEventType
     */
    public function setHiddenRecipient($value)
    {
        $this->hiddenRecipient = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getUniquePathId()
    {
        return $this->uniquePathId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RecipientTrackingEventType
     */
    public function setUniquePathId($value)
    {
        $this->uniquePathId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getRootAddress()
    {
        return $this->rootAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RecipientTrackingEventType
     */
    public function setRootAddress($value)
    {
        $this->rootAddress = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TrackingPropertyType
     * @return RecipientTrackingEventType
     */
    public function addProperties(TrackingPropertyType $value)
    {
        if ($this->properties === null) {
                        $this->properties = array();
        }

        if (!is_array($this->properties)) {
            $this->properties = array($this->properties);
        }

        $this->properties[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TrackingPropertyType[]
     */
    public function getProperties()
    {
        return $this->properties;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TrackingPropertyType[]|TrackingPropertyType
     * @return RecipientTrackingEventType
     */
    public function setProperties(array|TrackingPropertyType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->properties = $value;
        return $this;
    }
}
