<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ProtectionRuleConditionType
 *
 *
 * XSD Type: ProtectionRuleConditionType
 */
class ProtectionRuleConditionType extends Type
{

    /**
     * @var string
     */
    protected $allInternal = null;

    /**
     * @var \garethp\ews\API\Type\ProtectionRuleAndType
     */
    protected $and = null;

    /**
     * @var string[]
     */
    protected $recipientIs = null;

    /**
     * @var string[]
     */
    protected $senderDepartments = null;

    /**
     * @var string
     */
    protected $true = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getAllInternal()
    {
        return $this->allInternal;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ProtectionRuleConditionType
     */
    public function setAllInternal($value)
    {
        $this->allInternal = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ProtectionRuleAndType
     */
    public function getAnd()
    {
        return $this->and;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ProtectionRuleAndType
     * @return ProtectionRuleConditionType
     */
    public function setAnd(ProtectionRuleAndType $value)
    {
        $this->and = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ProtectionRuleConditionType
     */
    public function addRecipientIs($value)
    {
        if ($this->recipientIs === null) {
                        $this->recipientIs = array();
        }

        if (!is_array($this->recipientIs)) {
            $this->recipientIs = array($this->recipientIs);
        }

        $this->recipientIs[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getRecipientIs()
    {
        return $this->recipientIs;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ProtectionRuleConditionType
     */
    public function setRecipientIs(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->recipientIs = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ProtectionRuleConditionType
     */
    public function addSenderDepartments($value)
    {
        if ($this->senderDepartments === null) {
                        $this->senderDepartments = array();
        }

        if (!is_array($this->senderDepartments)) {
            $this->senderDepartments = array($this->senderDepartments);
        }

        $this->senderDepartments[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getSenderDepartments()
    {
        return $this->senderDepartments;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ProtectionRuleConditionType
     */
    public function setSenderDepartments(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->senderDepartments = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getTrue()
    {
        return $this->true;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ProtectionRuleConditionType
     */
    public function setTrue($value)
    {
        $this->true = $value;
        return $this;
    }
}
