<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ProtectionRuleActionType
 *
 *
 * XSD Type: ProtectionRuleActionType
 */
class ProtectionRuleActionType extends Type
{

    /**
     * @var string
     */
    protected $name = null;

    /**
     * @var \garethp\ews\API\Type\ProtectionRuleArgumentType[]
     */
    protected $argument = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ProtectionRuleActionType
     */
    public function setName($value)
    {
        $this->name = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ProtectionRuleArgumentType
     * @return ProtectionRuleActionType
     */
    public function addArgument(ProtectionRuleArgumentType $value)
    {
        if ($this->argument === null) {
                        $this->argument = array();
        }

        if (!is_array($this->argument)) {
            $this->argument = array($this->argument);
        }

        $this->argument[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ProtectionRuleArgumentType[]
     */
    public function getArgument()
    {
        return $this->argument;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ProtectionRuleArgumentType[]|ProtectionRuleArgumentType
     * @return ProtectionRuleActionType
     */
    public function setArgument(array|ProtectionRuleArgumentType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->argument = $value;
        return $this;
    }
}
