<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing NonEmptyArrayOfResponseObjectsType
 *
 *
 * XSD Type: NonEmptyArrayOfResponseObjectsType
 */
class NonEmptyArrayOfResponseObjectsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\AcceptItemType[]
     */
    protected $acceptItem = null;

    /**
     * @var \garethp\ews\API\Type\TentativelyAcceptItemType[]
     */
    protected $tentativelyAcceptItem = null;

    /**
     * @var \garethp\ews\API\Type\DeclineItemType[]
     */
    protected $declineItem = null;

    /**
     * @var \garethp\ews\API\Type\ReplyToItemType[]
     */
    protected $replyToItem = null;

    /**
     * @var \garethp\ews\API\Type\ForwardItemType[]
     */
    protected $forwardItem = null;

    /**
     * @var \garethp\ews\API\Type\ReplyAllToItemType[]
     */
    protected $replyAllToItem = null;

    /**
     * @var \garethp\ews\API\Type\CancelCalendarItemType[]
     */
    protected $cancelCalendarItem = null;

    /**
     * @var \garethp\ews\API\Type\RemoveItemType[]
     */
    protected $removeItem = null;

    /**
     * @var \garethp\ews\API\Type\SuppressReadReceiptType[]
     */
    protected $suppressReadReceipt = null;

    /**
     * @var \garethp\ews\API\Type\PostReplyItemType[]
     */
    protected $postReplyItem = null;

    /**
     * @var \garethp\ews\API\Type\AcceptSharingInvitationType[]
     */
    protected $acceptSharingInvitation = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value AcceptItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addAcceptItem(AcceptItemType $value)
    {
        if ($this->acceptItem === null) {
                        $this->acceptItem = array();
        }

        if (!is_array($this->acceptItem)) {
            $this->acceptItem = array($this->acceptItem);
        }

        $this->acceptItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AcceptItemType[]
     */
    public function getAcceptItem()
    {
        return $this->acceptItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setAcceptItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->acceptItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TentativelyAcceptItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addTentativelyAcceptItem(TentativelyAcceptItemType $value)
    {
        if ($this->tentativelyAcceptItem === null) {
                        $this->tentativelyAcceptItem = array();
        }

        if (!is_array($this->tentativelyAcceptItem)) {
            $this->tentativelyAcceptItem = array($this->tentativelyAcceptItem);
        }

        $this->tentativelyAcceptItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TentativelyAcceptItemType[]
     */
    public function getTentativelyAcceptItem()
    {
        return $this->tentativelyAcceptItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setTentativelyAcceptItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->tentativelyAcceptItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DeclineItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addDeclineItem(DeclineItemType $value)
    {
        if ($this->declineItem === null) {
                        $this->declineItem = array();
        }

        if (!is_array($this->declineItem)) {
            $this->declineItem = array($this->declineItem);
        }

        $this->declineItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DeclineItemType[]
     */
    public function getDeclineItem()
    {
        return $this->declineItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setDeclineItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->declineItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ReplyToItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addReplyToItem(ReplyToItemType $value)
    {
        if ($this->replyToItem === null) {
                        $this->replyToItem = array();
        }

        if (!is_array($this->replyToItem)) {
            $this->replyToItem = array($this->replyToItem);
        }

        $this->replyToItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ReplyToItemType[]
     */
    public function getReplyToItem()
    {
        return $this->replyToItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setReplyToItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->replyToItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ForwardItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addForwardItem(ForwardItemType $value)
    {
        if ($this->forwardItem === null) {
                        $this->forwardItem = array();
        }

        if (!is_array($this->forwardItem)) {
            $this->forwardItem = array($this->forwardItem);
        }

        $this->forwardItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ForwardItemType[]
     */
    public function getForwardItem()
    {
        return $this->forwardItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setForwardItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->forwardItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ReplyAllToItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addReplyAllToItem(ReplyAllToItemType $value)
    {
        if ($this->replyAllToItem === null) {
                        $this->replyAllToItem = array();
        }

        if (!is_array($this->replyAllToItem)) {
            $this->replyAllToItem = array($this->replyAllToItem);
        }

        $this->replyAllToItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ReplyAllToItemType[]
     */
    public function getReplyAllToItem()
    {
        return $this->replyAllToItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setReplyAllToItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->replyAllToItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CancelCalendarItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addCancelCalendarItem(CancelCalendarItemType $value)
    {
        if ($this->cancelCalendarItem === null) {
                        $this->cancelCalendarItem = array();
        }

        if (!is_array($this->cancelCalendarItem)) {
            $this->cancelCalendarItem = array($this->cancelCalendarItem);
        }

        $this->cancelCalendarItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CancelCalendarItemType[]
     */
    public function getCancelCalendarItem()
    {
        return $this->cancelCalendarItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setCancelCalendarItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->cancelCalendarItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RemoveItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addRemoveItem(RemoveItemType $value)
    {
        if ($this->removeItem === null) {
                        $this->removeItem = array();
        }

        if (!is_array($this->removeItem)) {
            $this->removeItem = array($this->removeItem);
        }

        $this->removeItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RemoveItemType[]
     */
    public function getRemoveItem()
    {
        return $this->removeItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setRemoveItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->removeItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SuppressReadReceiptType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addSuppressReadReceipt(SuppressReadReceiptType $value)
    {
        if ($this->suppressReadReceipt === null) {
                        $this->suppressReadReceipt = array();
        }

        if (!is_array($this->suppressReadReceipt)) {
            $this->suppressReadReceipt = array($this->suppressReadReceipt);
        }

        $this->suppressReadReceipt[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SuppressReadReceiptType[]
     */
    public function getSuppressReadReceipt()
    {
        return $this->suppressReadReceipt;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setSuppressReadReceipt(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->suppressReadReceipt = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostReplyItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addPostReplyItem(PostReplyItemType $value)
    {
        if ($this->postReplyItem === null) {
                        $this->postReplyItem = array();
        }

        if (!is_array($this->postReplyItem)) {
            $this->postReplyItem = array($this->postReplyItem);
        }

        $this->postReplyItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PostReplyItemType[]
     */
    public function getPostReplyItem()
    {
        return $this->postReplyItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostReplyItemType[]|PostReplyItemType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setPostReplyItem(array|PostReplyItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->postReplyItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AcceptSharingInvitationType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function addAcceptSharingInvitation(AcceptSharingInvitationType $value)
    {
        if ($this->acceptSharingInvitation === null) {
                        $this->acceptSharingInvitation = array();
        }

        if (!is_array($this->acceptSharingInvitation)) {
            $this->acceptSharingInvitation = array($this->acceptSharingInvitation);
        }

        $this->acceptSharingInvitation[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AcceptSharingInvitationType[]
     */
    public function getAcceptSharingInvitation()
    {
        return $this->acceptSharingInvitation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfResponseObjectsType
     */
    public function setAcceptSharingInvitation(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->acceptSharingInvitation = $value;
        return $this;
    }
}
