<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing NonEmptyArrayOfFoldersType
 *
 *
 * XSD Type: NonEmptyArrayOfFoldersType
 */
class NonEmptyArrayOfFoldersType extends Type
{

    /**
     * @var \garethp\ews\API\Type\FolderType[]
     */
    protected $folder = null;

    /**
     * @var \garethp\ews\API\Type\CalendarFolderType[]
     */
    protected $calendarFolder = null;

    /**
     * @var \garethp\ews\API\Type\ContactsFolderType[]
     */
    protected $contactsFolder = null;

    /**
     * @var \garethp\ews\API\Type\SearchFolderType[]
     */
    protected $searchFolder = null;

    /**
     * @var \garethp\ews\API\Type\TasksFolderType[]
     */
    protected $tasksFolder = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value FolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function addFolder(FolderType $value)
    {
        if ($this->folder === null) {
                        $this->folder = array();
        }

        if (!is_array($this->folder)) {
            $this->folder = array($this->folder);
        }

        $this->folder[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FolderType[]
     */
    public function getFolder()
    {
        return $this->folder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FolderType[]|FolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function setFolder(array|FolderType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->folder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarFolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function addCalendarFolder(CalendarFolderType $value)
    {
        if ($this->calendarFolder === null) {
                        $this->calendarFolder = array();
        }

        if (!is_array($this->calendarFolder)) {
            $this->calendarFolder = array($this->calendarFolder);
        }

        $this->calendarFolder[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CalendarFolderType[]
     */
    public function getCalendarFolder()
    {
        return $this->calendarFolder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarFolderType[]|CalendarFolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function setCalendarFolder(array|CalendarFolderType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->calendarFolder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ContactsFolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function addContactsFolder(ContactsFolderType $value)
    {
        if ($this->contactsFolder === null) {
                        $this->contactsFolder = array();
        }

        if (!is_array($this->contactsFolder)) {
            $this->contactsFolder = array($this->contactsFolder);
        }

        $this->contactsFolder[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ContactsFolderType[]
     */
    public function getContactsFolder()
    {
        return $this->contactsFolder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ContactsFolderType[]|ContactsFolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function setContactsFolder(array|ContactsFolderType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->contactsFolder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SearchFolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function addSearchFolder(SearchFolderType $value)
    {
        if ($this->searchFolder === null) {
                        $this->searchFolder = array();
        }

        if (!is_array($this->searchFolder)) {
            $this->searchFolder = array($this->searchFolder);
        }

        $this->searchFolder[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SearchFolderType[]
     */
    public function getSearchFolder()
    {
        return $this->searchFolder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SearchFolderType[]|SearchFolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function setSearchFolder(array|SearchFolderType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->searchFolder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TasksFolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function addTasksFolder(TasksFolderType $value)
    {
        if ($this->tasksFolder === null) {
                        $this->tasksFolder = array();
        }

        if (!is_array($this->tasksFolder)) {
            $this->tasksFolder = array($this->tasksFolder);
        }

        $this->tasksFolder[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TasksFolderType[]
     */
    public function getTasksFolder()
    {
        return $this->tasksFolder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FolderType[]|FolderType
     * @return NonEmptyArrayOfFoldersType
     */
    public function setTasksFolder(array|FolderType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->tasksFolder = $value;
        return $this;
    }
}
