<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing NonEmptyArrayOfBaseItemIdsType
 *
 *
 * XSD Type: NonEmptyArrayOfBaseItemIdsType
 */
class NonEmptyArrayOfBaseItemIdsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\ItemIdType[]
     */
    protected $itemId = null;

    /**
     * @var \garethp\ews\API\Type\OccurrenceItemIdType[]
     */
    protected $occurrenceItemId = null;

    /**
     * @var \garethp\ews\API\Type\RecurringMasterItemIdType[]
     */
    protected $recurringMasterItemId = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function addItemId(ItemIdType $value)
    {
        if ($this->itemId === null) {
                        $this->itemId = array();
        }

        if (!is_array($this->itemId)) {
            $this->itemId = array($this->itemId);
        }

        $this->itemId[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemIdType[]
     */
    public function getItemId()
    {
        return $this->itemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType[]|ItemIdType
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function setItemId(array|ItemIdType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->itemId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value OccurrenceItemIdType
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function addOccurrenceItemId(OccurrenceItemIdType $value)
    {
        if ($this->occurrenceItemId === null) {
                        $this->occurrenceItemId = array();
        }

        if (!is_array($this->occurrenceItemId)) {
            $this->occurrenceItemId = array($this->occurrenceItemId);
        }

        $this->occurrenceItemId[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return OccurrenceItemIdType[]
     */
    public function getOccurrenceItemId()
    {
        return $this->occurrenceItemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value OccurrenceItemIdType[]|OccurrenceItemIdType
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function setOccurrenceItemId(array|OccurrenceItemIdType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->occurrenceItemId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurringMasterItemIdType
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function addRecurringMasterItemId(RecurringMasterItemIdType $value)
    {
        if ($this->recurringMasterItemId === null) {
                        $this->recurringMasterItemId = array();
        }

        if (!is_array($this->recurringMasterItemId)) {
            $this->recurringMasterItemId = array($this->recurringMasterItemId);
        }

        $this->recurringMasterItemId[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RecurringMasterItemIdType[]
     */
    public function getRecurringMasterItemId()
    {
        return $this->recurringMasterItemId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurringMasterItemIdType[]|RecurringMasterItemIdType
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function setRecurringMasterItemId(array|RecurringMasterItemIdType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->recurringMasterItemId = $value;
        return $this;
    }
}
