<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing NonEmptyArrayOfAttachmentsType
 *
 *
 * XSD Type: NonEmptyArrayOfAttachmentsType
 */
class NonEmptyArrayOfAttachmentsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\ItemAttachmentType[]
     */
    protected $itemAttachment = null;

    /**
     * @var \garethp\ews\API\Type\FileAttachmentType[]
     */
    protected $fileAttachment = null;

    /**
     * @return FileAttachmentType[]
     */
    public function getFileAttachment()
    {
        if (!is_array($this->fileAttachment) && $this->fileAttachment !== null) {
            return array($this->fileAttachment);
        }

        return $this->fileAttachment;
    }

    /**
     * @return ItemAttachmentType[]
     */
    public function getItemAttachment()
    {
        if (!is_array($this->itemAttachment) && $this->itemAttachment !== null) {
            return array($this->itemAttachment);
        }

        return $this->itemAttachment;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemAttachmentType
     * @return NonEmptyArrayOfAttachmentsType
     */
    public function addItemAttachment(ItemAttachmentType $value)
    {
        if ($this->itemAttachment === null) {
                        $this->itemAttachment = array();
        }

        if (!is_array($this->itemAttachment)) {
            $this->itemAttachment = array($this->itemAttachment);
        }

        $this->itemAttachment[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemAttachmentType[]|ItemAttachmentType
     * @return NonEmptyArrayOfAttachmentsType
     */
    public function setItemAttachment(array|ItemAttachmentType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->itemAttachment = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FileAttachmentType
     * @return NonEmptyArrayOfAttachmentsType
     */
    public function addFileAttachment(FileAttachmentType $value)
    {
        if ($this->fileAttachment === null) {
                        $this->fileAttachment = array();
        }

        if (!is_array($this->fileAttachment)) {
            $this->fileAttachment = array($this->fileAttachment);
        }

        $this->fileAttachment[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FileAttachmentType[]|FileAttachmentType
     * @return NonEmptyArrayOfAttachmentsType
     */
    public function setFileAttachment(array|FileAttachmentType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->fileAttachment = $value;
        return $this;
    }
}
