<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing MailboxStatisticsSearchResultType
 *
 * Mailbox statistics search result.
 * XSD Type: MailboxStatisticsSearchResultType
 */
class MailboxStatisticsSearchResultType extends Type
{

    /**
     * @var \garethp\ews\API\Type\UserMailboxType
     */
    protected $userMailbox = null;

    /**
     * @var \garethp\ews\API\Type\KeywordStatisticsSearchResultType
     */
    protected $keywordStatisticsSearchResult = null;

    /**
     * @autogenerated This method is safe to replace
     * @return UserMailboxType
     */
    public function getUserMailbox()
    {
        return $this->userMailbox;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value UserMailboxType
     * @return MailboxStatisticsSearchResultType
     */
    public function setUserMailbox(UserMailboxType $value)
    {
        $this->userMailbox = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return KeywordStatisticsSearchResultType
     */
    public function getKeywordStatisticsSearchResult()
    {
        return $this->keywordStatisticsSearchResult;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value KeywordStatisticsSearchResultType
     * @return MailboxStatisticsSearchResultType
     */
    public function setKeywordStatisticsSearchResult(KeywordStatisticsSearchResultType $value)
    {
        $this->keywordStatisticsSearchResult = $value;
        return $this;
    }
}
