<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Enumeration\IndexBasePointType;

/**
 * Class representing IndexedPageViewType
 *
 *
 * XSD Type: IndexedPageViewType
 */
class IndexedPageViewType extends BasePagingType
{

    /**
     * @var integer
     */
    protected $offset = null;

    /**
     * @var string
     */
    protected $basePoint = null;

    public function __construct($maxEntries = 100, $offset = 0, $basePoint = 'Beginning')
    {
        $this->maxEntriesReturned = $maxEntries;
        $this->offset = $offset;
        $this->basePoint = $basePoint;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return IndexedPageViewType
     */
    public function setOffset($value)
    {
        $this->offset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getBasePoint()
    {
        return $this->basePoint;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return IndexedPageViewType
     */
    public function setBasePoint($value)
    {
        $this->basePoint = $value;
        return $this;
    }
}
