<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing FolderChangeType
 *
 *
 * XSD Type: FolderChangeType
 */
class FolderChangeType extends Type
{

    /**
     * @var \garethp\ews\API\Type\FolderIdType
     */
    protected $folderId = null;

    /**
     * @var \garethp\ews\API\Type\DistinguishedFolderIdType
     */
    protected $distinguishedFolderId = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfFolderChangeDescriptionsType
     */
    protected $updates = null;

    /**
     * @autogenerated This method is safe to replace
     * @return FolderIdType
     */
    public function getFolderId()
    {
        return $this->folderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FolderIdType
     * @return FolderChangeType
     */
    public function setFolderId(FolderIdType $value)
    {
        $this->folderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DistinguishedFolderIdType
     */
    public function getDistinguishedFolderId()
    {
        return $this->distinguishedFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DistinguishedFolderIdType
     * @return FolderChangeType
     */
    public function setDistinguishedFolderId(DistinguishedFolderIdType $value)
    {
        $this->distinguishedFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NonEmptyArrayOfFolderChangeDescriptionsType
     */
    public function getUpdates()
    {
        return $this->updates;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value NonEmptyArrayOfFolderChangeDescriptionsType
     * @return FolderChangeType
     */
    public function setUpdates(NonEmptyArrayOfFolderChangeDescriptionsType $value)
    {
        $this->updates = $value;
        return $this;
    }
}
