<?php

namespace garethp\ews\API\Type;

use Countable;
use ArrayAccess;
use garethp\ews\API\Enumeration\IndexBasePointType;
use garethp\ews\API\Message\FindItemType;
use IteratorAggregate;
use garethp\ews\API\Type;

/**
 * Class representing FindItemParentType
 *
 *
 * XSD Type: FindItemParentType
 */
class FindItemParentType extends Type implements Countable, ArrayAccess, IteratorAggregate
{

    /**
     * @var integer
     */
    protected $indexedPagingOffset = null;

    /**
     * @var integer
     */
    protected $numeratorOffset = null;

    /**
     * @var integer
     */
    protected $absoluteDenominator = null;

    /**
     * @var boolean
     */
    protected $includesLastItemInRange = null;

    /**
     * @var integer
     */
    protected $totalItemsInView = null;

    /**
     * @var \garethp\ews\API\Type\ArrayOfRealItemsType
     */
    protected $items = null;

    /**
     * @var \garethp\ews\API\Type\GroupedItemsType[]
     */
    protected $groups = null;

    /**
     * @var FindItemType
     */
    protected $lastRequest = null;

    public function count()
    {
        return count($this->items);
    }

    public function offsetExists($offset)
    {
        $arrayAccessName = ($this->items != null ? 'items' : 'groups');
        return isset($this->{$arrayAccessName}[$offset]);
    }

    public function offsetGet($offset)
    {
        $arrayAccessName = ($this->items != null ? 'items' : 'groups');
        return isset($this->{$arrayAccessName}[$offset]) ? $this->{$arrayAccessName}[$offset] : null;
    }

    public function offsetSet($offset, $value)
    {
        $arrayAccessName = ($this->items != null ? 'items' : 'groups');

        if (is_null($offset)) {
            array_push($this->{$arrayAccessName}, $value);
        } else {
            $this->{$arrayAccessName}[$offset] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        $arrayAccessName = ($this->items != null ? 'items' : 'groups');
        unset($this->{$arrayAccessName}[$offset]);
    }

    public function getIterator()
    {
        $arrayAccessName = ($this->items != null ? 'items' : 'groups');
        return new \ArrayIterator($this->{$arrayAccessName}->getIterator());
    }

    /**
     * @return FindItemType
     */
    public function getLastRequest()
    {
        return $this->lastRequest;
    }

    /**
     * @param Type $lastRequest
     */
    public function setLastRequest($lastRequest)
    {
        $lastRequest = FindItemType::buildFromArray($lastRequest->getNonNullItems());
        $this->lastRequest = $lastRequest;
    }

    /**
     * Either returns the IndexedPageItemView of the last request or returns a new one,
     * at index 0, Base Point Beginning
     * and MaxEntries equal to the count of this object
     *
     * @return IndexedPageViewType
     */
    public function getCurrentPage()
    {
        if ($this->lastRequest !== null && $this->lastRequest->getIndexedPageItemView() != null) {
            return IndexedPageViewType::buildFromArray($this->lastRequest->getIndexedPageItemView()->getNonNullItems());
        }

        return new IndexedPageViewType($this->count(), 0, IndexBasePointType::BEGINNING);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getIndexedPagingOffset()
    {
        return $this->indexedPagingOffset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return FindItemParentType
     */
    public function setIndexedPagingOffset($value)
    {
        $this->indexedPagingOffset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getNumeratorOffset()
    {
        return $this->numeratorOffset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return FindItemParentType
     */
    public function setNumeratorOffset($value)
    {
        $this->numeratorOffset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getAbsoluteDenominator()
    {
        return $this->absoluteDenominator;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return FindItemParentType
     */
    public function setAbsoluteDenominator($value)
    {
        $this->absoluteDenominator = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludesLastItemInRange()
    {
        return ((bool) $this->includesLastItemInRange);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludesLastItemInRange()
    {
        return $this->includesLastItemInRange;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return FindItemParentType
     */
    public function setIncludesLastItemInRange($value)
    {
        $this->includesLastItemInRange = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getTotalItemsInView()
    {
        return $this->totalItemsInView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return FindItemParentType
     */
    public function setTotalItemsInView($value)
    {
        $this->totalItemsInView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ArrayOfRealItemsType
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ArrayOfRealItemsType
     * @return FindItemParentType
     */
    public function setItems(ArrayOfRealItemsType $value)
    {
        $this->items = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value GroupedItemsType
     * @return FindItemParentType
     */
    public function addGroups(GroupedItemsType $value)
    {
        if ($this->groups === null) {
                        $this->groups = array();
        }

        if (!is_array($this->groups)) {
            $this->groups = array($this->groups);
        }

        $this->groups[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return GroupedItemsType[]
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value GroupedItemsType[]|GroupedItemsType
     * @return FindItemParentType
     */
    public function setGroups(array|GroupedItemsType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->groups = $value;
        return $this;
    }
}
