<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing FieldURIOrConstantType
 *
 *
 * XSD Type: FieldURIOrConstantType
 */
class FieldURIOrConstantType extends Type
{

    /**
     * @var \garethp\ews\API\Type\FieldURI
     */
    protected $fieldURI = null;

    /**
     * @var \garethp\ews\API\Type\IndexedFieldURI
     */
    protected $indexedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\ExtendedFieldURI
     */
    protected $extendedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\ConstantValueType
     */
    protected $constant = null;

    /**
     * @autogenerated This method is safe to replace
     * @return FieldURI
     */
    public function getFieldURI()
    {
        return $this->fieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToUnindexedFieldType
     * @return FieldURIOrConstantType
     */
    public function setFieldURI(PathToUnindexedFieldType $value)
    {
        $this->fieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return IndexedFieldURI
     */
    public function getIndexedFieldURI()
    {
        return $this->indexedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToIndexedFieldType
     * @return FieldURIOrConstantType
     */
    public function setIndexedFieldURI(PathToIndexedFieldType $value)
    {
        $this->indexedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ExtendedFieldURI
     */
    public function getExtendedFieldURI()
    {
        return $this->extendedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToExtendedFieldType
     * @return FieldURIOrConstantType
     */
    public function setExtendedFieldURI(PathToExtendedFieldType $value)
    {
        $this->extendedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ConstantValueType
     */
    public function getConstant()
    {
        return $this->constant;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ConstantValueType
     * @return FieldURIOrConstantType
     */
    public function setConstant(ConstantValueType $value)
    {
        $this->constant = $value;
        return $this;
    }
}
