<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ExtendedPropertyType
 *
 * Represents an extended property instance (both its path identifier along with
 * its
 *  associated value).
 * XSD Type: ExtendedPropertyType
 */
class ExtendedPropertyType extends Type
{

    /**
     * @var \garethp\ews\API\Type\PathToExtendedFieldType
     */
    protected $extendedFieldURI = null;

    /**
     * @var string
     */
    protected $value = null;

    /**
     * @var string[]
     */
    protected $values = null;

    /**
     * @autogenerated This method is safe to replace
     * @return PathToExtendedFieldType
     */
    public function getExtendedFieldURI()
    {
        return $this->extendedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToExtendedFieldType
     * @return ExtendedPropertyType
     */
    public function setExtendedFieldURI(PathToExtendedFieldType $value)
    {
        $this->extendedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ExtendedPropertyType
     */
    public function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ExtendedPropertyType
     */
    public function addValues($value)
    {
        if ($this->values === null) {
                        $this->values = array();
        }

        if (!is_array($this->values)) {
            $this->values = array($this->values);
        }

        $this->values[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getValues()
    {
        return $this->values;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ExtendedPropertyType
     */
    public function setValues(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->values = $value;
        return $this;
    }
}
