<?php

namespace garethp\ews\API\Type;

/**
 * Class representing DistinguishedFolderIdType
 *
 * Identifier for a distinguished folder
 * XSD Type: DistinguishedFolderIdType
 */
class DistinguishedFolderIdType extends BaseFolderIdType
{

    /**
     * @var string
     */
    protected $id = null;

    /**
     * @var string
     */
    protected $changeKey = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $mailbox = null;

    public function __construct($id = null, $changeKey = null, EmailAddressType $mailbox = null)
    {
        $this->id = $id;
        $this->changeKey = $changeKey;
        $this->mailbox = $mailbox;
    }

    public function toArray($getOuterArray = false)
    {
        $id = [ 'Id' => $this->id, 'ChangeKey' => $this->changeKey, 'Mailbox' => $this->mailbox ];

        if ($getOuterArray === true) {
            return ['DistinguishedFolderId' => $id];
        }

        return $id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return DistinguishedFolderIdType
     */
    public function setId($value)
    {
        $this->id = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getChangeKey()
    {
        return $this->changeKey;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return DistinguishedFolderIdType
     */
    public function setChangeKey($value)
    {
        $this->changeKey = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getMailbox()
    {
        return $this->mailbox;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return DistinguishedFolderIdType
     */
    public function setMailbox(EmailAddressType $value)
    {
        $this->mailbox = $value;
        return $this;
    }
}
