<?php

namespace garethp\ews\API\Type;

/**
 * Class representing ContainsExpressionType
 *
 *
 * XSD Type: ContainsExpressionType
 */
class ContainsExpressionType extends SearchExpressionType
{

    /**
     * @var string
     */
    protected $containmentMode = null;

    /**
     * @var string
     */
    protected $containmentComparison = null;

    /**
     * @var \garethp\ews\API\Type\FieldURI[]
     */
    protected $fieldURI = null;

    /**
     * @var \garethp\ews\API\Type\IndexedFieldURI[]
     */
    protected $indexedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\ExtendedFieldURI[]
     */
    protected $extendedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\ConstantValueType
     */
    protected $constant = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getContainmentMode()
    {
        return $this->containmentMode;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContainsExpressionType
     */
    public function setContainmentMode($value)
    {
        $this->containmentMode = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getContainmentComparison()
    {
        return $this->containmentComparison;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContainsExpressionType
     */
    public function setContainmentComparison($value)
    {
        $this->containmentComparison = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FieldURI
     * @return ContainsExpressionType
     */
    public function addFieldURI(FieldURI $value)
    {
        if ($this->fieldURI === null) {
                        $this->fieldURI = array();
        }

        if (!is_array($this->fieldURI)) {
            $this->fieldURI = array($this->fieldURI);
        }

        $this->fieldURI[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FieldURI[]
     */
    public function getFieldURI()
    {
        return $this->fieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToUnindexedFieldType[]|PathToUnindexedFieldType
     * @return ContainsExpressionType
     */
    public function setFieldURI(array|PathToUnindexedFieldType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->fieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value IndexedFieldURI
     * @return ContainsExpressionType
     */
    public function addIndexedFieldURI(IndexedFieldURI $value)
    {
        if ($this->indexedFieldURI === null) {
                        $this->indexedFieldURI = array();
        }

        if (!is_array($this->indexedFieldURI)) {
            $this->indexedFieldURI = array($this->indexedFieldURI);
        }

        $this->indexedFieldURI[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return IndexedFieldURI[]
     */
    public function getIndexedFieldURI()
    {
        return $this->indexedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToIndexedFieldType[]|PathToIndexedFieldType
     * @return ContainsExpressionType
     */
    public function setIndexedFieldURI(array|PathToIndexedFieldType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->indexedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ExtendedFieldURI
     * @return ContainsExpressionType
     */
    public function addExtendedFieldURI(ExtendedFieldURI $value)
    {
        if ($this->extendedFieldURI === null) {
                        $this->extendedFieldURI = array();
        }

        if (!is_array($this->extendedFieldURI)) {
            $this->extendedFieldURI = array($this->extendedFieldURI);
        }

        $this->extendedFieldURI[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ExtendedFieldURI[]
     */
    public function getExtendedFieldURI()
    {
        return $this->extendedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToExtendedFieldType[]|PathToExtendedFieldType
     * @return ContainsExpressionType
     */
    public function setExtendedFieldURI(array|PathToExtendedFieldType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->extendedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ConstantValueType
     */
    public function getConstant()
    {
        return $this->constant;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ConstantValueType
     * @return ContainsExpressionType
     */
    public function setConstant(ConstantValueType $value)
    {
        $this->constant = $value;
        return $this;
    }
}
