<?php

namespace garethp\ews\API\Type;

/**
 * Class representing ContactItemType
 *
 *
 * XSD Type: ContactItemType
 */
class ContactItemType extends ItemType
{

    /**
     * @var string
     */
    protected $fileAs = null;

    /**
     * @var string
     */
    protected $fileAsMapping = null;

    /**
     * @var string
     */
    protected $displayName = null;

    /**
     * @var string
     */
    protected $givenName = null;

    /**
     * @var string
     */
    protected $initials = null;

    /**
     * @var string
     */
    protected $middleName = null;

    /**
     * @var string
     */
    protected $nickname = null;

    /**
     * @var \garethp\ews\API\Type\CompleteNameType
     */
    protected $completeName = null;

    /**
     * @var string
     */
    protected $companyName = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressDictionaryEntryType[]
     */
    protected $emailAddresses = null;

    /**
     * @var \garethp\ews\API\Type\PhysicalAddressDictionaryEntryType[]
     */
    protected $physicalAddresses = null;

    /**
     * @var \garethp\ews\API\Type\PhoneNumberDictionaryEntryType[]
     */
    protected $phoneNumbers = null;

    /**
     * @var string
     */
    protected $assistantName = null;

    /**
     * @var \DateTime
     */
    protected $birthday = null;

    /**
     * @var string
     */
    protected $businessHomePage = null;

    /**
     * @var string[]
     */
    protected $children = null;

    /**
     * @var string[]
     */
    protected $companies = null;

    /**
     * @var string
     */
    protected $contactSource = null;

    /**
     * @var string
     */
    protected $department = null;

    /**
     * @var string
     */
    protected $generation = null;

    /**
     * @var \garethp\ews\API\Type\ImAddressDictionaryEntryType[]
     */
    protected $imAddresses = null;

    /**
     * @var string
     */
    protected $jobTitle = null;

    /**
     * @var string
     */
    protected $manager = null;

    /**
     * @var string
     */
    protected $mileage = null;

    /**
     * @var string
     */
    protected $officeLocation = null;

    /**
     * @var string
     */
    protected $postalAddressIndex = null;

    /**
     * @var string
     */
    protected $profession = null;

    /**
     * @var string
     */
    protected $spouseName = null;

    /**
     * @var string
     */
    protected $surname = null;

    /**
     * @var \DateTime
     */
    protected $weddingAnniversary = null;

    /**
     * @var boolean
     */
    protected $hasPicture = null;

    /**
     * @var string
     */
    protected $phoneticFullName = null;

    /**
     * @var string
     */
    protected $phoneticFirstName = null;

    /**
     * @var string
     */
    protected $phoneticLastName = null;

    /**
     * @var string
     */
    protected $alias = null;

    /**
     * @var string
     */
    protected $notes = null;

    /**
     * @var string
     */
    protected $photo = null;

    /**
     * @var string[]
     */
    protected $userSMIMECertificate = null;

    /**
     * @var string[]
     */
    protected $mSExchangeCertificate = null;

    /**
     * @var string
     */
    protected $directoryId = null;

    /**
     * @var \garethp\ews\API\Type\SingleRecipientType
     */
    protected $managerMailbox = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $directReports = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getFileAs()
    {
        return $this->fileAs;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setFileAs($value)
    {
        $this->fileAs = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getFileAsMapping()
    {
        return $this->fileAsMapping;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setFileAsMapping($value)
    {
        $this->fileAsMapping = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setDisplayName($value)
    {
        $this->displayName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getGivenName()
    {
        return $this->givenName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setGivenName($value)
    {
        $this->givenName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getInitials()
    {
        return $this->initials;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setInitials($value)
    {
        $this->initials = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setMiddleName($value)
    {
        $this->middleName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getNickname()
    {
        return $this->nickname;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setNickname($value)
    {
        $this->nickname = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CompleteNameType
     */
    public function getCompleteName()
    {
        return $this->completeName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CompleteNameType
     * @return ContactItemType
     */
    public function setCompleteName(CompleteNameType $value)
    {
        $this->completeName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setCompanyName($value)
    {
        $this->companyName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressDictionaryEntryType
     * @return ContactItemType
     */
    public function addEmailAddresses(EmailAddressDictionaryEntryType $value)
    {
        if ($this->emailAddresses === null) {
                        $this->emailAddresses = array();
        }

        if (!is_array($this->emailAddresses)) {
            $this->emailAddresses = array($this->emailAddresses);
        }

        $this->emailAddresses[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressDictionaryEntryType[]
     */
    public function getEmailAddresses()
    {
        return $this->emailAddresses;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressDictionaryEntryType[]|EmailAddressDictionaryEntryType
     * @return ContactItemType
     */
    public function setEmailAddresses(array|EmailAddressDictionaryEntryType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->emailAddresses = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PhysicalAddressDictionaryEntryType
     * @return ContactItemType
     */
    public function addPhysicalAddresses(PhysicalAddressDictionaryEntryType $value)
    {
        if ($this->physicalAddresses === null) {
                        $this->physicalAddresses = array();
        }

        if (!is_array($this->physicalAddresses)) {
            $this->physicalAddresses = array($this->physicalAddresses);
        }

        $this->physicalAddresses[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PhysicalAddressDictionaryEntryType[]
     */
    public function getPhysicalAddresses()
    {
        return $this->physicalAddresses;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * PhysicalAddressDictionaryEntryType[]|PhysicalAddressDictionaryEntryType
     * @return ContactItemType
     */
    public function setPhysicalAddresses(array|PhysicalAddressDictionaryEntryType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->physicalAddresses = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PhoneNumberDictionaryEntryType
     * @return ContactItemType
     */
    public function addPhoneNumbers(PhoneNumberDictionaryEntryType $value)
    {
        if ($this->phoneNumbers === null) {
                        $this->phoneNumbers = array();
        }

        if (!is_array($this->phoneNumbers)) {
            $this->phoneNumbers = array($this->phoneNumbers);
        }

        $this->phoneNumbers[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PhoneNumberDictionaryEntryType[]
     */
    public function getPhoneNumbers()
    {
        return $this->phoneNumbers;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PhoneNumberDictionaryEntryType[]|PhoneNumberDictionaryEntryType
     * @return ContactItemType
     */
    public function setPhoneNumbers(array|PhoneNumberDictionaryEntryType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->phoneNumbers = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getAssistantName()
    {
        return $this->assistantName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setAssistantName($value)
    {
        $this->assistantName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getBirthday()
    {
        return $this->birthday;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return ContactItemType
     */
    public function setBirthday(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->birthday = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getBusinessHomePage()
    {
        return $this->businessHomePage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setBusinessHomePage($value)
    {
        $this->businessHomePage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function addChildren($value)
    {
        if ($this->children === null) {
                        $this->children = array();
        }

        if (!is_array($this->children)) {
            $this->children = array($this->children);
        }

        $this->children[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ContactItemType
     */
    public function setChildren(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->children = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function addCompanies($value)
    {
        if ($this->companies === null) {
                        $this->companies = array();
        }

        if (!is_array($this->companies)) {
            $this->companies = array($this->companies);
        }

        $this->companies[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getCompanies()
    {
        return $this->companies;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ContactItemType
     */
    public function setCompanies(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->companies = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getContactSource()
    {
        return $this->contactSource;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setContactSource($value)
    {
        $this->contactSource = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDepartment()
    {
        return $this->department;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setDepartment($value)
    {
        $this->department = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setGeneration($value)
    {
        $this->generation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ImAddressDictionaryEntryType
     * @return ContactItemType
     */
    public function addImAddresses(ImAddressDictionaryEntryType $value)
    {
        if ($this->imAddresses === null) {
                        $this->imAddresses = array();
        }

        if (!is_array($this->imAddresses)) {
            $this->imAddresses = array($this->imAddresses);
        }

        $this->imAddresses[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ImAddressDictionaryEntryType[]
     */
    public function getImAddresses()
    {
        return $this->imAddresses;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ImAddressDictionaryEntryType[]|ImAddressDictionaryEntryType
     * @return ContactItemType
     */
    public function setImAddresses(array|ImAddressDictionaryEntryType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->imAddresses = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getJobTitle()
    {
        return $this->jobTitle;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setJobTitle($value)
    {
        $this->jobTitle = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getManager()
    {
        return $this->manager;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setManager($value)
    {
        $this->manager = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMileage()
    {
        return $this->mileage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setMileage($value)
    {
        $this->mileage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getOfficeLocation()
    {
        return $this->officeLocation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setOfficeLocation($value)
    {
        $this->officeLocation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPostalAddressIndex()
    {
        return $this->postalAddressIndex;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setPostalAddressIndex($value)
    {
        $this->postalAddressIndex = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getProfession()
    {
        return $this->profession;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setProfession($value)
    {
        $this->profession = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSpouseName()
    {
        return $this->spouseName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setSpouseName($value)
    {
        $this->spouseName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setSurname($value)
    {
        $this->surname = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getWeddingAnniversary()
    {
        return $this->weddingAnniversary;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return ContactItemType
     */
    public function setWeddingAnniversary(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->weddingAnniversary = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isHasPicture()
    {
        return ((bool) $this->hasPicture);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getHasPicture()
    {
        return $this->hasPicture;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ContactItemType
     */
    public function setHasPicture($value)
    {
        $this->hasPicture = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPhoneticFullName()
    {
        return $this->phoneticFullName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setPhoneticFullName($value)
    {
        $this->phoneticFullName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPhoneticFirstName()
    {
        return $this->phoneticFirstName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setPhoneticFirstName($value)
    {
        $this->phoneticFirstName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPhoneticLastName()
    {
        return $this->phoneticLastName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setPhoneticLastName($value)
    {
        $this->phoneticLastName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setAlias($value)
    {
        $this->alias = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setNotes($value)
    {
        $this->notes = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPhoto()
    {
        return $this->photo;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setPhoto($value)
    {
        $this->photo = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function addUserSMIMECertificate($value)
    {
        if ($this->userSMIMECertificate === null) {
                        $this->userSMIMECertificate = array();
        }

        if (!is_array($this->userSMIMECertificate)) {
            $this->userSMIMECertificate = array($this->userSMIMECertificate);
        }

        $this->userSMIMECertificate[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getUserSMIMECertificate()
    {
        return $this->userSMIMECertificate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ContactItemType
     */
    public function setUserSMIMECertificate(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->userSMIMECertificate = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function addMSExchangeCertificate($value)
    {
        if ($this->mSExchangeCertificate === null) {
                        $this->mSExchangeCertificate = array();
        }

        if (!is_array($this->mSExchangeCertificate)) {
            $this->mSExchangeCertificate = array($this->mSExchangeCertificate);
        }

        $this->mSExchangeCertificate[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getMSExchangeCertificate()
    {
        return $this->mSExchangeCertificate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ContactItemType
     */
    public function setMSExchangeCertificate(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->mSExchangeCertificate = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDirectoryId()
    {
        return $this->directoryId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ContactItemType
     */
    public function setDirectoryId($value)
    {
        $this->directoryId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SingleRecipientType
     */
    public function getManagerMailbox()
    {
        return $this->managerMailbox;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SingleRecipientType
     * @return ContactItemType
     */
    public function setManagerMailbox(SingleRecipientType $value)
    {
        $this->managerMailbox = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return ContactItemType
     */
    public function addDirectReports(EmailAddressType $value)
    {
        if ($this->directReports === null) {
                        $this->directReports = array();
        }

        if (!is_array($this->directReports)) {
            $this->directReports = array($this->directReports);
        }

        $this->directReports[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType[]
     */
    public function getDirectReports()
    {
        return $this->directReports;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType[]|EmailAddressType
     * @return ContactItemType
     */
    public function setDirectReports(array|EmailAddressType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->directReports = $value;
        return $this;
    }
}
