<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ConnectingSIDType
 *
 *
 * XSD Type: ConnectingSIDType
 */
class ConnectingSIDType extends Type
{

    /**
     * @var string
     */
    protected $principalName = null;

    /**
     * @var string
     */
    protected $sID = null;

    /**
     * @var string
     */
    protected $primarySmtpAddress = null;

    /**
     * @var string
     */
    protected $smtpAddress = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPrincipalName()
    {
        return $this->principalName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConnectingSIDType
     */
    public function setPrincipalName($value)
    {
        $this->principalName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSID()
    {
        return $this->sID;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConnectingSIDType
     */
    public function setSID($value)
    {
        $this->sID = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPrimarySmtpAddress()
    {
        return $this->primarySmtpAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConnectingSIDType
     */
    public function setPrimarySmtpAddress($value)
    {
        $this->primarySmtpAddress = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSmtpAddress()
    {
        return $this->smtpAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConnectingSIDType
     */
    public function setSmtpAddress($value)
    {
        $this->smtpAddress = $value;
        return $this;
    }
}
