<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing AttendeeType
 *
 *
 * XSD Type: AttendeeType
 */
class AttendeeType extends Type
{

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $mailbox = null;

    /**
     * @var string
     */
    protected $responseType = null;

    /**
     * @var \DateTime
     */
    protected $lastResponseTime = null;

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getMailbox()
    {
        return $this->mailbox;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return AttendeeType
     */
    public function setMailbox(EmailAddressType $value)
    {
        $this->mailbox = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getResponseType()
    {
        return $this->responseType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AttendeeType
     */
    public function setResponseType($value)
    {
        $this->responseType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getLastResponseTime()
    {
        return $this->lastResponseTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return AttendeeType
     */
    public function setLastResponseTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->lastResponseTime = $value;
        return $this;
    }
}
