<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ArrayOfAttachmentsType
 *
 *
 * XSD Type: ArrayOfAttachmentsType
 */
class ArrayOfAttachmentsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\ItemAttachmentType[]
     */
    protected $itemAttachment = null;

    /**
     * @var \garethp\ews\API\Type\FileAttachmentType[]
     */
    protected $fileAttachment = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemAttachmentType
     * @return ArrayOfAttachmentsType
     */
    public function addItemAttachment(ItemAttachmentType $value)
    {
        if ($this->itemAttachment === null) {
                        $this->itemAttachment = array();
        }

        if (!is_array($this->itemAttachment)) {
            $this->itemAttachment = array($this->itemAttachment);
        }

        $this->itemAttachment[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemAttachmentType[]
     */
    public function getItemAttachment()
    {
        return $this->itemAttachment;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemAttachmentType[]|ItemAttachmentType
     * @return ArrayOfAttachmentsType
     */
    public function setItemAttachment(array|ItemAttachmentType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->itemAttachment = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FileAttachmentType
     * @return ArrayOfAttachmentsType
     */
    public function addFileAttachment(FileAttachmentType $value)
    {
        if ($this->fileAttachment === null) {
                        $this->fileAttachment = array();
        }

        if (!is_array($this->fileAttachment)) {
            $this->fileAttachment = array($this->fileAttachment);
        }

        $this->fileAttachment[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FileAttachmentType[]
     */
    public function getFileAttachment()
    {
        return $this->fileAttachment;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FileAttachmentType[]|FileAttachmentType
     * @return ArrayOfAttachmentsType
     */
    public function setFileAttachment(array|FileAttachmentType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->fileAttachment = $value;
        return $this;
    }
}
