<?php

namespace garethp\ews\API\Type;

/**
 * Class representing AlternateIdType
 *
 * Represents an alternate mailbox folder or item Id.
 * XSD Type: AlternateIdType
 */
class AlternateIdType extends AlternateIdBaseType
{

    /**
     * @var string
     */
    protected $id = null;

    /**
     * @var string
     */
    protected $mailbox = null;

    /**
     * @var boolean
     */
    protected $isArchive = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AlternateIdType
     */
    public function setId($value)
    {
        $this->id = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMailbox()
    {
        return $this->mailbox;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return AlternateIdType
     */
    public function setMailbox($value)
    {
        $this->mailbox = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isArchive()
    {
        return ((bool) $this->isArchive);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIsArchive()
    {
        return $this->isArchive;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return AlternateIdType
     */
    public function setIsArchive($value)
    {
        $this->isArchive = $value;
        return $this;
    }
}
