<?php

namespace garethp\ews\API\Message;

/**
 * Class representing UpdateInboxRulesRequestType
 *
 *
 * XSD Type: UpdateInboxRulesRequestType
 */
class UpdateInboxRulesRequestType extends BaseRequestType
{

    /**
     * @var string
     */
    protected $mailboxSmtpAddress = null;

    /**
     * @var boolean
     */
    protected $removeOutlookRuleBlob = null;

    /**
     * @var \garethp\ews\API\Type\ArrayOfRuleOperationsType
     */
    protected $operations = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMailboxSmtpAddress()
    {
        return $this->mailboxSmtpAddress;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UpdateInboxRulesRequestType
     */
    public function setMailboxSmtpAddress($value)
    {
        $this->mailboxSmtpAddress = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isRemoveOutlookRuleBlob()
    {
        return ((bool) $this->removeOutlookRuleBlob);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getRemoveOutlookRuleBlob()
    {
        return $this->removeOutlookRuleBlob;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return UpdateInboxRulesRequestType
     */
    public function setRemoveOutlookRuleBlob($value)
    {
        $this->removeOutlookRuleBlob = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\ArrayOfRuleOperationsType
     */
    public function getOperations()
    {
        return $this->operations;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\ArrayOfRuleOperationsType
     * @return UpdateInboxRulesRequestType
     */
    public function setOperations(\garethp\ews\API\Type\ArrayOfRuleOperationsType $value)
    {
        $this->operations = $value;
        return $this;
    }
}
