<?php

namespace garethp\ews\API\Message;

/**
 * Class representing SyncFolderItemsType
 *
 *
 * XSD Type: SyncFolderItemsType
 */
class SyncFolderItemsType extends BaseRequestType
{

    /**
     * @var \garethp\ews\API\Type\ItemResponseShapeType
     */
    protected $itemShape = null;

    /**
     * @var \garethp\ews\API\Type\TargetFolderIdType
     */
    protected $syncFolderId = null;

    /**
     * @var string
     */
    protected $syncState = null;

    /**
     * @var \garethp\ews\API\Type\ItemIdType[]
     */
    protected $ignore = null;

    /**
     * @var integer
     */
    protected $maxChangesReturned = null;

    /**
     * @var string
     */
    protected $syncScope = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\ItemResponseShapeType
     */
    public function getItemShape()
    {
        return $this->itemShape;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\ItemResponseShapeType
     * @return SyncFolderItemsType
     */
    public function setItemShape(\garethp\ews\API\Type\ItemResponseShapeType $value)
    {
        $this->itemShape = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\TargetFolderIdType
     */
    public function getSyncFolderId()
    {
        return $this->syncFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\TargetFolderIdType
     * @return SyncFolderItemsType
     */
    public function setSyncFolderId(\garethp\ews\API\Type\TargetFolderIdType $value)
    {
        $this->syncFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSyncState()
    {
        return $this->syncState;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return SyncFolderItemsType
     */
    public function setSyncState($value)
    {
        $this->syncState = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\ItemIdType
     * @return SyncFolderItemsType
     */
    public function addIgnore(\garethp\ews\API\Type\ItemIdType $value)
    {
        if ($this->ignore === null) {
                        $this->ignore = array();
        }

        if (!is_array($this->ignore)) {
            $this->ignore = array($this->ignore);
        }

        $this->ignore[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\ItemIdType[]
     */
    public function getIgnore()
    {
        return $this->ignore;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\ItemIdType[]|\garethp\ews\API\Type\ItemIdType
     * @return SyncFolderItemsType
     */
    public function setIgnore(array|\garethp\ews\API\Type\ItemIdType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->ignore = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMaxChangesReturned()
    {
        return $this->maxChangesReturned;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return SyncFolderItemsType
     */
    public function setMaxChangesReturned($value)
    {
        $this->maxChangesReturned = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getSyncScope()
    {
        return $this->syncScope;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return SyncFolderItemsType
     */
    public function setSyncScope($value)
    {
        $this->syncScope = $value;
        return $this;
    }
}
