<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetPasswordExpirationDateResponseMessageType
 *
 *
 * XSD Type: GetPasswordExpirationDateResponseMessageType
 */
class GetPasswordExpirationDateResponseMessageType extends ResponseMessageType
{

    /**
     * @var \DateTime
     */
    protected $passwordExpirationDate = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getPasswordExpirationDate()
    {
        return $this->passwordExpirationDate;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return GetPasswordExpirationDateResponseMessageType
     */
    public function setPasswordExpirationDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->passwordExpirationDate = $value;
        return $this;
    }
}
