<?php

namespace garethp\ews\API\Message;

use garethp\ews\API\Type\IndexedPageViewType;

/**
 * Class representing FindItemType
 *
 *
 * XSD Type: FindItemType
 */
class FindItemType extends BaseRequestType
{

    /**
     * @var string
     */
    protected $traversal = null;

    /**
     * @var \garethp\ews\API\Type\ItemResponseShapeType
     */
    protected $itemShape = null;

    /**
     * @var \garethp\ews\API\Type\IndexedPageViewType
     */
    protected $indexedPageItemView = null;

    /**
     * @var \garethp\ews\API\Type\FractionalPageViewType
     */
    protected $fractionalPageItemView = null;

    /**
     * @var \garethp\ews\API\Type\CalendarViewType
     */
    protected $calendarView = null;

    /**
     * @var \garethp\ews\API\Type\ContactsViewType
     */
    protected $contactsView = null;

    /**
     * @var \garethp\ews\API\Type\GroupByType
     */
    protected $groupBy = null;

    /**
     * @var \garethp\ews\API\Type\DistinguishedGroupByType
     */
    protected $distinguishedGroupBy = null;

    /**
     * @var \garethp\ews\API\Type\RestrictionType
     */
    protected $restriction = null;

    /**
     * @var \garethp\ews\API\Type\FieldOrderType[]
     */
    protected $sortOrder = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     */
    protected $parentFolderIds = null;

    /**
     * @var string
     */
    protected $queryString = null;

    public function setIndexedPage(\garethp\ews\API\Type\IndexedPageViewType $page)
    {
        $this->indexedPageItemView = $page;
        return $this;
    }

    public static function buildFromArray($array, $strict = false)
    {
        return parent::buildFromArray($array, true);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getTraversal()
    {
        return $this->traversal;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindItemType
     */
    public function setTraversal($value)
    {
        $this->traversal = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\ItemResponseShapeType
     */
    public function getItemShape()
    {
        return $this->itemShape;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\ItemResponseShapeType
     * @return FindItemType
     */
    public function setItemShape(\garethp\ews\API\Type\ItemResponseShapeType $value)
    {
        $this->itemShape = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\IndexedPageViewType
     */
    public function getIndexedPageItemView()
    {
        return $this->indexedPageItemView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\IndexedPageViewType
     * @return FindItemType
     */
    public function setIndexedPageItemView(\garethp\ews\API\Type\IndexedPageViewType $value)
    {
        $this->indexedPageItemView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FractionalPageViewType
     */
    public function getFractionalPageItemView()
    {
        return $this->fractionalPageItemView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FractionalPageViewType
     * @return FindItemType
     */
    public function setFractionalPageItemView(\garethp\ews\API\Type\FractionalPageViewType $value)
    {
        $this->fractionalPageItemView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\CalendarViewType
     */
    public function getCalendarView()
    {
        return $this->calendarView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\CalendarViewType
     * @return FindItemType
     */
    public function setCalendarView(\garethp\ews\API\Type\CalendarViewType $value)
    {
        $this->calendarView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\ContactsViewType
     */
    public function getContactsView()
    {
        return $this->contactsView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\ContactsViewType
     * @return FindItemType
     */
    public function setContactsView(\garethp\ews\API\Type\ContactsViewType $value)
    {
        $this->contactsView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\GroupByType
     */
    public function getGroupBy()
    {
        return $this->groupBy;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\GroupByType
     * @return FindItemType
     */
    public function setGroupBy(\garethp\ews\API\Type\GroupByType $value)
    {
        $this->groupBy = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\DistinguishedGroupByType
     */
    public function getDistinguishedGroupBy()
    {
        return $this->distinguishedGroupBy;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\DistinguishedGroupByType
     * @return FindItemType
     */
    public function setDistinguishedGroupBy(\garethp\ews\API\Type\DistinguishedGroupByType $value)
    {
        $this->distinguishedGroupBy = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\RestrictionType
     */
    public function getRestriction()
    {
        return $this->restriction;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\RestrictionType
     * @return FindItemType
     */
    public function setRestriction(\garethp\ews\API\Type\RestrictionType $value)
    {
        $this->restriction = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\FieldOrderType
     * @return FindItemType
     */
    public function addSortOrder(\garethp\ews\API\Type\FieldOrderType $value)
    {
        if ($this->sortOrder === null) {
                        $this->sortOrder = array();
        }

        if (!is_array($this->sortOrder)) {
            $this->sortOrder = array($this->sortOrder);
        }

        $this->sortOrder[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\FieldOrderType[]
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\FieldOrderType[]|\garethp\ews\API\Type\FieldOrderType
     * @return FindItemType
     */
    public function setSortOrder(array|\garethp\ews\API\Type\FieldOrderType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->sortOrder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     */
    public function getParentFolderIds()
    {
        return $this->parentFolderIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     * @return FindItemType
     */
    public function setParentFolderIds(\garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType $value)
    {
        $this->parentFolderIds = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getQueryString()
    {
        return $this->queryString;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FindItemType
     */
    public function setQueryString($value)
    {
        $this->queryString = $value;
        return $this;
    }
}
