<?php

namespace garethp\ews\API\Message;

/**
 * Class representing EmptyFolderType
 *
 *
 * XSD Type: EmptyFolderType
 */
class EmptyFolderType extends BaseRequestType
{

    /**
     * @var string
     */
    protected $deleteType = null;

    /**
     * @var boolean
     */
    protected $deleteSubFolders = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     */
    protected $folderIds = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDeleteType()
    {
        return $this->deleteType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return EmptyFolderType
     */
    public function setDeleteType($value)
    {
        $this->deleteType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isDeleteSubFolders()
    {
        return ((bool) $this->deleteSubFolders);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getDeleteSubFolders()
    {
        return $this->deleteSubFolders;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return EmptyFolderType
     */
    public function setDeleteSubFolders($value)
    {
        $this->deleteSubFolders = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     */
    public function getFolderIds()
    {
        return $this->folderIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType
     * @return EmptyFolderType
     */
    public function setFolderIds(\garethp\ews\API\Type\NonEmptyArrayOfBaseFolderIdsType $value)
    {
        $this->folderIds = $value;
        return $this;
    }
}
