<?php
/**
 * EventsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Elastic Email REST API
 *
 * This API is based on the REST API architecture, allowing the user to easily manage their data with this resource-based approach.    Every API call is established on which specific request type (GET, POST, PUT, DELETE) will be used.    The API has a limit of 20 concurrent connections and a hard timeout of 600 seconds per request.    To start using this API, you will need your Access Token (available <a target=\"_blank\" href=\"https://app.elasticemail.com/marketing/settings/new/manage-api\">here</a>). Remember to keep it safe. Required access levels are listed in the given request’s description.    Downloadable library clients can be found in our Github repository <a target=\"_blank\" href=\"https://github.com/ElasticEmail?tab=repositories&q=%22rest+api%22+in%3Areadme\">here</a>
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: support@elasticemail.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace ElasticEmail\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use ElasticEmail\ApiException;
use ElasticEmail\Configuration;
use ElasticEmail\HeaderSelector;
use ElasticEmail\ObjectSerializer;

/**
 * EventsApi Class Doc Comment
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class EventsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'eventsByTransactionidGet' => [
            'application/json',
        ],
        'eventsChannelsByNameExportPost' => [
            'application/json',
        ],
        'eventsChannelsByNameGet' => [
            'application/json',
        ],
        'eventsChannelsExportByIdStatusGet' => [
            'application/json',
        ],
        'eventsExportByIdStatusGet' => [
            'application/json',
        ],
        'eventsExportPost' => [
            'application/json',
        ],
        'eventsGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation eventsByTransactionidGet
     *
     * Load Email Events
     *
     * @param  string $transactionid ID number of transaction (required)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by order_by (optional)
     * @param  int $limit Maximum number of returned items. (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsByTransactionidGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\RecipientEvent[]
     */
    public function eventsByTransactionidGet($transactionid, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsByTransactionidGet'][0])
    {
        list($response) = $this->eventsByTransactionidGetWithHttpInfo($transactionid, $from, $to, $order_by, $limit, $offset, $contentType);
        return $response;
    }

    /**
     * Operation eventsByTransactionidGetWithHttpInfo
     *
     * Load Email Events
     *
     * @param  string $transactionid ID number of transaction (required)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit Maximum number of returned items. (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsByTransactionidGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\RecipientEvent[], HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsByTransactionidGetWithHttpInfo($transactionid, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsByTransactionidGet'][0])
    {
        $request = $this->eventsByTransactionidGetRequest($transactionid, $from, $to, $order_by, $limit, $offset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\RecipientEvent[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\RecipientEvent[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\RecipientEvent[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\RecipientEvent[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\RecipientEvent[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsByTransactionidGetAsync
     *
     * Load Email Events
     *
     * @param  string $transactionid ID number of transaction (required)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit Maximum number of returned items. (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsByTransactionidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsByTransactionidGetAsync($transactionid, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsByTransactionidGet'][0])
    {
        return $this->eventsByTransactionidGetAsyncWithHttpInfo($transactionid, $from, $to, $order_by, $limit, $offset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsByTransactionidGetAsyncWithHttpInfo
     *
     * Load Email Events
     *
     * @param  string $transactionid ID number of transaction (required)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit Maximum number of returned items. (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsByTransactionidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsByTransactionidGetAsyncWithHttpInfo($transactionid, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsByTransactionidGet'][0])
    {
        $returnType = '\ElasticEmail\Model\RecipientEvent[]';
        $request = $this->eventsByTransactionidGetRequest($transactionid, $from, $to, $order_by, $limit, $offset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'eventsByTransactionidGet'
     *
     * @param  string $transactionid ID number of transaction (required)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit Maximum number of returned items. (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsByTransactionidGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsByTransactionidGetRequest($transactionid, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsByTransactionidGet'][0])
    {

        // verify the required parameter 'transactionid' is set
        if ($transactionid === null || (is_array($transactionid) && count($transactionid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transactionid when calling eventsByTransactionidGet'
            );
        }







        $resourcePath = '/events/{transactionid}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_by,
            'orderBy', // param base name
            'EventsOrderBy', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($transactionid !== null) {
            $resourcePath = str_replace(
                '{' . 'transactionid' . '}',
                ObjectSerializer::toPathValue($transactionid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation eventsChannelsByNameExportPost
     *
     * Export Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameExportPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\ExportLink
     */
    public function eventsChannelsByNameExportPost($name, $event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsChannelsByNameExportPost'][0])
    {
        list($response) = $this->eventsChannelsByNameExportPostWithHttpInfo($name, $event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType);
        return $response;
    }

    /**
     * Operation eventsChannelsByNameExportPostWithHttpInfo
     *
     * Export Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameExportPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\ExportLink, HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsChannelsByNameExportPostWithHttpInfo($name, $event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsChannelsByNameExportPost'][0])
    {
        $request = $this->eventsChannelsByNameExportPostRequest($name, $event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 202:
                    if ('\ElasticEmail\Model\ExportLink' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\ExportLink' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\ExportLink', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\ExportLink';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\ExportLink',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsChannelsByNameExportPostAsync
     *
     * Export Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameExportPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsChannelsByNameExportPostAsync($name, $event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsChannelsByNameExportPost'][0])
    {
        return $this->eventsChannelsByNameExportPostAsyncWithHttpInfo($name, $event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsChannelsByNameExportPostAsyncWithHttpInfo
     *
     * Export Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameExportPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsChannelsByNameExportPostAsyncWithHttpInfo($name, $event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsChannelsByNameExportPost'][0])
    {
        $returnType = '\ElasticEmail\Model\ExportLink';
        $request = $this->eventsChannelsByNameExportPostRequest($name, $event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'eventsChannelsByNameExportPost'
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameExportPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsChannelsByNameExportPostRequest($name, $event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsChannelsByNameExportPost'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling eventsChannelsByNameExportPost'
            );
        }








        $resourcePath = '/events/channels/{name}/export';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $event_types,
            'eventTypes', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $file_format,
            'fileFormat', // param base name
            'ExportFileFormats', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $compression_format,
            'compressionFormat', // param base name
            'CompressionFormat', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $file_name,
            'fileName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation eventsChannelsByNameGet
     *
     * Load Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\RecipientEvent[]
     */
    public function eventsChannelsByNameGet($name, $event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsChannelsByNameGet'][0])
    {
        list($response) = $this->eventsChannelsByNameGetWithHttpInfo($name, $event_types, $from, $to, $order_by, $limit, $offset, $contentType);
        return $response;
    }

    /**
     * Operation eventsChannelsByNameGetWithHttpInfo
     *
     * Load Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\RecipientEvent[], HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsChannelsByNameGetWithHttpInfo($name, $event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsChannelsByNameGet'][0])
    {
        $request = $this->eventsChannelsByNameGetRequest($name, $event_types, $from, $to, $order_by, $limit, $offset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\RecipientEvent[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\RecipientEvent[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\RecipientEvent[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\RecipientEvent[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\RecipientEvent[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsChannelsByNameGetAsync
     *
     * Load Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsChannelsByNameGetAsync($name, $event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsChannelsByNameGet'][0])
    {
        return $this->eventsChannelsByNameGetAsyncWithHttpInfo($name, $event_types, $from, $to, $order_by, $limit, $offset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsChannelsByNameGetAsyncWithHttpInfo
     *
     * Load Channel Events
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsChannelsByNameGetAsyncWithHttpInfo($name, $event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsChannelsByNameGet'][0])
    {
        $returnType = '\ElasticEmail\Model\RecipientEvent[]';
        $request = $this->eventsChannelsByNameGetRequest($name, $event_types, $from, $to, $order_by, $limit, $offset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'eventsChannelsByNameGet'
     *
     * @param  string $name Name of selected channel. (required)
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsByNameGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsChannelsByNameGetRequest($name, $event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsChannelsByNameGet'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling eventsChannelsByNameGet'
            );
        }








        $resourcePath = '/events/channels/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $event_types,
            'eventTypes', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_by,
            'orderBy', // param base name
            'EventsOrderBy', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation eventsChannelsExportByIdStatusGet
     *
     * Check Channel Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\ExportStatus
     */
    public function eventsChannelsExportByIdStatusGet($id, string $contentType = self::contentTypes['eventsChannelsExportByIdStatusGet'][0])
    {
        list($response) = $this->eventsChannelsExportByIdStatusGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation eventsChannelsExportByIdStatusGetWithHttpInfo
     *
     * Check Channel Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\ExportStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsChannelsExportByIdStatusGetWithHttpInfo($id, string $contentType = self::contentTypes['eventsChannelsExportByIdStatusGet'][0])
    {
        $request = $this->eventsChannelsExportByIdStatusGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\ExportStatus' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\ExportStatus' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\ExportStatus', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\ExportStatus';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\ExportStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsChannelsExportByIdStatusGetAsync
     *
     * Check Channel Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsChannelsExportByIdStatusGetAsync($id, string $contentType = self::contentTypes['eventsChannelsExportByIdStatusGet'][0])
    {
        return $this->eventsChannelsExportByIdStatusGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsChannelsExportByIdStatusGetAsyncWithHttpInfo
     *
     * Check Channel Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsChannelsExportByIdStatusGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['eventsChannelsExportByIdStatusGet'][0])
    {
        $returnType = '\ElasticEmail\Model\ExportStatus';
        $request = $this->eventsChannelsExportByIdStatusGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'eventsChannelsExportByIdStatusGet'
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsChannelsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsChannelsExportByIdStatusGetRequest($id, string $contentType = self::contentTypes['eventsChannelsExportByIdStatusGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling eventsChannelsExportByIdStatusGet'
            );
        }


        $resourcePath = '/events/channels/export/{id}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation eventsExportByIdStatusGet
     *
     * Check Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\ExportStatus
     */
    public function eventsExportByIdStatusGet($id, string $contentType = self::contentTypes['eventsExportByIdStatusGet'][0])
    {
        list($response) = $this->eventsExportByIdStatusGetWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation eventsExportByIdStatusGetWithHttpInfo
     *
     * Check Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\ExportStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsExportByIdStatusGetWithHttpInfo($id, string $contentType = self::contentTypes['eventsExportByIdStatusGet'][0])
    {
        $request = $this->eventsExportByIdStatusGetRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\ExportStatus' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\ExportStatus' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\ExportStatus', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\ExportStatus';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\ExportStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsExportByIdStatusGetAsync
     *
     * Check Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsExportByIdStatusGetAsync($id, string $contentType = self::contentTypes['eventsExportByIdStatusGet'][0])
    {
        return $this->eventsExportByIdStatusGetAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsExportByIdStatusGetAsyncWithHttpInfo
     *
     * Check Export Status
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsExportByIdStatusGetAsyncWithHttpInfo($id, string $contentType = self::contentTypes['eventsExportByIdStatusGet'][0])
    {
        $returnType = '\ElasticEmail\Model\ExportStatus';
        $request = $this->eventsExportByIdStatusGetRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'eventsExportByIdStatusGet'
     *
     * @param  string $id ID of the exported file (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportByIdStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsExportByIdStatusGetRequest($id, string $contentType = self::contentTypes['eventsExportByIdStatusGet'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling eventsExportByIdStatusGet'
            );
        }


        $resourcePath = '/events/export/{id}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation eventsExportPost
     *
     * Export Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\ExportLink
     */
    public function eventsExportPost($event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsExportPost'][0])
    {
        list($response) = $this->eventsExportPostWithHttpInfo($event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType);
        return $response;
    }

    /**
     * Operation eventsExportPostWithHttpInfo
     *
     * Export Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\ExportLink, HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsExportPostWithHttpInfo($event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsExportPost'][0])
    {
        $request = $this->eventsExportPostRequest($event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 202:
                    if ('\ElasticEmail\Model\ExportLink' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\ExportLink' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\ExportLink', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\ExportLink';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\ExportLink',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsExportPostAsync
     *
     * Export Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsExportPostAsync($event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsExportPost'][0])
    {
        return $this->eventsExportPostAsyncWithHttpInfo($event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsExportPostAsyncWithHttpInfo
     *
     * Export Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsExportPostAsyncWithHttpInfo($event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsExportPost'][0])
    {
        $returnType = '\ElasticEmail\Model\ExportLink';
        $request = $this->eventsExportPostRequest($event_types, $from, $to, $file_format, $compression_format, $file_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'eventsExportPost'
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  ExportFileFormats $file_format Format of the exported file (optional)
     * @param  CompressionFormat $compression_format FileResponse compression format. None or Zip. (optional)
     * @param  string $file_name Name of your file including extension. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsExportPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsExportPostRequest($event_types = null, $from = null, $to = null, $file_format = null, $compression_format = null, $file_name = null, string $contentType = self::contentTypes['eventsExportPost'][0])
    {








        $resourcePath = '/events/export';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $event_types,
            'eventTypes', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $file_format,
            'fileFormat', // param base name
            'ExportFileFormats', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $compression_format,
            'compressionFormat', // param base name
            'CompressionFormat', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $file_name,
            'fileName', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation eventsGet
     *
     * Load Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\RecipientEvent[]
     */
    public function eventsGet($event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsGet'][0])
    {
        list($response) = $this->eventsGetWithHttpInfo($event_types, $from, $to, $order_by, $limit, $offset, $contentType);
        return $response;
    }

    /**
     * Operation eventsGetWithHttpInfo
     *
     * Load Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\RecipientEvent[], HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsGetWithHttpInfo($event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsGet'][0])
    {
        $request = $this->eventsGetRequest($event_types, $from, $to, $order_by, $limit, $offset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\RecipientEvent[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\RecipientEvent[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\RecipientEvent[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\RecipientEvent[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\RecipientEvent[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsGetAsync
     *
     * Load Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsGetAsync($event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsGet'][0])
    {
        return $this->eventsGetAsyncWithHttpInfo($event_types, $from, $to, $order_by, $limit, $offset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsGetAsyncWithHttpInfo
     *
     * Load Events
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsGetAsyncWithHttpInfo($event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsGet'][0])
    {
        $returnType = '\ElasticEmail\Model\RecipientEvent[]';
        $request = $this->eventsGetRequest($event_types, $from, $to, $order_by, $limit, $offset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'eventsGet'
     *
     * @param  \ElasticEmail\Model\EventType[] $event_types Types of Events to return (optional)
     * @param  \DateTime $from Starting date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  \DateTime $to Ending date for search in YYYY-MM-DDThh:mm:ss format. (optional)
     * @param  EventsOrderBy $order_by (optional)
     * @param  int $limit How many items to load. Maximum for this request is 1000 items (optional)
     * @param  int $offset How many items should be returned ahead. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['eventsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsGetRequest($event_types = null, $from = null, $to = null, $order_by = null, $limit = null, $offset = null, string $contentType = self::contentTypes['eventsGet'][0])
    {








        $resourcePath = '/events';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $event_types,
            'eventTypes', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_by,
            'orderBy', // param base name
            'EventsOrderBy', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
