<?php
/**
 * EmailsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Elastic Email REST API
 *
 * This API is based on the REST API architecture, allowing the user to easily manage their data with this resource-based approach.    Every API call is established on which specific request type (GET, POST, PUT, DELETE) will be used.    The API has a limit of 20 concurrent connections and a hard timeout of 600 seconds per request.    To start using this API, you will need your Access Token (available <a target=\"_blank\" href=\"https://app.elasticemail.com/marketing/settings/new/manage-api\">here</a>). Remember to keep it safe. Required access levels are listed in the given request’s description.    Downloadable library clients can be found in our Github repository <a target=\"_blank\" href=\"https://github.com/ElasticEmail?tab=repositories&q=%22rest+api%22+in%3Areadme\">here</a>
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: support@elasticemail.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace ElasticEmail\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use ElasticEmail\ApiException;
use ElasticEmail\Configuration;
use ElasticEmail\HeaderSelector;
use ElasticEmail\ObjectSerializer;

/**
 * EmailsApi Class Doc Comment
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class EmailsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'emailsByMsgidViewGet' => [
            'application/json',
        ],
        'emailsByTransactionidStatusGet' => [
            'application/json',
        ],
        'emailsMergefilePost' => [
            'application/json',
        ],
        'emailsPost' => [
            'application/json',
        ],
        'emailsTransactionalPost' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation emailsByMsgidViewGet
     *
     * View Email
     *
     * @param  string $msgid Message identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByMsgidViewGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\EmailData
     */
    public function emailsByMsgidViewGet($msgid, string $contentType = self::contentTypes['emailsByMsgidViewGet'][0])
    {
        list($response) = $this->emailsByMsgidViewGetWithHttpInfo($msgid, $contentType);
        return $response;
    }

    /**
     * Operation emailsByMsgidViewGetWithHttpInfo
     *
     * View Email
     *
     * @param  string $msgid Message identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByMsgidViewGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\EmailData, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailsByMsgidViewGetWithHttpInfo($msgid, string $contentType = self::contentTypes['emailsByMsgidViewGet'][0])
    {
        $request = $this->emailsByMsgidViewGetRequest($msgid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\EmailData' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\EmailData' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\EmailData', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\EmailData';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\EmailData',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation emailsByMsgidViewGetAsync
     *
     * View Email
     *
     * @param  string $msgid Message identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByMsgidViewGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsByMsgidViewGetAsync($msgid, string $contentType = self::contentTypes['emailsByMsgidViewGet'][0])
    {
        return $this->emailsByMsgidViewGetAsyncWithHttpInfo($msgid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation emailsByMsgidViewGetAsyncWithHttpInfo
     *
     * View Email
     *
     * @param  string $msgid Message identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByMsgidViewGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsByMsgidViewGetAsyncWithHttpInfo($msgid, string $contentType = self::contentTypes['emailsByMsgidViewGet'][0])
    {
        $returnType = '\ElasticEmail\Model\EmailData';
        $request = $this->emailsByMsgidViewGetRequest($msgid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'emailsByMsgidViewGet'
     *
     * @param  string $msgid Message identifier (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByMsgidViewGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function emailsByMsgidViewGetRequest($msgid, string $contentType = self::contentTypes['emailsByMsgidViewGet'][0])
    {

        // verify the required parameter 'msgid' is set
        if ($msgid === null || (is_array($msgid) && count($msgid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $msgid when calling emailsByMsgidViewGet'
            );
        }


        $resourcePath = '/emails/{msgid}/view';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($msgid !== null) {
            $resourcePath = str_replace(
                '{' . 'msgid' . '}',
                ObjectSerializer::toPathValue($msgid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation emailsByTransactionidStatusGet
     *
     * Get Status
     *
     * @param  string $transactionid Transaction identifier (required)
     * @param  bool $show_failed Include Bounced email addresses. (optional, default to false)
     * @param  bool $show_sent Include Sent email addresses. (optional, default to false)
     * @param  bool $show_delivered Include all delivered email addresses. (optional, default to false)
     * @param  bool $show_pending Include Ready to send email addresses. (optional, default to false)
     * @param  bool $show_opened Include Opened email addresses. (optional, default to false)
     * @param  bool $show_clicked Include Clicked email addresses. (optional, default to false)
     * @param  bool $show_abuse Include Reported as abuse email addresses. (optional, default to false)
     * @param  bool $show_unsubscribed Include Unsubscribed email addresses. (optional, default to false)
     * @param  bool $show_errors Include error messages for bounced emails. (optional, default to false)
     * @param  bool $show_message_ids Include all MessageIDs for this transaction (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByTransactionidStatusGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\EmailJobStatus
     */
    public function emailsByTransactionidStatusGet($transactionid, $show_failed = false, $show_sent = false, $show_delivered = false, $show_pending = false, $show_opened = false, $show_clicked = false, $show_abuse = false, $show_unsubscribed = false, $show_errors = false, $show_message_ids = false, string $contentType = self::contentTypes['emailsByTransactionidStatusGet'][0])
    {
        list($response) = $this->emailsByTransactionidStatusGetWithHttpInfo($transactionid, $show_failed, $show_sent, $show_delivered, $show_pending, $show_opened, $show_clicked, $show_abuse, $show_unsubscribed, $show_errors, $show_message_ids, $contentType);
        return $response;
    }

    /**
     * Operation emailsByTransactionidStatusGetWithHttpInfo
     *
     * Get Status
     *
     * @param  string $transactionid Transaction identifier (required)
     * @param  bool $show_failed Include Bounced email addresses. (optional, default to false)
     * @param  bool $show_sent Include Sent email addresses. (optional, default to false)
     * @param  bool $show_delivered Include all delivered email addresses. (optional, default to false)
     * @param  bool $show_pending Include Ready to send email addresses. (optional, default to false)
     * @param  bool $show_opened Include Opened email addresses. (optional, default to false)
     * @param  bool $show_clicked Include Clicked email addresses. (optional, default to false)
     * @param  bool $show_abuse Include Reported as abuse email addresses. (optional, default to false)
     * @param  bool $show_unsubscribed Include Unsubscribed email addresses. (optional, default to false)
     * @param  bool $show_errors Include error messages for bounced emails. (optional, default to false)
     * @param  bool $show_message_ids Include all MessageIDs for this transaction (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByTransactionidStatusGet'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\EmailJobStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailsByTransactionidStatusGetWithHttpInfo($transactionid, $show_failed = false, $show_sent = false, $show_delivered = false, $show_pending = false, $show_opened = false, $show_clicked = false, $show_abuse = false, $show_unsubscribed = false, $show_errors = false, $show_message_ids = false, string $contentType = self::contentTypes['emailsByTransactionidStatusGet'][0])
    {
        $request = $this->emailsByTransactionidStatusGetRequest($transactionid, $show_failed, $show_sent, $show_delivered, $show_pending, $show_opened, $show_clicked, $show_abuse, $show_unsubscribed, $show_errors, $show_message_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\EmailJobStatus' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\EmailJobStatus' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\EmailJobStatus', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\EmailJobStatus';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\EmailJobStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation emailsByTransactionidStatusGetAsync
     *
     * Get Status
     *
     * @param  string $transactionid Transaction identifier (required)
     * @param  bool $show_failed Include Bounced email addresses. (optional, default to false)
     * @param  bool $show_sent Include Sent email addresses. (optional, default to false)
     * @param  bool $show_delivered Include all delivered email addresses. (optional, default to false)
     * @param  bool $show_pending Include Ready to send email addresses. (optional, default to false)
     * @param  bool $show_opened Include Opened email addresses. (optional, default to false)
     * @param  bool $show_clicked Include Clicked email addresses. (optional, default to false)
     * @param  bool $show_abuse Include Reported as abuse email addresses. (optional, default to false)
     * @param  bool $show_unsubscribed Include Unsubscribed email addresses. (optional, default to false)
     * @param  bool $show_errors Include error messages for bounced emails. (optional, default to false)
     * @param  bool $show_message_ids Include all MessageIDs for this transaction (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByTransactionidStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsByTransactionidStatusGetAsync($transactionid, $show_failed = false, $show_sent = false, $show_delivered = false, $show_pending = false, $show_opened = false, $show_clicked = false, $show_abuse = false, $show_unsubscribed = false, $show_errors = false, $show_message_ids = false, string $contentType = self::contentTypes['emailsByTransactionidStatusGet'][0])
    {
        return $this->emailsByTransactionidStatusGetAsyncWithHttpInfo($transactionid, $show_failed, $show_sent, $show_delivered, $show_pending, $show_opened, $show_clicked, $show_abuse, $show_unsubscribed, $show_errors, $show_message_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation emailsByTransactionidStatusGetAsyncWithHttpInfo
     *
     * Get Status
     *
     * @param  string $transactionid Transaction identifier (required)
     * @param  bool $show_failed Include Bounced email addresses. (optional, default to false)
     * @param  bool $show_sent Include Sent email addresses. (optional, default to false)
     * @param  bool $show_delivered Include all delivered email addresses. (optional, default to false)
     * @param  bool $show_pending Include Ready to send email addresses. (optional, default to false)
     * @param  bool $show_opened Include Opened email addresses. (optional, default to false)
     * @param  bool $show_clicked Include Clicked email addresses. (optional, default to false)
     * @param  bool $show_abuse Include Reported as abuse email addresses. (optional, default to false)
     * @param  bool $show_unsubscribed Include Unsubscribed email addresses. (optional, default to false)
     * @param  bool $show_errors Include error messages for bounced emails. (optional, default to false)
     * @param  bool $show_message_ids Include all MessageIDs for this transaction (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByTransactionidStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsByTransactionidStatusGetAsyncWithHttpInfo($transactionid, $show_failed = false, $show_sent = false, $show_delivered = false, $show_pending = false, $show_opened = false, $show_clicked = false, $show_abuse = false, $show_unsubscribed = false, $show_errors = false, $show_message_ids = false, string $contentType = self::contentTypes['emailsByTransactionidStatusGet'][0])
    {
        $returnType = '\ElasticEmail\Model\EmailJobStatus';
        $request = $this->emailsByTransactionidStatusGetRequest($transactionid, $show_failed, $show_sent, $show_delivered, $show_pending, $show_opened, $show_clicked, $show_abuse, $show_unsubscribed, $show_errors, $show_message_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'emailsByTransactionidStatusGet'
     *
     * @param  string $transactionid Transaction identifier (required)
     * @param  bool $show_failed Include Bounced email addresses. (optional, default to false)
     * @param  bool $show_sent Include Sent email addresses. (optional, default to false)
     * @param  bool $show_delivered Include all delivered email addresses. (optional, default to false)
     * @param  bool $show_pending Include Ready to send email addresses. (optional, default to false)
     * @param  bool $show_opened Include Opened email addresses. (optional, default to false)
     * @param  bool $show_clicked Include Clicked email addresses. (optional, default to false)
     * @param  bool $show_abuse Include Reported as abuse email addresses. (optional, default to false)
     * @param  bool $show_unsubscribed Include Unsubscribed email addresses. (optional, default to false)
     * @param  bool $show_errors Include error messages for bounced emails. (optional, default to false)
     * @param  bool $show_message_ids Include all MessageIDs for this transaction (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsByTransactionidStatusGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function emailsByTransactionidStatusGetRequest($transactionid, $show_failed = false, $show_sent = false, $show_delivered = false, $show_pending = false, $show_opened = false, $show_clicked = false, $show_abuse = false, $show_unsubscribed = false, $show_errors = false, $show_message_ids = false, string $contentType = self::contentTypes['emailsByTransactionidStatusGet'][0])
    {

        // verify the required parameter 'transactionid' is set
        if ($transactionid === null || (is_array($transactionid) && count($transactionid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transactionid when calling emailsByTransactionidStatusGet'
            );
        }












        $resourcePath = '/emails/{transactionid}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_failed,
            'showFailed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_sent,
            'showSent', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_delivered,
            'showDelivered', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_pending,
            'showPending', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_opened,
            'showOpened', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_clicked,
            'showClicked', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_abuse,
            'showAbuse', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_unsubscribed,
            'showUnsubscribed', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_errors,
            'showErrors', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_message_ids,
            'showMessageIDs', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($transactionid !== null) {
            $resourcePath = str_replace(
                '{' . 'transactionid' . '}',
                ObjectSerializer::toPathValue($transactionid),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation emailsMergefilePost
     *
     * Send Bulk Emails CSV
     *
     * @param  \ElasticEmail\Model\MergeEmailPayload $merge_email_payload Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsMergefilePost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\EmailSend
     */
    public function emailsMergefilePost($merge_email_payload, string $contentType = self::contentTypes['emailsMergefilePost'][0])
    {
        list($response) = $this->emailsMergefilePostWithHttpInfo($merge_email_payload, $contentType);
        return $response;
    }

    /**
     * Operation emailsMergefilePostWithHttpInfo
     *
     * Send Bulk Emails CSV
     *
     * @param  \ElasticEmail\Model\MergeEmailPayload $merge_email_payload Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsMergefilePost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\EmailSend, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailsMergefilePostWithHttpInfo($merge_email_payload, string $contentType = self::contentTypes['emailsMergefilePost'][0])
    {
        $request = $this->emailsMergefilePostRequest($merge_email_payload, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\EmailSend' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\EmailSend' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\EmailSend', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\EmailSend';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\EmailSend',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation emailsMergefilePostAsync
     *
     * Send Bulk Emails CSV
     *
     * @param  \ElasticEmail\Model\MergeEmailPayload $merge_email_payload Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsMergefilePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsMergefilePostAsync($merge_email_payload, string $contentType = self::contentTypes['emailsMergefilePost'][0])
    {
        return $this->emailsMergefilePostAsyncWithHttpInfo($merge_email_payload, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation emailsMergefilePostAsyncWithHttpInfo
     *
     * Send Bulk Emails CSV
     *
     * @param  \ElasticEmail\Model\MergeEmailPayload $merge_email_payload Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsMergefilePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsMergefilePostAsyncWithHttpInfo($merge_email_payload, string $contentType = self::contentTypes['emailsMergefilePost'][0])
    {
        $returnType = '\ElasticEmail\Model\EmailSend';
        $request = $this->emailsMergefilePostRequest($merge_email_payload, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'emailsMergefilePost'
     *
     * @param  \ElasticEmail\Model\MergeEmailPayload $merge_email_payload Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsMergefilePost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function emailsMergefilePostRequest($merge_email_payload, string $contentType = self::contentTypes['emailsMergefilePost'][0])
    {

        // verify the required parameter 'merge_email_payload' is set
        if ($merge_email_payload === null || (is_array($merge_email_payload) && count($merge_email_payload) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $merge_email_payload when calling emailsMergefilePost'
            );
        }


        $resourcePath = '/emails/mergefile';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($merge_email_payload)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($merge_email_payload));
            } else {
                $httpBody = $merge_email_payload;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation emailsPost
     *
     * Send Bulk Emails
     *
     * @param  \ElasticEmail\Model\EmailMessageData $email_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\EmailSend
     */
    public function emailsPost($email_message_data, string $contentType = self::contentTypes['emailsPost'][0])
    {
        list($response) = $this->emailsPostWithHttpInfo($email_message_data, $contentType);
        return $response;
    }

    /**
     * Operation emailsPostWithHttpInfo
     *
     * Send Bulk Emails
     *
     * @param  \ElasticEmail\Model\EmailMessageData $email_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\EmailSend, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailsPostWithHttpInfo($email_message_data, string $contentType = self::contentTypes['emailsPost'][0])
    {
        $request = $this->emailsPostRequest($email_message_data, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\EmailSend' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\EmailSend' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\EmailSend', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\EmailSend';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\EmailSend',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation emailsPostAsync
     *
     * Send Bulk Emails
     *
     * @param  \ElasticEmail\Model\EmailMessageData $email_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsPostAsync($email_message_data, string $contentType = self::contentTypes['emailsPost'][0])
    {
        return $this->emailsPostAsyncWithHttpInfo($email_message_data, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation emailsPostAsyncWithHttpInfo
     *
     * Send Bulk Emails
     *
     * @param  \ElasticEmail\Model\EmailMessageData $email_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsPostAsyncWithHttpInfo($email_message_data, string $contentType = self::contentTypes['emailsPost'][0])
    {
        $returnType = '\ElasticEmail\Model\EmailSend';
        $request = $this->emailsPostRequest($email_message_data, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'emailsPost'
     *
     * @param  \ElasticEmail\Model\EmailMessageData $email_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function emailsPostRequest($email_message_data, string $contentType = self::contentTypes['emailsPost'][0])
    {

        // verify the required parameter 'email_message_data' is set
        if ($email_message_data === null || (is_array($email_message_data) && count($email_message_data) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_message_data when calling emailsPost'
            );
        }


        $resourcePath = '/emails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($email_message_data)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($email_message_data));
            } else {
                $httpBody = $email_message_data;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation emailsTransactionalPost
     *
     * Send Transactional Email
     *
     * @param  \ElasticEmail\Model\EmailTransactionalMessageData $email_transactional_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsTransactionalPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \ElasticEmail\Model\EmailSend
     */
    public function emailsTransactionalPost($email_transactional_message_data, string $contentType = self::contentTypes['emailsTransactionalPost'][0])
    {
        list($response) = $this->emailsTransactionalPostWithHttpInfo($email_transactional_message_data, $contentType);
        return $response;
    }

    /**
     * Operation emailsTransactionalPostWithHttpInfo
     *
     * Send Transactional Email
     *
     * @param  \ElasticEmail\Model\EmailTransactionalMessageData $email_transactional_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsTransactionalPost'] to see the possible values for this operation
     *
     * @throws \ElasticEmail\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \ElasticEmail\Model\EmailSend, HTTP status code, HTTP response headers (array of strings)
     */
    public function emailsTransactionalPostWithHttpInfo($email_transactional_message_data, string $contentType = self::contentTypes['emailsTransactionalPost'][0])
    {
        $request = $this->emailsTransactionalPostRequest($email_transactional_message_data, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\ElasticEmail\Model\EmailSend' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\ElasticEmail\Model\EmailSend' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\ElasticEmail\Model\EmailSend', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\ElasticEmail\Model\EmailSend';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\ElasticEmail\Model\EmailSend',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation emailsTransactionalPostAsync
     *
     * Send Transactional Email
     *
     * @param  \ElasticEmail\Model\EmailTransactionalMessageData $email_transactional_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsTransactionalPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsTransactionalPostAsync($email_transactional_message_data, string $contentType = self::contentTypes['emailsTransactionalPost'][0])
    {
        return $this->emailsTransactionalPostAsyncWithHttpInfo($email_transactional_message_data, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation emailsTransactionalPostAsyncWithHttpInfo
     *
     * Send Transactional Email
     *
     * @param  \ElasticEmail\Model\EmailTransactionalMessageData $email_transactional_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsTransactionalPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function emailsTransactionalPostAsyncWithHttpInfo($email_transactional_message_data, string $contentType = self::contentTypes['emailsTransactionalPost'][0])
    {
        $returnType = '\ElasticEmail\Model\EmailSend';
        $request = $this->emailsTransactionalPostRequest($email_transactional_message_data, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'emailsTransactionalPost'
     *
     * @param  \ElasticEmail\Model\EmailTransactionalMessageData $email_transactional_message_data Email data (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['emailsTransactionalPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function emailsTransactionalPostRequest($email_transactional_message_data, string $contentType = self::contentTypes['emailsTransactionalPost'][0])
    {

        // verify the required parameter 'email_transactional_message_data' is set
        if ($email_transactional_message_data === null || (is_array($email_transactional_message_data) && count($email_transactional_message_data) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_transactional_message_data when calling emailsTransactionalPost'
            );
        }


        $resourcePath = '/emails/transactional';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($email_transactional_message_data)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($email_transactional_message_data));
            } else {
                $httpBody = $email_transactional_message_data;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-ElasticEmail-ApiKey');
        if ($apiKey !== null) {
            $headers['X-ElasticEmail-ApiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
