<?php

/**
 * @package tikiwiki
 */

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
$inputConfiguration = [
    [
        'staticKeyFilters'      => [
            'url'               => 'url',     //get
            'cacheId'           => 'int',     //get
        ]
    ],
];
require_once('tiki-setup.php');

$access->check_feature('cachepages', '', 'textarea');

if (isset($_REQUEST['url'])) {
    $id = $tikilib->get_cache_id($_REQUEST['url']);
    if (! $id) {
        Feedback::errorAndDie(tra("No cache information available"), \Laminas\Http\Response::STATUS_CODE_409);
    }
    $_REQUEST["cacheId"] = $id;
}
if (! isset($_REQUEST["cacheId"])) {
    Feedback::errorAndDie(tra("No page indicated"), \Laminas\Http\Response::STATUS_CODE_409);
}
// Get a list of last changes to the Wiki database
$info = $tikilib->get_cache($_REQUEST["cacheId"]);
$ggcacheurl = 'http://google.com/search?q=cache:' . urlencode(strstr($info['url'], 'http://'));
// test if url ends with .txt : formatting for text
if (str_ends_with($info["url"], ".txt")) {
    $info["data"] = "<pre>" . $info["data"] . "</pre>";
}
// disallow robots to index page:
$smarty->assign('metatag_robots', 'NOINDEX, NOFOLLOW');
$smarty->assign('ggcacheurl', $ggcacheurl);
$smarty->assign_by_ref('info', $info);
$smarty->assign('mid', 'tiki-view_cache.tpl');
$smarty->display('tiki-view_cache.tpl');
