<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.

namespace SmartyTiki\Modifier;

/**
 * Smarty modifier plugin to convert a string suitable for a URL using the current SEFURL slug settings wiki_url_scheme
 *
 * - type:     modifier
 * - name:     slug
 * - purpose:  to return a usable SEFURL URL component string
 * - note:     also removes non-parse wiki tags generated by the list plugin
 *
 * Example: href="Page-Name-{$row.object_id}-{$row.title|slug}"
 *
 * @param string $string   String to be slugified
 * @param int  $maxLength  defaults to 70
 * @param bool $mixedCase  set true to preserve capitalisation
 * @param bool $breakWords set true to break words
 *
 * @return string
 *
 * @throws \Smarty\Exception
 */
class Slug
{
    public function handle($string, $maxLength = 70, $mixedCase = false, $breakWords = false)
    {
        global $prefs;
        $length = strlen($string);

        if (! $breakWords && $length > $maxLength) {
            $offset = strrpos($string, ' ', $maxLength - $length);
            if ($offset) {
                $maxLength = $offset;
            }
        }
        $string = substr(smarty_modifier_nonp($string), 0, $maxLength);
        if (! $mixedCase) {
            $string = mb_strtolower($string);
        }

        $asciiOnly = $prefs['url_only_ascii'] === 'y';

        /** @var \Tiki\Wiki\SlugManager $slugManager */
        $slugManager = \TikiLib::lib('slugmanager');
        // when used as a modifier in a smarty template (e.g. {$row.title|slug})
        // we don't want the -2 at the end if a wiki page also exists, so disable the validator fn
        $slugManager->setValidationCallback(function () {
            return false;
        });
        $str = $slugManager->generate($prefs['wiki_url_scheme'], $string, $asciiOnly);

        if (! $asciiOnly) {
            $str = urlencode($str);
        }
        return $str;
    }
}
