<?php
/** @package tikiwiki
 *
 * For PhpStorm IDE
 * https://www.jetbrains.com/help/phpstorm/ide-advanced-metadata
 *
 * (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
 *
 * All Rights Reserved. See copyright.txt for details and a complete list of authors.
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
 */

namespace PHPSTORM_META {
    override(
        \TikiLib::lib(),
        map([
            'addressbook'                => \AddressBookLib::class,
            'access'                     => \TikiAccessLib::class,
            'activity'                   => \ActivityLib::class,
            'admin'                      => \AdminLib::class,
            'api_token'                  => \Tiki\Lib\Auth\ApiToken::class,
            'webhook'                    => \Tiki\Lib\Auth\Webhook::class,
            'autosave'                   => \AutoSaveLib::class,
            'areas'                      => \AreasLib::class,
            'art'                        => \ArtLib::class,
            'attribute'                  => \AttributeLib::class,
            'avatar'                     => \AvatarLib::class,
            'banner'                     => \BannerLib::class,
            'bigbluebutton'              => \BigBlueButtonLib::class,
            'blog'                       => \BlogLib::class,
            'cache'                      => \CacheLib::class,
            'calendar'                   => \CalendarLib::class,
            'captcha'                    => \Captcha::class,
            'cart'                       => \CartLib::class,
            'categ'                      => \CategLib::class,
            'comments'                   => \Comments::class,
            'connect'                    => \Tiki_Connect_Client::class,
            'connect_server'             => \Tiki_Connect_Server::class,
            'contact'                    => \ContactLib::class,
            'contribution'               => \ContributionLib::class,
            'credits'                    => \CreditsLib::class,
            'crypt'                      => \CryptLib::class,
            'css'                        => \cssLib::class,
            'custom_route'               => \Tiki\CustomRoute\CustomRouteLib::class,
            'dcs'                        => \DCSLib::class,
            'edit'                       => \EditLib::class,
            'encryption'                 => \EncryptionLib::class,
            'events'                     => \Tiki_Event_Manager::class,
            'faq'                        => \FaqLib::class,
            'error'                      => \ErrorManagerLib::class,
            'federatedsearch'            => \FederatedSearchLib::class,
            'flaggedrevision'            => \FlaggedRevisionLib::class,
            'filegal'                    => \Tiki\Lib\Filegals\FileGalLib::class,
            'filegalbatch'               => \Tiki\Lib\Filegals\BatchLib::class,
            'filegalcopy'                => \Tiki\Lib\Filegals\CopyLib::class,
            'freetag'                    => \FreetagLib::class,
            'geo'                        => \GeoLib::class,
            'git'                        => \GitLib::class,
            'goal'                       => \GoalLib::class,
            'goalevent'                  => \GoalEventLib::class,
            'goalreward'                 => \GoalRewardLib::class,
            'groupalert'                 => \GroupAlertLib::class,
            'h5p'                        => \Tiki\Lib\Filegals\H5PLib::class,
            'header'                     => \HeaderLib::class,
            'hist'                       => \HistLib::class,
            'iconset'                    => \Tiki\Lib\Theme\IconsetLib::class,
            'imagegal'                   => \ImageGalsLib::class,
            'kalturaadmin'               => \KalturaLib::class,
            'kalturauser'                => \KalturaLib::class,
            'language'                   => \Language::class,
            'languagetranslations'       => \LanguageTranslations::class,
            'ldap'                       => \LdapLib::class,
            'login'                      => \LoginLib::class,
            'logs'                       => \Tiki\Lib\Logs\LogsLib::class,
            'logsqry'                    => \Tiki\Lib\Logs\LogsQueryLib::class,
            'ml'                         => \MachineLearningLib::class,
            'mailin'                     => \MailinLib::class,
            'memcache'                   => \Memcachelib::class,
            'message'                    => \Messu::class,
            'menu'                       => \MenuLib::class,
            'mime'                       => \MimeLib::class,
            'mod'                        => \ModLib::class,
            'monitor'                    => \MonitorLib::class,
            'monitormail'                => \MonitorMailLib::class,
            'multilingual'               => \MultilingualLib::class,
            'notification'               => \notificationLib::class,
            'oauth'                      => \OAuthLib::class,
            'oauthserver'                => \OAuthServerLib::class,
            'object'                     => \ObjectLib::class,
            'openidconnect'              => \Tiki\Lib\OpenIdConnect\OpenIdConnectLib::class,
            'objectselector'             => \Tiki\ObjectSelector\Selector::class,
            'pagecontent'                => \PageContentLib::class,
            'parser'                     => \ParserLib::class,
            'payment'                    => \PaymentLib::class,
            'perspective'                => \PerspectiveLib::class,
            'poll'                       => \PollLib::class,
            'prefs'                      => \PreferencesLib::class,
            'quantify'                   => \QuantifyLib::class,
            'queue'                      => \QueueLib::class,
            'quiz'                       => \Tiki\Lib\Quizzes\QuizLib::class,
            'rating'                     => \RatingLib::class,
            'ratingconfig'               => \RatingConfigLib::class,
            'recommendationcontentbatch' => \Tiki\Recommendation\BatchProcessor::class,
            'references'                 => \ReferencesLib::class,
            'registration'               => \Tiki\Lib\Registration\RegistrationLib::class,
            'relation'                   => \RelationLib::class,
            'rss'                        => \RSSLib::class,
            'scheduler'                  => \SchedulersLib::class,
            'score'                      => \ScoreLib::class,
            'scorm'                      => \Tiki\Lib\Filegals\ScormLib::class,
            'searchstats'                => \SearchStatsLib::class,
            'semantic'                   => \SemanticLib::class,
            'service'                    => \ServiceLib::class,
            'slugmanager'                => \Tiki\Wiki\SlugManager::class,
            'smarty'                     => \Tiki\Smarty\SmartyTiki::class,
            'social'                     => \SocialLib::class,
            'sheet'                      => \SheetLib::class,
            'stats'                      => \StatsLib::class,
            'storedsearch'               => \StoredSearchLib::class,
            'struct'                     => \StructLib::class,
            'symbols'                    => \Tiki_Profile_SymbolLoader::class,
            'tabular'                    => \Tracker\Tabular\Manager::class,
            'template'                   => \TemplatesLib::class,
            'theme'                      => \Tiki\Lib\Theme\ThemeLib::class,
            'themecontrol'               => \Tiki\Lib\Theme\ThemeControlLib::class,
            'tikicalendar'               => \TikiCalendarLib::class,
            'tikidate'                   => \TikiDate::class,
            'trk'                        => \TrackerLib::class,
            'unifiedsearch'              => \UnifiedSearchLib::class,
            'user'                       => \UsersLib::class,
            'usermailin'                 => \UserMailinLib::class,
            'usermodules'                => \UserModulesLib::class,
            'userprefs'                  => \UserPrefsLib::class,
            'validators'                 => \Validators::class,
            'vuejs'                      => \VueJsLib::class,
            'vimeo'                      => \Tiki\Lib\Filegals\VimeoLib::class,
            'xmpp'                       => \XMPPLib::class,
            'wiki'                       => \WikiLib::class,
            'wizard'                     => \WizardLib::class,
            'wysiwyg'                    => \WYSIWYGLib::class,
            'zotero'                     => \ZoteroLib::class,
            'blacklist'                  => \blacklistLib::class,
            'ocr'                        => \ocrLib::class,
            'pdfimages'                  => \PdfImagesLib::class,
            'version'                    => \TWVersion::class,
            'accounting'                 => \AccountingLib::class,
            'performancestats'           => \PerformanceStatsLib::class,
            'roles'                      => \Tiki\Group\Roles\RolesLib::class,
            'ilpinvoicepayment'          => \Tiki\Lib\Payment\ILPInvoicePaymentLib::class,
            'errortracking'              => \ErrorTracking::class,
        ])
    );
}
