<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platforms allow them to do with
// text.
//
// Copyright (C) 2006-2023  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
class ThumbParams extends \Kaltura\Client\Type\AssetParams
{
	public function getKalturaObjectType()
	{
		return 'KalturaThumbParams';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->cropType))
			$this->cropType = (int)$xml->cropType;
		if(count($xml->quality))
			$this->quality = (int)$xml->quality;
		if(count($xml->cropX))
			$this->cropX = (int)$xml->cropX;
		if(count($xml->cropY))
			$this->cropY = (int)$xml->cropY;
		if(count($xml->cropWidth))
			$this->cropWidth = (int)$xml->cropWidth;
		if(count($xml->cropHeight))
			$this->cropHeight = (int)$xml->cropHeight;
		if(count($xml->videoOffset))
			$this->videoOffset = (float)$xml->videoOffset;
		if(count($xml->width))
			$this->width = (int)$xml->width;
		if(count($xml->height))
			$this->height = (int)$xml->height;
		if(count($xml->scaleWidth))
			$this->scaleWidth = (float)$xml->scaleWidth;
		if(count($xml->scaleHeight))
			$this->scaleHeight = (float)$xml->scaleHeight;
		if(count($xml->backgroundColor))
			$this->backgroundColor = (string)$xml->backgroundColor;
		if(count($xml->sourceParamsId))
			$this->sourceParamsId = (int)$xml->sourceParamsId;
		if(count($xml->format))
			$this->format = (string)$xml->format;
		if(count($xml->density))
			$this->density = (int)$xml->density;
		if(count($xml->stripProfiles))
		{
			if(!empty($xml->stripProfiles) && $xml->stripProfiles != 'false')
				$this->stripProfiles = true;
			else
				$this->stripProfiles = false;
		}
		if(count($xml->videoOffsetInPercentage))
			$this->videoOffsetInPercentage = (int)$xml->videoOffsetInPercentage;
		if(count($xml->interval))
			$this->interval = (int)$xml->interval;
	}
	/**
	 * 
	 * @var \Kaltura\Client\Enum\ThumbCropType
	 */
	public $cropType = null;

	/**
	 * 
	 * @var int
	 */
	public $quality = null;

	/**
	 * 
	 * @var int
	 */
	public $cropX = null;

	/**
	 * 
	 * @var int
	 */
	public $cropY = null;

	/**
	 * 
	 * @var int
	 */
	public $cropWidth = null;

	/**
	 * 
	 * @var int
	 */
	public $cropHeight = null;

	/**
	 * 
	 * @var float
	 */
	public $videoOffset = null;

	/**
	 * 
	 * @var int
	 */
	public $width = null;

	/**
	 * 
	 * @var int
	 */
	public $height = null;

	/**
	 * 
	 * @var float
	 */
	public $scaleWidth = null;

	/**
	 * 
	 * @var float
	 */
	public $scaleHeight = null;

	/**
	 * Hexadecimal value
	 * @var string
	 */
	public $backgroundColor = null;

	/**
	 * Id of the flavor params or the thumbnail params to be used as source for the thumbnail creation
	 * @var int
	 */
	public $sourceParamsId = null;

	/**
	 * The container format of the Flavor Params
	 * @var \Kaltura\Client\Enum\ContainerFormat
	 */
	public $format = null;

	/**
	 * The image density (dpi) for example: 72 or 96
	 * @var int
	 */
	public $density = null;

	/**
	 * Strip profiles and comments
	 * @var bool
	 */
	public $stripProfiles = null;

	/**
	 * Create thumbnail from the videoLengthpercentage second
	 * @var int
	 */
	public $videoOffsetInPercentage = null;

	/**
	 * interval in seconds for creating thumbnail
	 * @var int
	 */
	public $interval = null;

}
