<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class TikiCachedContainer extends Container
{
    protected $parameters = [];

    public function __construct()
    {
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'tiki.lib.db' => true,
        ];
        $this->methodMap = [
            'tiki.controller.access' => 'getTiki_Controller_AccessService',
            'tiki.controller.activitystream' => 'getTiki_Controller_ActivitystreamService',
            'tiki.controller.annotation' => 'getTiki_Controller_AnnotationService',
            'tiki.controller.api_token' => 'getTiki_Controller_ApiTokenService',
            'tiki.controller.article' => 'getTiki_Controller_ArticleService',
            'tiki.controller.attribute' => 'getTiki_Controller_AttributeService',
            'tiki.controller.auth_source' => 'getTiki_Controller_AuthSourceService',
            'tiki.controller.autosave' => 'getTiki_Controller_AutosaveService',
            'tiki.controller.bigbluebutton' => 'getTiki_Controller_BigbluebuttonService',
            'tiki.controller.calendar' => 'getTiki_Controller_CalendarService',
            'tiki.controller.calendar_appointment' => 'getTiki_Controller_CalendarAppointmentService',
            'tiki.controller.calendar_availability' => 'getTiki_Controller_CalendarAvailabilityService',
            'tiki.controller.category' => 'getTiki_Controller_CategoryService',
            'tiki.controller.colormodes' => 'getTiki_Controller_ColormodesService',
            'tiki.controller.comment' => 'getTiki_Controller_CommentService',
            'tiki.controller.connect' => 'getTiki_Controller_ConnectService',
            'tiki.controller.connect_server' => 'getTiki_Controller_ConnectServerService',
            'tiki.controller.contenttemplate' => 'getTiki_Controller_ContenttemplateService',
            'tiki.controller.customroute' => 'getTiki_Controller_CustomrouteService',
            'tiki.controller.cypht' => 'getTiki_Controller_CyphtService',
            'tiki.controller.diagram' => 'getTiki_Controller_DiagramService',
            'tiki.controller.draw' => 'getTiki_Controller_DrawService',
            'tiki.controller.edit' => 'getTiki_Controller_EditService',
            'tiki.controller.edit_semaphore' => 'getTiki_Controller_EditSemaphoreService',
            'tiki.controller.encryption' => 'getTiki_Controller_EncryptionService',
            'tiki.controller.export' => 'getTiki_Controller_ExportService',
            'tiki.controller.favorite' => 'getTiki_Controller_FavoriteService',
            'tiki.controller.file' => 'getTiki_Controller_FileService',
            'tiki.controller.file_finder' => 'getTiki_Controller_FileFinderService',
            'tiki.controller.forum' => 'getTiki_Controller_ForumService',
            'tiki.controller.goal' => 'getTiki_Controller_GoalService',
            'tiki.controller.group' => 'getTiki_Controller_GroupService',
            'tiki.controller.h5p' => 'getTiki_Controller_H5pService',
            'tiki.controller.iconpicker' => 'getTiki_Controller_IconpickerService',
            'tiki.controller.ids' => 'getTiki_Controller_IdsService',
            'tiki.controller.kaltura' => 'getTiki_Controller_KalturaService',
            'tiki.controller.language' => 'getTiki_Controller_LanguageService',
            'tiki.controller.mailin' => 'getTiki_Controller_MailinService',
            'tiki.controller.manager' => 'getTiki_Controller_ManagerService',
            'tiki.controller.manager_field' => 'getTiki_Controller_ManagerFieldService',
            'tiki.controller.manager_patch' => 'getTiki_Controller_ManagerPatchService',
            'tiki.controller.managestream' => 'getTiki_Controller_ManagestreamService',
            'tiki.controller.menu' => 'getTiki_Controller_MenuService',
            'tiki.controller.ml' => 'getTiki_Controller_MlService',
            'tiki.controller.module' => 'getTiki_Controller_ModuleService',
            'tiki.controller.monitor' => 'getTiki_Controller_MonitorService',
            'tiki.controller.mustread' => 'getTiki_Controller_MustreadService',
            'tiki.controller.oauth' => 'getTiki_Controller_OauthService',
            'tiki.controller.oauthserver' => 'getTiki_Controller_OauthserverService',
            'tiki.controller.object' => 'getTiki_Controller_ObjectService',
            'tiki.controller.payment' => 'getTiki_Controller_PaymentService',
            'tiki.controller.pdf' => 'getTiki_Controller_PdfService',
            'tiki.controller.performance' => 'getTiki_Controller_PerformanceService',
            'tiki.controller.pivot' => 'getTiki_Controller_PivotService',
            'tiki.controller.plugin' => 'getTiki_Controller_PluginService',
            'tiki.controller.rating' => 'getTiki_Controller_RatingService',
            'tiki.controller.recommendation_dev' => 'getTiki_Controller_RecommendationDevService',
            'tiki.controller.recordrtc' => 'getTiki_Controller_RecordrtcService',
            'tiki.controller.relation' => 'getTiki_Controller_RelationService',
            'tiki.controller.report' => 'getTiki_Controller_ReportService',
            'tiki.controller.scheduler' => 'getTiki_Controller_SchedulerService',
            'tiki.controller.score' => 'getTiki_Controller_ScoreService',
            'tiki.controller.search' => 'getTiki_Controller_SearchService',
            'tiki.controller.search_customsearch' => 'getTiki_Controller_SearchCustomsearchService',
            'tiki.controller.search_manifold' => 'getTiki_Controller_SearchManifoldService',
            'tiki.controller.search_stored' => 'getTiki_Controller_SearchStoredService',
            'tiki.controller.semaphore' => 'getTiki_Controller_SemaphoreService',
            'tiki.controller.showtikiorg' => 'getTiki_Controller_ShowtikiorgService',
            'tiki.controller.social' => 'getTiki_Controller_SocialService',
            'tiki.controller.styleguide' => 'getTiki_Controller_StyleguideService',
            'tiki.controller.suite' => 'getTiki_Controller_SuiteService',
            'tiki.controller.tabular' => 'getTiki_Controller_TabularService',
            'tiki.controller.tracker' => 'getTiki_Controller_TrackerService',
            'tiki.controller.tracker_calendar' => 'getTiki_Controller_TrackerCalendarService',
            'tiki.controller.tracker_duration' => 'getTiki_Controller_TrackerDurationService',
            'tiki.controller.tracker_sync' => 'getTiki_Controller_TrackerSyncService',
            'tiki.controller.tracker_todo' => 'getTiki_Controller_TrackerTodoService',
            'tiki.controller.translation' => 'getTiki_Controller_TranslationService',
            'tiki.controller.user' => 'getTiki_Controller_UserService',
            'tiki.controller.user_conditions' => 'getTiki_Controller_UserConditionsService',
            'tiki.controller.vimeo' => 'getTiki_Controller_VimeoService',
            'tiki.controller.webhook' => 'getTiki_Controller_WebhookService',
            'tiki.controller.wiki' => 'getTiki_Controller_WikiService',
            'tiki.controller.wiki_structure' => 'getTiki_Controller_WikiStructureService',
            'tiki.controller.workspace' => 'getTiki_Controller_WorkspaceService',
            'tiki.controller.xmpp' => 'getTiki_Controller_XmppService',
            'tiki.lib.access' => 'getTiki_Lib_AccessService',
            'tiki.lib.accounting' => 'getTiki_Lib_AccountingService',
            'tiki.lib.activity' => 'getTiki_Lib_ActivityService',
            'tiki.lib.addressbook' => 'getTiki_Lib_AddressbookService',
            'tiki.lib.admin' => 'getTiki_Lib_AdminService',
            'tiki.lib.api_token' => 'getTiki_Lib_ApiTokenService',
            'tiki.lib.areas' => 'getTiki_Lib_AreasService',
            'tiki.lib.art' => 'getTiki_Lib_ArtService',
            'tiki.lib.attribute' => 'getTiki_Lib_AttributeService',
            'tiki.lib.autosave' => 'getTiki_Lib_AutosaveService',
            'tiki.lib.avatar' => 'getTiki_Lib_AvatarService',
            'tiki.lib.banner' => 'getTiki_Lib_BannerService',
            'tiki.lib.bigbluebutton' => 'getTiki_Lib_BigbluebuttonService',
            'tiki.lib.blacklist' => 'getTiki_Lib_BlacklistService',
            'tiki.lib.blog' => 'getTiki_Lib_BlogService',
            'tiki.lib.cache' => 'getTiki_Lib_CacheService',
            'tiki.lib.calendar' => 'getTiki_Lib_CalendarService',
            'tiki.lib.captcha' => 'getTiki_Lib_CaptchaService',
            'tiki.lib.cart' => 'getTiki_Lib_CartService',
            'tiki.lib.categ' => 'getTiki_Lib_CategService',
            'tiki.lib.comments' => 'getTiki_Lib_CommentsService',
            'tiki.lib.connect' => 'getTiki_Lib_ConnectService',
            'tiki.lib.connect_server' => 'getTiki_Lib_ConnectServerService',
            'tiki.lib.contact' => 'getTiki_Lib_ContactService',
            'tiki.lib.contribution' => 'getTiki_Lib_ContributionService',
            'tiki.lib.credits' => 'getTiki_Lib_CreditsService',
            'tiki.lib.crypt' => 'getTiki_Lib_CryptService',
            'tiki.lib.css' => 'getTiki_Lib_CssService',
            'tiki.lib.custom_route' => 'getTiki_Lib_CustomRouteService',
            'tiki.lib.dcs' => 'getTiki_Lib_DcsService',
            'tiki.lib.edit' => 'getTiki_Lib_EditService',
            'tiki.lib.encryption' => 'getTiki_Lib_EncryptionService',
            'tiki.lib.error' => 'getTiki_Lib_ErrorService',
            'tiki.lib.errortracking' => 'getTiki_Lib_ErrortrackingService',
            'tiki.lib.events' => 'getTiki_Lib_EventsService',
            'tiki.lib.faq' => 'getTiki_Lib_FaqService',
            'tiki.lib.federatedsearch' => 'getTiki_Lib_FederatedsearchService',
            'tiki.lib.filegal' => 'getTiki_Lib_FilegalService',
            'tiki.lib.filegalbatch' => 'getTiki_Lib_FilegalbatchService',
            'tiki.lib.filegalcopy' => 'getTiki_Lib_FilegalcopyService',
            'tiki.lib.flaggedrevision' => 'getTiki_Lib_FlaggedrevisionService',
            'tiki.lib.freetag' => 'getTiki_Lib_FreetagService',
            'tiki.lib.geo' => 'getTiki_Lib_GeoService',
            'tiki.lib.git' => 'getTiki_Lib_GitService',
            'tiki.lib.goal' => 'getTiki_Lib_GoalService',
            'tiki.lib.goalevent' => 'getTiki_Lib_GoaleventService',
            'tiki.lib.goalreward' => 'getTiki_Lib_GoalrewardService',
            'tiki.lib.groupalert' => 'getTiki_Lib_GroupalertService',
            'tiki.lib.h5p' => 'getTiki_Lib_H5pService',
            'tiki.lib.header' => 'getTiki_Lib_HeaderService',
            'tiki.lib.hist' => 'getTiki_Lib_HistService',
            'tiki.lib.iconset' => 'getTiki_Lib_IconsetService',
            'tiki.lib.ilpinvoicepayment' => 'getTiki_Lib_IlpinvoicepaymentService',
            'tiki.lib.imagegal' => 'getTiki_Lib_ImagegalService',
            'tiki.lib.kalturaadmin' => 'getTiki_Lib_KalturaadminService',
            'tiki.lib.kalturauser' => 'getTiki_Lib_KalturauserService',
            'tiki.lib.language' => 'getTiki_Lib_LanguageService',
            'tiki.lib.languagetranslations' => 'getTiki_Lib_LanguagetranslationsService',
            'tiki.lib.ldap' => 'getTiki_Lib_LdapService',
            'tiki.lib.login' => 'getTiki_Lib_LoginService',
            'tiki.lib.logs' => 'getTiki_Lib_LogsService',
            'tiki.lib.logsqry' => 'getTiki_Lib_LogsqryService',
            'tiki.lib.mailin' => 'getTiki_Lib_MailinService',
            'tiki.lib.memcache' => 'getTiki_Lib_MemcacheService',
            'tiki.lib.menu' => 'getTiki_Lib_MenuService',
            'tiki.lib.message' => 'getTiki_Lib_MessageService',
            'tiki.lib.mime' => 'getTiki_Lib_MimeService',
            'tiki.lib.ml' => 'getTiki_Lib_MlService',
            'tiki.lib.mod' => 'getTiki_Lib_ModService',
            'tiki.lib.monitor' => 'getTiki_Lib_MonitorService',
            'tiki.lib.monitormail' => 'getTiki_Lib_MonitormailService',
            'tiki.lib.multilingual' => 'getTiki_Lib_MultilingualService',
            'tiki.lib.newsletter' => 'getTiki_Lib_NewsletterService',
            'tiki.lib.notification' => 'getTiki_Lib_NotificationService',
            'tiki.lib.oauth' => 'getTiki_Lib_OauthService',
            'tiki.lib.oauthserver' => 'getTiki_Lib_OauthserverService',
            'tiki.lib.object' => 'getTiki_Lib_ObjectService',
            'tiki.lib.objectselector' => 'getTiki_Lib_ObjectselectorService',
            'tiki.lib.ocr' => 'getTiki_Lib_OcrService',
            'tiki.lib.openidconnect' => 'getTiki_Lib_OpenidconnectService',
            'tiki.lib.pagecontent' => 'getTiki_Lib_PagecontentService',
            'tiki.lib.parser' => 'getTiki_Lib_ParserService',
            'tiki.lib.payment' => 'getTiki_Lib_PaymentService',
            'tiki.lib.pdfimages' => 'getTiki_Lib_PdfimagesService',
            'tiki.lib.performancestats' => 'getTiki_Lib_PerformancestatsService',
            'tiki.lib.perspective' => 'getTiki_Lib_PerspectiveService',
            'tiki.lib.poll' => 'getTiki_Lib_PollService',
            'tiki.lib.prefs' => 'getTiki_Lib_PrefsService',
            'tiki.lib.quantify' => 'getTiki_Lib_QuantifyService',
            'tiki.lib.queue' => 'getTiki_Lib_QueueService',
            'tiki.lib.quiz' => 'getTiki_Lib_QuizService',
            'tiki.lib.rating' => 'getTiki_Lib_RatingService',
            'tiki.lib.ratingconfig' => 'getTiki_Lib_RatingconfigService',
            'tiki.lib.recommendationcontentbatch' => 'getTiki_Lib_RecommendationcontentbatchService',
            'tiki.lib.references' => 'getTiki_Lib_ReferencesService',
            'tiki.lib.registration' => 'getTiki_Lib_RegistrationService',
            'tiki.lib.relation' => 'getTiki_Lib_RelationService',
            'tiki.lib.roles' => 'getTiki_Lib_RolesService',
            'tiki.lib.rss' => 'getTiki_Lib_RssService',
            'tiki.lib.scheduler' => 'getTiki_Lib_SchedulerService',
            'tiki.lib.score' => 'getTiki_Lib_ScoreService',
            'tiki.lib.scorm' => 'getTiki_Lib_ScormService',
            'tiki.lib.searchstats' => 'getTiki_Lib_SearchstatsService',
            'tiki.lib.semantic' => 'getTiki_Lib_SemanticService',
            'tiki.lib.service' => 'getTiki_Lib_ServiceService',
            'tiki.lib.sheet' => 'getTiki_Lib_SheetService',
            'tiki.lib.slugmanager' => 'getTiki_Lib_SlugmanagerService',
            'tiki.lib.smarty' => 'getTiki_Lib_SmartyService',
            'tiki.lib.social' => 'getTiki_Lib_SocialService',
            'tiki.lib.stats' => 'getTiki_Lib_StatsService',
            'tiki.lib.storedsearch' => 'getTiki_Lib_StoredsearchService',
            'tiki.lib.struct' => 'getTiki_Lib_StructService',
            'tiki.lib.symbols' => 'getTiki_Lib_SymbolsService',
            'tiki.lib.tabular' => 'getTiki_Lib_TabularService',
            'tiki.lib.template' => 'getTiki_Lib_TemplateService',
            'tiki.lib.theme' => 'getTiki_Lib_ThemeService',
            'tiki.lib.themecontrol' => 'getTiki_Lib_ThemecontrolService',
            'tiki.lib.tikicalendar' => 'getTiki_Lib_TikicalendarService',
            'tiki.lib.tikidate' => 'getTiki_Lib_TikidateService',
            'tiki.lib.todo' => 'getTiki_Lib_TodoService',
            'tiki.lib.trk' => 'getTiki_Lib_TrkService',
            'tiki.lib.tsbounces' => 'getTiki_Lib_TsbouncesService',
            'tiki.lib.unifiedsearch' => 'getTiki_Lib_UnifiedsearchService',
            'tiki.lib.user' => 'getTiki_Lib_UserService',
            'tiki.lib.usermailin' => 'getTiki_Lib_UsermailinService',
            'tiki.lib.usermodules' => 'getTiki_Lib_UsermodulesService',
            'tiki.lib.userprefs' => 'getTiki_Lib_UserprefsService',
            'tiki.lib.validators' => 'getTiki_Lib_ValidatorsService',
            'tiki.lib.version' => 'getTiki_Lib_VersionService',
            'tiki.lib.vimeo' => 'getTiki_Lib_VimeoService',
            'tiki.lib.vuejs' => 'getTiki_Lib_VuejsService',
            'tiki.lib.webhook' => 'getTiki_Lib_WebhookService',
            'tiki.lib.wiki' => 'getTiki_Lib_WikiService',
            'tiki.lib.wizard' => 'getTiki_Lib_WizardService',
            'tiki.lib.wysiwyg' => 'getTiki_Lib_WysiwygService',
            'tiki.lib.xmpp' => 'getTiki_Lib_XmppService',
            'tiki.lib.zotero' => 'getTiki_Lib_ZoteroService',
            'tiki.mailin.provider.articleput' => 'getTiki_Mailin_Provider_ArticleputService',
            'tiki.mailin.provider.fileput' => 'getTiki_Mailin_Provider_FileputService',
            'tiki.mailin.provider.replyhandler' => 'getTiki_Mailin_Provider_ReplyhandlerService',
            'tiki.mailin.provider.tracker' => 'getTiki_Mailin_Provider_TrackerService',
            'tiki.mailin.provider.wiki' => 'getTiki_Mailin_Provider_WikiService',
            'tiki.mailin.provider.wikiappend' => 'getTiki_Mailin_Provider_WikiappendService',
            'tiki.mailin.provider.wikiget' => 'getTiki_Mailin_Provider_WikigetService',
            'tiki.mailin.provider.wikiprepend' => 'getTiki_Mailin_Provider_WikiprependService',
            'tiki.mailin.provider.wikiput' => 'getTiki_Mailin_Provider_WikiputService',
            'tiki.mailin.providerlist' => 'getTiki_Mailin_ProviderlistService',
            'tiki.recommendation.activity.store' => 'getTiki_Recommendation_Activity_StoreService',
            'tiki.recommendation.content.set' => 'getTiki_Recommendation_Content_SetService',
            'tiki.wiki.slug.dash' => 'getTiki_Wiki_Slug_DashService',
            'tiki.wiki.slug.underscore' => 'getTiki_Wiki_Slug_UnderscoreService',
            'tiki.wiki.slug.urlencode' => 'getTiki_Wiki_Slug_UrlencodeService',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    /**
     * Gets the public 'tiki.controller.access' shared service.
     *
     * @return \Services_Access_Controller
     */
    protected static function getTiki_Controller_AccessService($container)
    {
        return $container->services['tiki.controller.access'] = new \Services_Access_Controller();
    }

    /**
     * Gets the public 'tiki.controller.activitystream' shared service.
     *
     * @return \Services_ActivityStream_Controller
     */
    protected static function getTiki_Controller_ActivitystreamService($container)
    {
        return $container->services['tiki.controller.activitystream'] = new \Services_ActivityStream_Controller();
    }

    /**
     * Gets the public 'tiki.controller.annotation' shared service.
     *
     * @return \Services_Comment_AnnotationController
     */
    protected static function getTiki_Controller_AnnotationService($container)
    {
        return $container->services['tiki.controller.annotation'] = new \Services_Comment_AnnotationController();
    }

    /**
     * Gets the public 'tiki.controller.api_token' shared service.
     *
     * @return \Services_API_TokenController
     */
    protected static function getTiki_Controller_ApiTokenService($container)
    {
        return $container->services['tiki.controller.api_token'] = new \Services_API_TokenController();
    }

    /**
     * Gets the public 'tiki.controller.article' shared service.
     *
     * @return \Services_Article_Controller
     */
    protected static function getTiki_Controller_ArticleService($container)
    {
        return $container->services['tiki.controller.article'] = new \Services_Article_Controller();
    }

    /**
     * Gets the public 'tiki.controller.attribute' shared service.
     *
     * @return \Services_Attribute_Controller
     */
    protected static function getTiki_Controller_AttributeService($container)
    {
        return $container->services['tiki.controller.attribute'] = new \Services_Attribute_Controller();
    }

    /**
     * Gets the public 'tiki.controller.auth_source' shared service.
     *
     * @return \Services_AuthSource_Controller
     */
    protected static function getTiki_Controller_AuthSourceService($container)
    {
        return $container->services['tiki.controller.auth_source'] = new \Services_AuthSource_Controller();
    }

    /**
     * Gets the public 'tiki.controller.autosave' shared service.
     *
     * @return \Services_AutoSave_Controller
     */
    protected static function getTiki_Controller_AutosaveService($container)
    {
        return $container->services['tiki.controller.autosave'] = new \Services_AutoSave_Controller();
    }

    /**
     * Gets the public 'tiki.controller.bigbluebutton' shared service.
     *
     * @return \Services_BigBlueButton_Controller
     */
    protected static function getTiki_Controller_BigbluebuttonService($container)
    {
        return $container->services['tiki.controller.bigbluebutton'] = new \Services_BigBlueButton_Controller();
    }

    /**
     * Gets the public 'tiki.controller.calendar' shared service.
     *
     * @return \Services_Calendar_Controller
     */
    protected static function getTiki_Controller_CalendarService($container)
    {
        return $container->services['tiki.controller.calendar'] = new \Services_Calendar_Controller();
    }

    /**
     * Gets the public 'tiki.controller.calendar_appointment' shared service.
     *
     * @return \Services_Calendar_AppointmentController
     */
    protected static function getTiki_Controller_CalendarAppointmentService($container)
    {
        return $container->services['tiki.controller.calendar_appointment'] = new \Services_Calendar_AppointmentController();
    }

    /**
     * Gets the public 'tiki.controller.calendar_availability' shared service.
     *
     * @return \Services_Calendar_AvailabilityController
     */
    protected static function getTiki_Controller_CalendarAvailabilityService($container)
    {
        return $container->services['tiki.controller.calendar_availability'] = new \Services_Calendar_AvailabilityController();
    }

    /**
     * Gets the public 'tiki.controller.category' shared service.
     *
     * @return \Services_Category_Controller
     */
    protected static function getTiki_Controller_CategoryService($container)
    {
        return $container->services['tiki.controller.category'] = new \Services_Category_Controller();
    }

    /**
     * Gets the public 'tiki.controller.colormodes' shared service.
     *
     * @return \Services_ColorModes_Controller
     */
    protected static function getTiki_Controller_ColormodesService($container)
    {
        return $container->services['tiki.controller.colormodes'] = new \Services_ColorModes_Controller();
    }

    /**
     * Gets the public 'tiki.controller.comment' shared service.
     *
     * @return \Services_Comment_Controller
     */
    protected static function getTiki_Controller_CommentService($container)
    {
        return $container->services['tiki.controller.comment'] = new \Services_Comment_Controller();
    }

    /**
     * Gets the public 'tiki.controller.connect' shared service.
     *
     * @return \Services_Connect_Client
     */
    protected static function getTiki_Controller_ConnectService($container)
    {
        return $container->services['tiki.controller.connect'] = new \Services_Connect_Client();
    }

    /**
     * Gets the public 'tiki.controller.connect_server' shared service.
     *
     * @return \Services_Connect_Server
     */
    protected static function getTiki_Controller_ConnectServerService($container)
    {
        return $container->services['tiki.controller.connect_server'] = new \Services_Connect_Server();
    }

    /**
     * Gets the public 'tiki.controller.contenttemplate' shared service.
     *
     * @return \Services_ContentTemplate_Controller
     */
    protected static function getTiki_Controller_ContenttemplateService($container)
    {
        return $container->services['tiki.controller.contenttemplate'] = new \Services_ContentTemplate_Controller();
    }

    /**
     * Gets the public 'tiki.controller.customroute' shared service.
     *
     * @return \Services_CustomRoute_Controller
     */
    protected static function getTiki_Controller_CustomrouteService($container)
    {
        return $container->services['tiki.controller.customroute'] = new \Services_CustomRoute_Controller();
    }

    /**
     * Gets the public 'tiki.controller.cypht' shared service.
     *
     * @return \Services_Cypht_Controller
     */
    protected static function getTiki_Controller_CyphtService($container)
    {
        return $container->services['tiki.controller.cypht'] = new \Services_Cypht_Controller();
    }

    /**
     * Gets the public 'tiki.controller.diagram' shared service.
     *
     * @return \Services_Diagram_Controller
     */
    protected static function getTiki_Controller_DiagramService($container)
    {
        return $container->services['tiki.controller.diagram'] = new \Services_Diagram_Controller();
    }

    /**
     * Gets the public 'tiki.controller.draw' shared service.
     *
     * @return \Services_Draw_Controller
     */
    protected static function getTiki_Controller_DrawService($container)
    {
        return $container->services['tiki.controller.draw'] = new \Services_Draw_Controller();
    }

    /**
     * Gets the public 'tiki.controller.edit' shared service.
     *
     * @return \Services_Edit_Controller
     */
    protected static function getTiki_Controller_EditService($container)
    {
        return $container->services['tiki.controller.edit'] = new \Services_Edit_Controller();
    }

    /**
     * Gets the public 'tiki.controller.edit_semaphore' shared service.
     *
     * @return \Services_Edit_SemaphoreController
     */
    protected static function getTiki_Controller_EditSemaphoreService($container)
    {
        return $container->services['tiki.controller.edit_semaphore'] = new \Services_Edit_SemaphoreController();
    }

    /**
     * Gets the public 'tiki.controller.encryption' shared service.
     *
     * @return \Services_Encryption_Controller
     */
    protected static function getTiki_Controller_EncryptionService($container)
    {
        return $container->services['tiki.controller.encryption'] = new \Services_Encryption_Controller();
    }

    /**
     * Gets the public 'tiki.controller.export' shared service.
     *
     * @return \Services_Export_Controller
     */
    protected static function getTiki_Controller_ExportService($container)
    {
        return $container->services['tiki.controller.export'] = new \Services_Export_Controller();
    }

    /**
     * Gets the public 'tiki.controller.favorite' shared service.
     *
     * @return \Services_User_FavoriteController
     */
    protected static function getTiki_Controller_FavoriteService($container)
    {
        return $container->services['tiki.controller.favorite'] = new \Services_User_FavoriteController();
    }

    /**
     * Gets the public 'tiki.controller.file' shared service.
     *
     * @return \Services_File_Controller
     */
    protected static function getTiki_Controller_FileService($container)
    {
        return $container->services['tiki.controller.file'] = new \Services_File_Controller();
    }

    /**
     * Gets the public 'tiki.controller.file_finder' shared service.
     *
     * @return \Services_File_FinderController
     */
    protected static function getTiki_Controller_FileFinderService($container)
    {
        return $container->services['tiki.controller.file_finder'] = new \Services_File_FinderController();
    }

    /**
     * Gets the public 'tiki.controller.forum' shared service.
     *
     * @return \Services_Forum_Controller
     */
    protected static function getTiki_Controller_ForumService($container)
    {
        return $container->services['tiki.controller.forum'] = new \Services_Forum_Controller();
    }

    /**
     * Gets the public 'tiki.controller.goal' shared service.
     *
     * @return \Services_Goal_Controller
     */
    protected static function getTiki_Controller_GoalService($container)
    {
        return $container->services['tiki.controller.goal'] = new \Services_Goal_Controller();
    }

    /**
     * Gets the public 'tiki.controller.group' shared service.
     *
     * @return \Services_Group_Controller
     */
    protected static function getTiki_Controller_GroupService($container)
    {
        return $container->services['tiki.controller.group'] = new \Services_Group_Controller();
    }

    /**
     * Gets the public 'tiki.controller.h5p' shared service.
     *
     * @return \Services_H5P_Controller
     */
    protected static function getTiki_Controller_H5pService($container)
    {
        return $container->services['tiki.controller.h5p'] = new \Services_H5P_Controller();
    }

    /**
     * Gets the public 'tiki.controller.iconpicker' shared service.
     *
     * @return \Services_IconPicker_Controller
     */
    protected static function getTiki_Controller_IconpickerService($container)
    {
        return $container->services['tiki.controller.iconpicker'] = new \Services_IconPicker_Controller();
    }

    /**
     * Gets the public 'tiki.controller.ids' shared service.
     *
     * @return \Services_IDS_Controller
     */
    protected static function getTiki_Controller_IdsService($container)
    {
        return $container->services['tiki.controller.ids'] = new \Services_IDS_Controller();
    }

    /**
     * Gets the public 'tiki.controller.kaltura' shared service.
     *
     * @return \Services_Kaltura_Controller
     */
    protected static function getTiki_Controller_KalturaService($container)
    {
        return $container->services['tiki.controller.kaltura'] = new \Services_Kaltura_Controller();
    }

    /**
     * Gets the public 'tiki.controller.language' shared service.
     *
     * @return \Services_Language_Controller
     */
    protected static function getTiki_Controller_LanguageService($container)
    {
        return $container->services['tiki.controller.language'] = new \Services_Language_Controller();
    }

    /**
     * Gets the public 'tiki.controller.mailin' shared service.
     *
     * @return \Services_MailIn_Controller
     */
    protected static function getTiki_Controller_MailinService($container)
    {
        return $container->services['tiki.controller.mailin'] = new \Services_MailIn_Controller();
    }

    /**
     * Gets the public 'tiki.controller.manager' shared service.
     *
     * @return \Services_Manager_Controller
     */
    protected static function getTiki_Controller_ManagerService($container)
    {
        return $container->services['tiki.controller.manager'] = new \Services_Manager_Controller();
    }

    /**
     * Gets the public 'tiki.controller.manager_field' shared service.
     *
     * @return \Services_Manager_FieldController
     */
    protected static function getTiki_Controller_ManagerFieldService($container)
    {
        return $container->services['tiki.controller.manager_field'] = new \Services_Manager_FieldController();
    }

    /**
     * Gets the public 'tiki.controller.manager_patch' shared service.
     *
     * @return \Services_Manager_PatchController
     */
    protected static function getTiki_Controller_ManagerPatchService($container)
    {
        return $container->services['tiki.controller.manager_patch'] = new \Services_Manager_PatchController();
    }

    /**
     * Gets the public 'tiki.controller.managestream' shared service.
     *
     * @return \Services_ActivityStream_ManageController
     */
    protected static function getTiki_Controller_ManagestreamService($container)
    {
        return $container->services['tiki.controller.managestream'] = new \Services_ActivityStream_ManageController();
    }

    /**
     * Gets the public 'tiki.controller.menu' shared service.
     *
     * @return \Services_Menu_Controller
     */
    protected static function getTiki_Controller_MenuService($container)
    {
        return $container->services['tiki.controller.menu'] = new \Services_Menu_Controller();
    }

    /**
     * Gets the public 'tiki.controller.ml' shared service.
     *
     * @return \Services_ML_Controller
     */
    protected static function getTiki_Controller_MlService($container)
    {
        return $container->services['tiki.controller.ml'] = new \Services_ML_Controller();
    }

    /**
     * Gets the public 'tiki.controller.module' shared service.
     *
     * @return \Services_Module_Controller
     */
    protected static function getTiki_Controller_ModuleService($container)
    {
        return $container->services['tiki.controller.module'] = new \Services_Module_Controller();
    }

    /**
     * Gets the public 'tiki.controller.monitor' shared service.
     *
     * @return \Services_User_MonitorController
     */
    protected static function getTiki_Controller_MonitorService($container)
    {
        return $container->services['tiki.controller.monitor'] = new \Services_User_MonitorController();
    }

    /**
     * Gets the public 'tiki.controller.mustread' shared service.
     *
     * @return \Services_MustRead_Controller
     */
    protected static function getTiki_Controller_MustreadService($container)
    {
        return $container->services['tiki.controller.mustread'] = new \Services_MustRead_Controller();
    }

    /**
     * Gets the public 'tiki.controller.oauth' shared service.
     *
     * @return \Services_AuthSource_OAuthController
     */
    protected static function getTiki_Controller_OauthService($container)
    {
        return $container->services['tiki.controller.oauth'] = new \Services_AuthSource_OAuthController();
    }

    /**
     * Gets the public 'tiki.controller.oauthserver' shared service.
     *
     * @return \Services_OAuthServer_Controller
     */
    protected static function getTiki_Controller_OauthserverService($container)
    {
        return $container->services['tiki.controller.oauthserver'] = new \Services_OAuthServer_Controller();
    }

    /**
     * Gets the public 'tiki.controller.object' shared service.
     *
     * @return \Services_Object_Controller
     */
    protected static function getTiki_Controller_ObjectService($container)
    {
        return $container->services['tiki.controller.object'] = new \Services_Object_Controller();
    }

    /**
     * Gets the public 'tiki.controller.payment' shared service.
     *
     * @return \Services_Payment_Controller
     */
    protected static function getTiki_Controller_PaymentService($container)
    {
        return $container->services['tiki.controller.payment'] = new \Services_Payment_Controller();
    }

    /**
     * Gets the public 'tiki.controller.pdf' shared service.
     *
     * @return \Services_PDF_Controller
     */
    protected static function getTiki_Controller_PdfService($container)
    {
        return $container->services['tiki.controller.pdf'] = new \Services_PDF_Controller();
    }

    /**
     * Gets the public 'tiki.controller.performance' shared service.
     *
     * @return \Services_Performance_Controller
     */
    protected static function getTiki_Controller_PerformanceService($container)
    {
        return $container->services['tiki.controller.performance'] = new \Services_Performance_Controller();
    }

    /**
     * Gets the public 'tiki.controller.pivot' shared service.
     *
     * @return \Services_Pivot_Controller
     */
    protected static function getTiki_Controller_PivotService($container)
    {
        return $container->services['tiki.controller.pivot'] = new \Services_Pivot_Controller();
    }

    /**
     * Gets the public 'tiki.controller.plugin' shared service.
     *
     * @return \Services_Edit_PluginController
     */
    protected static function getTiki_Controller_PluginService($container)
    {
        return $container->services['tiki.controller.plugin'] = new \Services_Edit_PluginController();
    }

    /**
     * Gets the public 'tiki.controller.rating' shared service.
     *
     * @return \Services_Rating_Controller
     */
    protected static function getTiki_Controller_RatingService($container)
    {
        return $container->services['tiki.controller.rating'] = new \Services_Rating_Controller();
    }

    /**
     * Gets the public 'tiki.controller.recommendation_dev' shared service.
     *
     * @return \Services_Recommendation_DevelopmentController
     */
    protected static function getTiki_Controller_RecommendationDevService($container)
    {
        return $container->services['tiki.controller.recommendation_dev'] = new \Services_Recommendation_DevelopmentController();
    }

    /**
     * Gets the public 'tiki.controller.recordrtc' shared service.
     *
     * @return \Services_RecordRtc_Controller
     */
    protected static function getTiki_Controller_RecordrtcService($container)
    {
        return $container->services['tiki.controller.recordrtc'] = new \Services_RecordRtc_Controller();
    }

    /**
     * Gets the public 'tiki.controller.relation' shared service.
     *
     * @return \Services_Relation_Controller
     */
    protected static function getTiki_Controller_RelationService($container)
    {
        return $container->services['tiki.controller.relation'] = new \Services_Relation_Controller();
    }

    /**
     * Gets the public 'tiki.controller.report' shared service.
     *
     * @return \Services_Report_Controller
     */
    protected static function getTiki_Controller_ReportService($container)
    {
        return $container->services['tiki.controller.report'] = new \Services_Report_Controller();
    }

    /**
     * Gets the public 'tiki.controller.scheduler' shared service.
     *
     * @return \Services_Scheduler_Controller
     */
    protected static function getTiki_Controller_SchedulerService($container)
    {
        return $container->services['tiki.controller.scheduler'] = new \Services_Scheduler_Controller();
    }

    /**
     * Gets the public 'tiki.controller.score' shared service.
     *
     * @return \Services_Score_Controller
     */
    protected static function getTiki_Controller_ScoreService($container)
    {
        return $container->services['tiki.controller.score'] = new \Services_Score_Controller();
    }

    /**
     * Gets the public 'tiki.controller.search' shared service.
     *
     * @return \Services_Search_Controller
     */
    protected static function getTiki_Controller_SearchService($container)
    {
        return $container->services['tiki.controller.search'] = new \Services_Search_Controller();
    }

    /**
     * Gets the public 'tiki.controller.search_customsearch' shared service.
     *
     * @return \Services_Search_CustomSearchController
     */
    protected static function getTiki_Controller_SearchCustomsearchService($container)
    {
        return $container->services['tiki.controller.search_customsearch'] = new \Services_Search_CustomSearchController();
    }

    /**
     * Gets the public 'tiki.controller.search_manifold' shared service.
     *
     * @return \Services_Search_ManifoldController
     */
    protected static function getTiki_Controller_SearchManifoldService($container)
    {
        return $container->services['tiki.controller.search_manifold'] = new \Services_Search_ManifoldController();
    }

    /**
     * Gets the public 'tiki.controller.search_stored' shared service.
     *
     * @return \Services_Search_StoredController
     */
    protected static function getTiki_Controller_SearchStoredService($container)
    {
        return $container->services['tiki.controller.search_stored'] = new \Services_Search_StoredController();
    }

    /**
     * Gets the public 'tiki.controller.semaphore' shared service.
     *
     * @return \Services_Edit_SemaphoreController
     */
    protected static function getTiki_Controller_SemaphoreService($container)
    {
        return $container->services['tiki.controller.semaphore'] = new \Services_Edit_SemaphoreController();
    }

    /**
     * Gets the public 'tiki.controller.showtikiorg' shared service.
     *
     * @return \Services_ShowTikiOrg_Controller
     */
    protected static function getTiki_Controller_ShowtikiorgService($container)
    {
        return $container->services['tiki.controller.showtikiorg'] = new \Services_ShowTikiOrg_Controller();
    }

    /**
     * Gets the public 'tiki.controller.social' shared service.
     *
     * @return \Services_User_SocialController
     */
    protected static function getTiki_Controller_SocialService($container)
    {
        return $container->services['tiki.controller.social'] = new \Services_User_SocialController();
    }

    /**
     * Gets the public 'tiki.controller.styleguide' shared service.
     *
     * @return \Services_StyleGuide_Controller
     */
    protected static function getTiki_Controller_StyleguideService($container)
    {
        return $container->services['tiki.controller.styleguide'] = new \Services_StyleGuide_Controller();
    }

    /**
     * Gets the public 'tiki.controller.suite' shared service.
     *
     * @return \Services_Suite_Controller
     */
    protected static function getTiki_Controller_SuiteService($container)
    {
        return $container->services['tiki.controller.suite'] = new \Services_Suite_Controller();
    }

    /**
     * Gets the public 'tiki.controller.tabular' shared service.
     *
     * @return \Services_Tracker_TabularController
     */
    protected static function getTiki_Controller_TabularService($container)
    {
        return $container->services['tiki.controller.tabular'] = new \Services_Tracker_TabularController();
    }

    /**
     * Gets the public 'tiki.controller.tracker' shared service.
     *
     * @return \Services_Tracker_Controller
     */
    protected static function getTiki_Controller_TrackerService($container)
    {
        return $container->services['tiki.controller.tracker'] = new \Services_Tracker_Controller();
    }

    /**
     * Gets the public 'tiki.controller.tracker_calendar' shared service.
     *
     * @return \Services_Tracker_CalendarController
     */
    protected static function getTiki_Controller_TrackerCalendarService($container)
    {
        return $container->services['tiki.controller.tracker_calendar'] = new \Services_Tracker_CalendarController();
    }

    /**
     * Gets the public 'tiki.controller.tracker_duration' shared service.
     *
     * @return \Services_Tracker_DurationController
     */
    protected static function getTiki_Controller_TrackerDurationService($container)
    {
        return $container->services['tiki.controller.tracker_duration'] = new \Services_Tracker_DurationController();
    }

    /**
     * Gets the public 'tiki.controller.tracker_sync' shared service.
     *
     * @return \Services_Tracker_SyncController
     */
    protected static function getTiki_Controller_TrackerSyncService($container)
    {
        return $container->services['tiki.controller.tracker_sync'] = new \Services_Tracker_SyncController();
    }

    /**
     * Gets the public 'tiki.controller.tracker_todo' shared service.
     *
     * @return \Services_Tracker_TodoController
     */
    protected static function getTiki_Controller_TrackerTodoService($container)
    {
        return $container->services['tiki.controller.tracker_todo'] = new \Services_Tracker_TodoController();
    }

    /**
     * Gets the public 'tiki.controller.translation' shared service.
     *
     * @return \Services_Language_TranslationController
     */
    protected static function getTiki_Controller_TranslationService($container)
    {
        return $container->services['tiki.controller.translation'] = new \Services_Language_TranslationController();
    }

    /**
     * Gets the public 'tiki.controller.user' shared service.
     *
     * @return \Services_User_Controller
     */
    protected static function getTiki_Controller_UserService($container)
    {
        return $container->services['tiki.controller.user'] = new \Services_User_Controller();
    }

    /**
     * Gets the public 'tiki.controller.user_conditions' shared service.
     *
     * @return \Services_User_ConditionsController
     */
    protected static function getTiki_Controller_UserConditionsService($container)
    {
        return $container->services['tiki.controller.user_conditions'] = new \Services_User_ConditionsController();
    }

    /**
     * Gets the public 'tiki.controller.vimeo' shared service.
     *
     * @return \Services_File_VimeoController
     */
    protected static function getTiki_Controller_VimeoService($container)
    {
        return $container->services['tiki.controller.vimeo'] = new \Services_File_VimeoController();
    }

    /**
     * Gets the public 'tiki.controller.webhook' shared service.
     *
     * @return \Services_API_WebhookController
     */
    protected static function getTiki_Controller_WebhookService($container)
    {
        return $container->services['tiki.controller.webhook'] = new \Services_API_WebhookController();
    }

    /**
     * Gets the public 'tiki.controller.wiki' shared service.
     *
     * @return \Services_Wiki_Controller
     */
    protected static function getTiki_Controller_WikiService($container)
    {
        return $container->services['tiki.controller.wiki'] = new \Services_Wiki_Controller();
    }

    /**
     * Gets the public 'tiki.controller.wiki_structure' shared service.
     *
     * @return \Services_Wiki_StructureController
     */
    protected static function getTiki_Controller_WikiStructureService($container)
    {
        return $container->services['tiki.controller.wiki_structure'] = new \Services_Wiki_StructureController();
    }

    /**
     * Gets the public 'tiki.controller.workspace' shared service.
     *
     * @return \Services_Workspace_Controller
     */
    protected static function getTiki_Controller_WorkspaceService($container)
    {
        return $container->services['tiki.controller.workspace'] = new \Services_Workspace_Controller();
    }

    /**
     * Gets the public 'tiki.controller.xmpp' shared service.
     *
     * @return \Services_Xmpp_Controller
     */
    protected static function getTiki_Controller_XmppService($container)
    {
        return $container->services['tiki.controller.xmpp'] = new \Services_Xmpp_Controller();
    }

    /**
     * Gets the public 'tiki.lib.access' shared service.
     *
     * @return \TikiAccessLib
     */
    protected static function getTiki_Lib_AccessService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/tikiaccesslib.php';

        return $container->services['tiki.lib.access'] = new \TikiAccessLib();
    }

    /**
     * Gets the public 'tiki.lib.accounting' shared service.
     *
     * @return \AccountingLib
     */
    protected static function getTiki_Lib_AccountingService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/accounting/accountinglib.php';

        return $container->services['tiki.lib.accounting'] = new \AccountingLib();
    }

    /**
     * Gets the public 'tiki.lib.activity' shared service.
     *
     * @return \ActivityLib
     */
    protected static function getTiki_Lib_ActivityService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/activity/activitylib.php';

        return $container->services['tiki.lib.activity'] = new \ActivityLib();
    }

    /**
     * Gets the public 'tiki.lib.addressbook' shared service.
     *
     * @return \AddressBookLib
     */
    protected static function getTiki_Lib_AddressbookService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/webmail/addressbooklib.php';

        return $container->services['tiki.lib.addressbook'] = new \AddressBookLib();
    }

    /**
     * Gets the public 'tiki.lib.admin' shared service.
     *
     * @return \AdminLib
     */
    protected static function getTiki_Lib_AdminService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/admin/adminlib.php';

        return $container->services['tiki.lib.admin'] = new \AdminLib();
    }

    /**
     * Gets the public 'tiki.lib.api_token' shared service.
     *
     * @return \ApiToken
     */
    protected static function getTiki_Lib_ApiTokenService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/auth/api_token.php';

        return $container->services['tiki.lib.api_token'] = new \ApiToken();
    }

    /**
     * Gets the public 'tiki.lib.areas' shared service.
     *
     * @return \AreasLib
     */
    protected static function getTiki_Lib_AreasService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/perspective/binderlib.php';

        return $container->services['tiki.lib.areas'] = new \AreasLib();
    }

    /**
     * Gets the public 'tiki.lib.art' shared service.
     *
     * @return \ArtLib
     */
    protected static function getTiki_Lib_ArtService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/articles/artlib.php';

        return $container->services['tiki.lib.art'] = new \ArtLib();
    }

    /**
     * Gets the public 'tiki.lib.attribute' shared service.
     *
     * @return \AttributeLib
     */
    protected static function getTiki_Lib_AttributeService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/attributes/attributelib.php';

        return $container->services['tiki.lib.attribute'] = new \AttributeLib();
    }

    /**
     * Gets the public 'tiki.lib.autosave' shared service.
     *
     * @return \AutoSaveLib
     */
    protected static function getTiki_Lib_AutosaveService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/ajax/autosave.php';

        return $container->services['tiki.lib.autosave'] = new \AutoSaveLib();
    }

    /**
     * Gets the public 'tiki.lib.avatar' shared service.
     *
     * @return \AvatarLib
     */
    protected static function getTiki_Lib_AvatarService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/avatarlib.php';

        return $container->services['tiki.lib.avatar'] = new \AvatarLib();
    }

    /**
     * Gets the public 'tiki.lib.banner' shared service.
     *
     * @return \BannerLib
     */
    protected static function getTiki_Lib_BannerService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/banners/bannerlib.php';

        return $container->services['tiki.lib.banner'] = new \BannerLib();
    }

    /**
     * Gets the public 'tiki.lib.bigbluebutton' shared service.
     *
     * @return \BigBlueButtonLib
     */
    protected static function getTiki_Lib_BigbluebuttonService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/bigbluebuttonlib.php';

        return $container->services['tiki.lib.bigbluebutton'] = new \BigBlueButtonLib();
    }

    /**
     * Gets the public 'tiki.lib.blacklist' shared service.
     *
     * @return \blacklistLib
     */
    protected static function getTiki_Lib_BlacklistService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/user/blacklistlib.php';

        return $container->services['tiki.lib.blacklist'] = new \blacklistLib();
    }

    /**
     * Gets the public 'tiki.lib.blog' shared service.
     *
     * @return \BlogLib
     */
    protected static function getTiki_Lib_BlogService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/blogs/bloglib.php';

        return $container->services['tiki.lib.blog'] = new \BlogLib();
    }

    /**
     * Gets the public 'tiki.lib.cache' shared service.
     *
     * @return \CacheLib
     */
    protected static function getTiki_Lib_CacheService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/cache/cachelib.php';

        return $container->services['tiki.lib.cache'] = new \CacheLib();
    }

    /**
     * Gets the public 'tiki.lib.calendar' shared service.
     *
     * @return \CalendarLib
     */
    protected static function getTiki_Lib_CalendarService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/calendar/calendarlib.php';

        return $container->services['tiki.lib.calendar'] = new \CalendarLib();
    }

    /**
     * Gets the public 'tiki.lib.captcha' shared service.
     *
     * @return \Captcha
     */
    protected static function getTiki_Lib_CaptchaService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/captcha/captchalib.php';

        return $container->services['tiki.lib.captcha'] = new \Captcha();
    }

    /**
     * Gets the public 'tiki.lib.cart' shared service.
     *
     * @return \CartLib
     */
    protected static function getTiki_Lib_CartService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/payment/cartlib.php';

        return $container->services['tiki.lib.cart'] = new \CartLib();
    }

    /**
     * Gets the public 'tiki.lib.categ' shared service.
     *
     * @return \CategLib
     */
    protected static function getTiki_Lib_CategService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/categories/categlib.php';

        return $container->services['tiki.lib.categ'] = new \CategLib();
    }

    /**
     * Gets the public 'tiki.lib.comments' shared service.
     *
     * @return \Comments
     */
    protected static function getTiki_Lib_CommentsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/comments/commentslib.php';

        return $container->services['tiki.lib.comments'] = new \Comments();
    }

    /**
     * Gets the public 'tiki.lib.connect' shared service.
     *
     * @return \Tiki_Connect_Client
     */
    protected static function getTiki_Lib_ConnectService($container)
    {
        return $container->services['tiki.lib.connect'] = new \Tiki_Connect_Client();
    }

    /**
     * Gets the public 'tiki.lib.connect_server' shared service.
     *
     * @return \Tiki_Connect_Server
     */
    protected static function getTiki_Lib_ConnectServerService($container)
    {
        return $container->services['tiki.lib.connect_server'] = new \Tiki_Connect_Server();
    }

    /**
     * Gets the public 'tiki.lib.contact' shared service.
     *
     * @return \ContactLib
     */
    protected static function getTiki_Lib_ContactService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/webmail/contactlib.php';

        return $container->services['tiki.lib.contact'] = new \ContactLib();
    }

    /**
     * Gets the public 'tiki.lib.contribution' shared service.
     *
     * @return \ContributionLib
     */
    protected static function getTiki_Lib_ContributionService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/contribution/contributionlib.php';

        return $container->services['tiki.lib.contribution'] = new \ContributionLib();
    }

    /**
     * Gets the public 'tiki.lib.credits' shared service.
     *
     * @return \CreditsLib
     */
    protected static function getTiki_Lib_CreditsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/credits/creditslib.php';

        return $container->services['tiki.lib.credits'] = new \CreditsLib();
    }

    /**
     * Gets the public 'tiki.lib.crypt' shared service.
     *
     * @return \CryptLib
     */
    protected static function getTiki_Lib_CryptService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/crypt/cryptlib.php';

        return $container->services['tiki.lib.crypt'] = new \CryptLib();
    }

    /**
     * Gets the public 'tiki.lib.css' shared service.
     *
     * @return \cssLib
     */
    protected static function getTiki_Lib_CssService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/csslib.php';

        return $container->services['tiki.lib.css'] = new \cssLib();
    }

    /**
     * Gets the public 'tiki.lib.custom_route' shared service.
     *
     * @return \Tiki\CustomRoute\CustomRouteLib
     */
    protected static function getTiki_Lib_CustomRouteService($container)
    {
        return $container->services['tiki.lib.custom_route'] = new \Tiki\CustomRoute\CustomRouteLib();
    }

    /**
     * Gets the public 'tiki.lib.dcs' shared service.
     *
     * @return \DCSLib
     */
    protected static function getTiki_Lib_DcsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/dcs/dcslib.php';

        return $container->services['tiki.lib.dcs'] = new \DCSLib();
    }

    /**
     * Gets the public 'tiki.lib.edit' shared service.
     *
     * @return \EditLib
     */
    protected static function getTiki_Lib_EditService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/wiki/editlib.php';

        return $container->services['tiki.lib.edit'] = new \EditLib();
    }

    /**
     * Gets the public 'tiki.lib.encryption' shared service.
     *
     * @return \EncryptionLib
     */
    protected static function getTiki_Lib_EncryptionService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/crypt/encryptionlib.php';

        return $container->services['tiki.lib.encryption'] = new \EncryptionLib();
    }

    /**
     * Gets the public 'tiki.lib.error' shared service.
     *
     * @return \ErrorManagerLib
     */
    protected static function getTiki_Lib_ErrorService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/error/errormanagerlib.php';

        return $container->services['tiki.lib.error'] = new \ErrorManagerLib();
    }

    /**
     * Gets the public 'tiki.lib.errortracking' shared service.
     *
     * @return \ErrorTracking
     */
    protected static function getTiki_Lib_ErrortrackingService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/setup/error_tracking.php';

        return $container->services['tiki.lib.errortracking'] = new \ErrorTracking();
    }

    /**
     * Gets the public 'tiki.lib.events' shared service.
     *
     * @return \Tiki_Event_Manager
     */
    protected static function getTiki_Lib_EventsService($container)
    {
        return $container->services['tiki.lib.events'] = new \Tiki_Event_Manager();
    }

    /**
     * Gets the public 'tiki.lib.faq' shared service.
     *
     * @return \FaqLib
     */
    protected static function getTiki_Lib_FaqService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/faqs/faqlib.php';

        return $container->services['tiki.lib.faq'] = new \FaqLib();
    }

    /**
     * Gets the public 'tiki.lib.federatedsearch' shared service.
     *
     * @return \FederatedSearchLib
     */
    protected static function getTiki_Lib_FederatedsearchService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/search/federatedsearchlib.php';

        return $container->services['tiki.lib.federatedsearch'] = new \FederatedSearchLib(($container->services['tiki.lib.unifiedsearch'] ?? self::getTiki_Lib_UnifiedsearchService($container)));
    }

    /**
     * Gets the public 'tiki.lib.filegal' shared service.
     *
     * @return \FileGalLib
     */
    protected static function getTiki_Lib_FilegalService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/filegals/filegallib.php';

        return $container->services['tiki.lib.filegal'] = new \FileGalLib();
    }

    /**
     * Gets the public 'tiki.lib.filegalbatch' shared service.
     *
     * @return \FileGalBatchLib
     */
    protected static function getTiki_Lib_FilegalbatchService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/filegals/filegalbatchlib.php';

        return $container->services['tiki.lib.filegalbatch'] = new \FileGalBatchLib();
    }

    /**
     * Gets the public 'tiki.lib.filegalcopy' shared service.
     *
     * @return \FileGalCopyLib
     */
    protected static function getTiki_Lib_FilegalcopyService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/filegals/filegalcopylib.php';

        return $container->services['tiki.lib.filegalcopy'] = new \FileGalCopyLib();
    }

    /**
     * Gets the public 'tiki.lib.flaggedrevision' shared service.
     *
     * @return \FlaggedRevisionLib
     */
    protected static function getTiki_Lib_FlaggedrevisionService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/wiki/flaggedrevisionlib.php';

        return $container->services['tiki.lib.flaggedrevision'] = new \FlaggedRevisionLib();
    }

    /**
     * Gets the public 'tiki.lib.freetag' shared service.
     *
     * @return \FreetagLib
     */
    protected static function getTiki_Lib_FreetagService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/freetag/freetaglib.php';

        return $container->services['tiki.lib.freetag'] = new \FreetagLib();
    }

    /**
     * Gets the public 'tiki.lib.geo' shared service.
     *
     * @return \GeoLib
     */
    protected static function getTiki_Lib_GeoService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/geo/geolib.php';

        return $container->services['tiki.lib.geo'] = new \GeoLib();
    }

    /**
     * Gets the public 'tiki.lib.git' shared service.
     *
     * @return \GitLib
     */
    protected static function getTiki_Lib_GitService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/gitlib.php';

        return $container->services['tiki.lib.git'] = new \GitLib();
    }

    /**
     * Gets the public 'tiki.lib.goal' shared service.
     *
     * @return \GoalLib
     */
    protected static function getTiki_Lib_GoalService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/goal/goallib.php';

        return $container->services['tiki.lib.goal'] = new \GoalLib();
    }

    /**
     * Gets the public 'tiki.lib.goalevent' shared service.
     *
     * @return \GoalEventLib
     */
    protected static function getTiki_Lib_GoaleventService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/goal/eventlib.php';

        return $container->services['tiki.lib.goalevent'] = new \GoalEventLib();
    }

    /**
     * Gets the public 'tiki.lib.goalreward' shared service.
     *
     * @return \GoalRewardLib
     */
    protected static function getTiki_Lib_GoalrewardService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/goal/rewardlib.php';

        return $container->services['tiki.lib.goalreward'] = new \GoalRewardLib();
    }

    /**
     * Gets the public 'tiki.lib.groupalert' shared service.
     *
     * @return \GroupAlertLib
     */
    protected static function getTiki_Lib_GroupalertService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/groupalert/groupalertlib.php';

        return $container->services['tiki.lib.groupalert'] = new \GroupAlertLib();
    }

    /**
     * Gets the public 'tiki.lib.h5p' shared service.
     *
     * @return \H5PLib
     */
    protected static function getTiki_Lib_H5pService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/filegals/h5plib.php';

        return $container->services['tiki.lib.h5p'] = new \H5PLib();
    }

    /**
     * Gets the public 'tiki.lib.header' shared service.
     *
     * @return \HeaderLib
     */
    protected static function getTiki_Lib_HeaderService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/headerlib.php';

        return $container->services['tiki.lib.header'] = new \HeaderLib();
    }

    /**
     * Gets the public 'tiki.lib.hist' shared service.
     *
     * @return \HistLib
     */
    protected static function getTiki_Lib_HistService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/wiki/histlib.php';

        return $container->services['tiki.lib.hist'] = new \HistLib();
    }

    /**
     * Gets the public 'tiki.lib.iconset' shared service.
     *
     * @return \IconsetLib
     */
    protected static function getTiki_Lib_IconsetService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/theme/iconsetlib.php';

        return $container->services['tiki.lib.iconset'] = new \IconsetLib();
    }

    /**
     * Gets the public 'tiki.lib.ilpinvoicepayment' shared service.
     *
     * @return \Tiki\Lib\Payment\ILPInvoicePaymentLib
     */
    protected static function getTiki_Lib_IlpinvoicepaymentService($container)
    {
        return $container->services['tiki.lib.ilpinvoicepayment'] = new \Tiki\Lib\Payment\ILPInvoicePaymentLib();
    }

    /**
     * Gets the public 'tiki.lib.imagegal' shared service.
     *
     * @return \ImageGalsLib
     */
    protected static function getTiki_Lib_ImagegalService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/imagegals/imagegallib.php';

        return $container->services['tiki.lib.imagegal'] = new \ImageGalsLib();
    }

    /**
     * Gets the public 'tiki.lib.kalturaadmin' shared service.
     *
     * @return \KalturaLib
     */
    protected static function getTiki_Lib_KalturaadminService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/videogals/kalturalib.php';

        return $container->services['tiki.lib.kalturaadmin'] = new \KalturaLib('2');
    }

    /**
     * Gets the public 'tiki.lib.kalturauser' shared service.
     *
     * @return \KalturaLib
     */
    protected static function getTiki_Lib_KalturauserService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/videogals/kalturalib.php';

        return $container->services['tiki.lib.kalturauser'] = new \KalturaLib('0');
    }

    /**
     * Gets the public 'tiki.lib.language' shared service.
     *
     * @return \Language
     */
    protected static function getTiki_Lib_LanguageService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/language/Language.php';

        return $container->services['tiki.lib.language'] = new \Language();
    }

    /**
     * Gets the public 'tiki.lib.languagetranslations' shared service.
     *
     * @return \LanguageTranslations
     */
    protected static function getTiki_Lib_LanguagetranslationsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/language/LanguageTranslations.php';

        return $container->services['tiki.lib.languagetranslations'] = new \LanguageTranslations();
    }

    /**
     * Gets the public 'tiki.lib.ldap' shared service.
     *
     * @return \LdapLib
     */
    protected static function getTiki_Lib_LdapService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/ldap/ldaplib.php';

        return $container->services['tiki.lib.ldap'] = new \LdapLib();
    }

    /**
     * Gets the public 'tiki.lib.login' shared service.
     *
     * @return \LoginLib
     */
    protected static function getTiki_Lib_LoginService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/loginlib.php';

        return $container->services['tiki.lib.login'] = new \LoginLib();
    }

    /**
     * Gets the public 'tiki.lib.logs' shared service.
     *
     * @return \Tiki\Lib\Logs\LogsLib
     */
    protected static function getTiki_Lib_LogsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/Logs/LogsLib.php';

        return $container->services['tiki.lib.logs'] = new \Tiki\Lib\Logs\LogsLib();
    }

    /**
     * Gets the public 'tiki.lib.logsqry' shared service.
     *
     * @return \Tiki\Lib\Logs\LogsQueryLib
     */
    protected static function getTiki_Lib_LogsqryService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/Logs/LogsQueryLib.php';

        return $container->services['tiki.lib.logsqry'] = new \Tiki\Lib\Logs\LogsQueryLib();
    }

    /**
     * Gets the public 'tiki.lib.mailin' shared service.
     *
     * @return \MailinLib
     */
    protected static function getTiki_Lib_MailinService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/mailin/mailinlib.php';

        return $container->services['tiki.lib.mailin'] = new \MailinLib();
    }

    /**
     * Gets the public 'tiki.lib.memcache' shared service.
     *
     * @return \Memcachelib
     */
    protected static function getTiki_Lib_MemcacheService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/cache/memcachelib.php';

        return $container->services['tiki.lib.memcache'] = new \Memcachelib();
    }

    /**
     * Gets the public 'tiki.lib.menu' shared service.
     *
     * @return \MenuLib
     */
    protected static function getTiki_Lib_MenuService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/menubuilder/menulib.php';

        return $container->services['tiki.lib.menu'] = new \MenuLib();
    }

    /**
     * Gets the public 'tiki.lib.message' shared service.
     *
     * @return \Messu
     */
    protected static function getTiki_Lib_MessageService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/messu/messulib.php';

        return $container->services['tiki.lib.message'] = new \Messu();
    }

    /**
     * Gets the public 'tiki.lib.mime' shared service.
     *
     * @return \MimeLib
     */
    protected static function getTiki_Lib_MimeService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/mime/mimelib.php';

        return $container->services['tiki.lib.mime'] = new \MimeLib();
    }

    /**
     * Gets the public 'tiki.lib.ml' shared service.
     *
     * @return \MachineLearningLib
     */
    protected static function getTiki_Lib_MlService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/ml/mllib.php';

        return $container->services['tiki.lib.ml'] = new \MachineLearningLib();
    }

    /**
     * Gets the public 'tiki.lib.mod' shared service.
     *
     * @return \ModLib
     */
    protected static function getTiki_Lib_ModService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/modules/modlib.php';

        return $container->services['tiki.lib.mod'] = new \ModLib();
    }

    /**
     * Gets the public 'tiki.lib.monitor' shared service.
     *
     * @return \MonitorLib
     */
    protected static function getTiki_Lib_MonitorService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/user/monitorlib.php';

        return $container->services['tiki.lib.monitor'] = new \MonitorLib();
    }

    /**
     * Gets the public 'tiki.lib.monitormail' shared service.
     *
     * @return \MonitorMailLib
     */
    protected static function getTiki_Lib_MonitormailService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/user/monitormaillib.php';

        return $container->services['tiki.lib.monitormail'] = new \MonitorMailLib();
    }

    /**
     * Gets the public 'tiki.lib.multilingual' shared service.
     *
     * @return \MultilingualLib
     */
    protected static function getTiki_Lib_MultilingualService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/multilingual/multilinguallib.php';

        return $container->services['tiki.lib.multilingual'] = new \MultilingualLib();
    }

    /**
     * Gets the public 'tiki.lib.newsletter' shared service.
     *
     * @return \NlLib
     */
    protected static function getTiki_Lib_NewsletterService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/newsletters/nllib.php';

        return $container->services['tiki.lib.newsletter'] = new \NlLib();
    }

    /**
     * Gets the public 'tiki.lib.notification' shared service.
     *
     * @return \NotificationLib
     */
    protected static function getTiki_Lib_NotificationService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/notifications/notificationlib.php';

        return $container->services['tiki.lib.notification'] = new \NotificationLib();
    }

    /**
     * Gets the public 'tiki.lib.oauth' shared service.
     *
     * @return \OAuthLib
     */
    protected static function getTiki_Lib_OauthService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/oauthlib.php';

        return $container->services['tiki.lib.oauth'] = new \OAuthLib();
    }

    /**
     * Gets the public 'tiki.lib.oauthserver' shared service.
     *
     * @return \OAuthServerLib
     */
    protected static function getTiki_Lib_OauthserverService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/oauthserver/oauthserverlib.php';

        return $container->services['tiki.lib.oauthserver'] = new \OAuthServerLib();
    }

    /**
     * Gets the public 'tiki.lib.object' shared service.
     *
     * @return \ObjectLib
     */
    protected static function getTiki_Lib_ObjectService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/objectlib.php';

        return $container->services['tiki.lib.object'] = new \ObjectLib();
    }

    /**
     * Gets the public 'tiki.lib.objectselector' shared service.
     *
     * @return \Tiki\ObjectSelector\Selector
     */
    protected static function getTiki_Lib_ObjectselectorService($container)
    {
        return $container->services['tiki.lib.objectselector'] = new \Tiki\ObjectSelector\Selector(($container->services['tiki.lib.object'] ?? self::getTiki_Lib_ObjectService($container)));
    }

    /**
     * Gets the public 'tiki.lib.ocr' shared service.
     *
     * @return \ocrLib
     */
    protected static function getTiki_Lib_OcrService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/ocrlib.php';

        return $container->services['tiki.lib.ocr'] = new \ocrLib();
    }

    /**
     * Gets the public 'tiki.lib.openidconnect' shared service.
     *
     * @return \Tiki\Lib\OpenIdConnect\OpenIdConnectLib
     */
    protected static function getTiki_Lib_OpenidconnectService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/OpenIdConnect/OpenIdConnectLib.php';

        return $container->services['tiki.lib.openidconnect'] = new \Tiki\Lib\OpenIdConnect\OpenIdConnectLib();
    }

    /**
     * Gets the public 'tiki.lib.pagecontent' shared service.
     *
     * @return \PageContentLib
     */
    protected static function getTiki_Lib_PagecontentService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/rss/pagecontentlib.php';

        return $container->services['tiki.lib.pagecontent'] = new \PageContentLib();
    }

    /**
     * Gets the public 'tiki.lib.parser' shared service.
     *
     * @return \ParserLib
     */
    protected static function getTiki_Lib_ParserService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/parser/parserlib.php';

        return $container->services['tiki.lib.parser'] = new \ParserLib();
    }

    /**
     * Gets the public 'tiki.lib.payment' shared service.
     *
     * @return \PaymentLib
     */
    protected static function getTiki_Lib_PaymentService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/payment/paymentlib.php';

        return $container->services['tiki.lib.payment'] = new \PaymentLib();
    }

    /**
     * Gets the public 'tiki.lib.pdfimages' shared service.
     *
     * @return \PdfImagesLib
     */
    protected static function getTiki_Lib_PdfimagesService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/pdfimages.php';

        return $container->services['tiki.lib.pdfimages'] = new \PdfImagesLib();
    }

    /**
     * Gets the public 'tiki.lib.performancestats' shared service.
     *
     * @return \PerformanceStatsLib
     */
    protected static function getTiki_Lib_PerformancestatsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/performance/performancestatslib.php';

        return $container->services['tiki.lib.performancestats'] = new \PerformanceStatsLib();
    }

    /**
     * Gets the public 'tiki.lib.perspective' shared service.
     *
     * @return \PerspectiveLib
     */
    protected static function getTiki_Lib_PerspectiveService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/perspectivelib.php';

        return $container->services['tiki.lib.perspective'] = new \PerspectiveLib();
    }

    /**
     * Gets the public 'tiki.lib.poll' shared service.
     *
     * @return \PollLib
     */
    protected static function getTiki_Lib_PollService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/polls/polllib.php';

        return $container->services['tiki.lib.poll'] = new \PollLib();
    }

    /**
     * Gets the public 'tiki.lib.prefs' shared service.
     *
     * @return \PreferencesLib
     */
    protected static function getTiki_Lib_PrefsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/prefslib.php';

        return $container->services['tiki.lib.prefs'] = new \PreferencesLib();
    }

    /**
     * Gets the public 'tiki.lib.quantify' shared service.
     *
     * @return \QuantifyLib
     */
    protected static function getTiki_Lib_QuantifyService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/wiki/quantifylib.php';

        return $container->services['tiki.lib.quantify'] = new \QuantifyLib();
    }

    /**
     * Gets the public 'tiki.lib.queue' shared service.
     *
     * @return \QueueLib
     */
    protected static function getTiki_Lib_QueueService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/queuelib.php';

        return $container->services['tiki.lib.queue'] = new \QueueLib();
    }

    /**
     * Gets the public 'tiki.lib.quiz' shared service.
     *
     * @return \QuizLib
     */
    protected static function getTiki_Lib_QuizService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/quizzes/quizlib.php';

        return $container->services['tiki.lib.quiz'] = new \QuizLib();
    }

    /**
     * Gets the public 'tiki.lib.rating' shared service.
     *
     * @return \RatingLib
     */
    protected static function getTiki_Lib_RatingService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/rating/ratinglib.php';

        return $container->services['tiki.lib.rating'] = new \RatingLib();
    }

    /**
     * Gets the public 'tiki.lib.ratingconfig' shared service.
     *
     * @return \RatingConfigLib
     */
    protected static function getTiki_Lib_RatingconfigService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/rating/configlib.php';

        return $container->services['tiki.lib.ratingconfig'] = new \RatingConfigLib();
    }

    /**
     * Gets the public 'tiki.lib.recommendationcontentbatch' shared service.
     *
     * @return \Tiki\Recommendation\BatchProcessor
     */
    protected static function getTiki_Lib_RecommendationcontentbatchService($container)
    {
        return $container->services['tiki.lib.recommendationcontentbatch'] = new \Tiki\Recommendation\BatchProcessor(($container->services['tiki.recommendation.activity.store'] ?? self::getTiki_Recommendation_Activity_StoreService($container)), ($container->services['tiki.recommendation.content.set'] ??= new \Tiki\Recommendation\EngineSet()));
    }

    /**
     * Gets the public 'tiki.lib.references' shared service.
     *
     * @return \ReferencesLib
     */
    protected static function getTiki_Lib_ReferencesService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/references/referenceslib.php';

        return $container->services['tiki.lib.references'] = new \ReferencesLib();
    }

    /**
     * Gets the public 'tiki.lib.registration' shared service.
     *
     * @return \RegistrationLib
     */
    protected static function getTiki_Lib_RegistrationService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/registration/registrationlib.php';

        return $container->services['tiki.lib.registration'] = new \RegistrationLib();
    }

    /**
     * Gets the public 'tiki.lib.relation' shared service.
     *
     * @return \RelationLib
     */
    protected static function getTiki_Lib_RelationService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/attributes/relationlib.php';

        return $container->services['tiki.lib.relation'] = new \RelationLib();
    }

    /**
     * Gets the public 'tiki.lib.roles' shared service.
     *
     * @return \Tiki\Group\Roles\RolesLib
     */
    protected static function getTiki_Lib_RolesService($container)
    {
        return $container->services['tiki.lib.roles'] = new \Tiki\Group\Roles\RolesLib();
    }

    /**
     * Gets the public 'tiki.lib.rss' shared service.
     *
     * @return \RSSLib
     */
    protected static function getTiki_Lib_RssService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/rss/rsslib.php';

        return $container->services['tiki.lib.rss'] = new \RSSLib();
    }

    /**
     * Gets the public 'tiki.lib.scheduler' shared service.
     *
     * @return \SchedulersLib
     */
    protected static function getTiki_Lib_SchedulerService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/schedulerslib.php';

        return $container->services['tiki.lib.scheduler'] = new \SchedulersLib();
    }

    /**
     * Gets the public 'tiki.lib.score' shared service.
     *
     * @return \ScoreLib
     */
    protected static function getTiki_Lib_ScoreService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/score/scorelib.php';

        return $container->services['tiki.lib.score'] = new \ScoreLib();
    }

    /**
     * Gets the public 'tiki.lib.scorm' shared service.
     *
     * @return \ScormLib
     */
    protected static function getTiki_Lib_ScormService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/filegals/scormlib.php';

        return $container->services['tiki.lib.scorm'] = new \ScormLib();
    }

    /**
     * Gets the public 'tiki.lib.searchstats' shared service.
     *
     * @return \SearchStatsLib
     */
    protected static function getTiki_Lib_SearchstatsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/search/searchstatslib.php';

        return $container->services['tiki.lib.searchstats'] = new \SearchStatsLib();
    }

    /**
     * Gets the public 'tiki.lib.semantic' shared service.
     *
     * @return \SemanticLib
     */
    protected static function getTiki_Lib_SemanticService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/wiki/semanticlib.php';

        return $container->services['tiki.lib.semantic'] = new \SemanticLib();
    }

    /**
     * Gets the public 'tiki.lib.service' shared service.
     *
     * @return \ServiceLib
     */
    protected static function getTiki_Lib_ServiceService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/servicelib.php';

        return $container->services['tiki.lib.service'] = new \ServiceLib();
    }

    /**
     * Gets the public 'tiki.lib.sheet' shared service.
     *
     * @return \SheetLib
     */
    protected static function getTiki_Lib_SheetService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/sheet/sheetlib.php';

        return $container->services['tiki.lib.sheet'] = new \SheetLib();
    }

    /**
     * Gets the public 'tiki.lib.slugmanager' shared service.
     *
     * @return \Tiki\Wiki\SlugManager
     */
    protected static function getTiki_Lib_SlugmanagerService($container)
    {
        $container->services['tiki.lib.slugmanager'] = $instance = new \Tiki\Wiki\SlugManager();

        $instance->addGenerator(($container->services['tiki.wiki.slug.dash'] ??= new \Tiki\Wiki\SlugManager\DashGenerator()));
        $instance->addGenerator(($container->services['tiki.wiki.slug.underscore'] ??= new \Tiki\Wiki\SlugManager\UnderscoreGenerator()));
        $instance->addGenerator(($container->services['tiki.wiki.slug.urlencode'] ??= new \Tiki\Wiki\SlugManager\UrlencodeGenerator()));

        return $instance;
    }

    /**
     * Gets the public 'tiki.lib.smarty' shared service.
     *
     * @return \Smarty_Tiki
     */
    protected static function getTiki_Lib_SmartyService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/init/smarty.php';

        return $container->services['tiki.lib.smarty'] = new \Smarty_Tiki();
    }

    /**
     * Gets the public 'tiki.lib.social' shared service.
     *
     * @return \SocialLib
     */
    protected static function getTiki_Lib_SocialService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/user/sociallib.php';

        return $container->services['tiki.lib.social'] = new \SocialLib();
    }

    /**
     * Gets the public 'tiki.lib.stats' shared service.
     *
     * @return \StatsLib
     */
    protected static function getTiki_Lib_StatsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/stats/statslib.php';

        return $container->services['tiki.lib.stats'] = new \StatsLib();
    }

    /**
     * Gets the public 'tiki.lib.storedsearch' shared service.
     *
     * @return \StoredSearchLib
     */
    protected static function getTiki_Lib_StoredsearchService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/search/storedsearchlib.php';

        return $container->services['tiki.lib.storedsearch'] = new \StoredSearchLib();
    }

    /**
     * Gets the public 'tiki.lib.struct' shared service.
     *
     * @return \StructLib
     */
    protected static function getTiki_Lib_StructService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/structures/structlib.php';

        return $container->services['tiki.lib.struct'] = new \StructLib();
    }

    /**
     * Gets the public 'tiki.lib.symbols' shared service.
     *
     * @return \Tiki_Profile_SymbolLoader
     */
    protected static function getTiki_Lib_SymbolsService($container)
    {
        return $container->services['tiki.lib.symbols'] = new \Tiki_Profile_SymbolLoader();
    }

    /**
     * Gets the public 'tiki.lib.tabular' shared service.
     *
     * @return \Tracker\Tabular\Manager
     */
    protected static function getTiki_Lib_TabularService($container)
    {
        return $container->services['tiki.lib.tabular'] = new \Tracker\Tabular\Manager(($container->services['tiki.lib.db'] ?? $container->get('tiki.lib.db', 1)));
    }

    /**
     * Gets the public 'tiki.lib.template' shared service.
     *
     * @return \TemplatesLib
     */
    protected static function getTiki_Lib_TemplateService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/templates/templateslib.php';

        return $container->services['tiki.lib.template'] = new \TemplatesLib();
    }

    /**
     * Gets the public 'tiki.lib.theme' shared service.
     *
     * @return \ThemeLib
     */
    protected static function getTiki_Lib_ThemeService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/theme/themelib.php';

        return $container->services['tiki.lib.theme'] = new \ThemeLib();
    }

    /**
     * Gets the public 'tiki.lib.themecontrol' shared service.
     *
     * @return \ThemeControlLib
     */
    protected static function getTiki_Lib_ThemecontrolService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/theme/themecontrollib.php';

        return $container->services['tiki.lib.themecontrol'] = new \ThemeControlLib();
    }

    /**
     * Gets the public 'tiki.lib.tikicalendar' shared service.
     *
     * @return \TikiCalendarLib
     */
    protected static function getTiki_Lib_TikicalendarService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/calendar/tikicalendarlib.php';

        return $container->services['tiki.lib.tikicalendar'] = new \TikiCalendarLib();
    }

    /**
     * Gets the public 'tiki.lib.tikidate' shared service.
     *
     * @return \TikiDate
     */
    protected static function getTiki_Lib_TikidateService($container)
    {
        return $container->services['tiki.lib.tikidate'] = new \TikiDate();
    }

    /**
     * Gets the public 'tiki.lib.todo' shared service.
     *
     * @return \TodoLib
     */
    protected static function getTiki_Lib_TodoService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/todolib.php';

        return $container->services['tiki.lib.todo'] = new \TodoLib();
    }

    /**
     * Gets the public 'tiki.lib.trk' shared service.
     *
     * @return \TrackerLib
     */
    protected static function getTiki_Lib_TrkService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/trackers/trackerlib.php';

        return $container->services['tiki.lib.trk'] = new \TrackerLib();
    }

    /**
     * Gets the public 'tiki.lib.tsbounces' shared service.
     *
     * @return \Tracker\System\Bounces
     */
    protected static function getTiki_Lib_TsbouncesService($container)
    {
        return $container->services['tiki.lib.tsbounces'] = new \Tracker\System\Bounces();
    }

    /**
     * Gets the public 'tiki.lib.unifiedsearch' shared service.
     *
     * @return \UnifiedSearchLib
     */
    protected static function getTiki_Lib_UnifiedsearchService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/search/searchlib-unified.php';

        return $container->services['tiki.lib.unifiedsearch'] = new \UnifiedSearchLib();
    }

    /**
     * Gets the public 'tiki.lib.user' shared service.
     *
     * @return \UsersLib
     */
    protected static function getTiki_Lib_UserService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/userslib.php';

        return $container->services['tiki.lib.user'] = new \UsersLib();
    }

    /**
     * Gets the public 'tiki.lib.usermailin' shared service.
     *
     * @return \UserMailinLib
     */
    protected static function getTiki_Lib_UsermailinService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/mailin/usermailinlib.php';

        return $container->services['tiki.lib.usermailin'] = new \UserMailinLib();
    }

    /**
     * Gets the public 'tiki.lib.usermodules' shared service.
     *
     * @return \UserModulesLib
     */
    protected static function getTiki_Lib_UsermodulesService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/usermodules/usermoduleslib.php';

        return $container->services['tiki.lib.usermodules'] = new \UserModulesLib();
    }

    /**
     * Gets the public 'tiki.lib.userprefs' shared service.
     *
     * @return \UserPrefsLib
     */
    protected static function getTiki_Lib_UserprefsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/userprefs/userprefslib.php';

        return $container->services['tiki.lib.userprefs'] = new \UserPrefsLib();
    }

    /**
     * Gets the public 'tiki.lib.validators' shared service.
     *
     * @return \Validators
     */
    protected static function getTiki_Lib_ValidatorsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/validatorslib.php';

        return $container->services['tiki.lib.validators'] = new \Validators();
    }

    /**
     * Gets the public 'tiki.lib.version' shared service.
     *
     * @return \TWVersion
     */
    protected static function getTiki_Lib_VersionService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/setup/twversion.class.php';

        return $container->services['tiki.lib.version'] = new \TWVersion();
    }

    /**
     * Gets the public 'tiki.lib.vimeo' shared service.
     *
     * @return \VimeoLib
     */
    protected static function getTiki_Lib_VimeoService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/filegals/vimeolib.php';

        return $container->services['tiki.lib.vimeo'] = new \VimeoLib(($container->services['tiki.lib.oauth'] ?? self::getTiki_Lib_OauthService($container)));
    }

    /**
     * Gets the public 'tiki.lib.vuejs' shared service.
     *
     * @return \VueJsLib
     */
    protected static function getTiki_Lib_VuejsService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/vue/vuejslib.php';

        return $container->services['tiki.lib.vuejs'] = new \VueJsLib();
    }

    /**
     * Gets the public 'tiki.lib.webhook' shared service.
     *
     * @return \Webhook
     */
    protected static function getTiki_Lib_WebhookService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/auth/webhook.php';

        return $container->services['tiki.lib.webhook'] = new \Webhook();
    }

    /**
     * Gets the public 'tiki.lib.wiki' shared service.
     *
     * @return \WikiLib
     */
    protected static function getTiki_Lib_WikiService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/wiki/wikilib.php';

        return $container->services['tiki.lib.wiki'] = new \WikiLib();
    }

    /**
     * Gets the public 'tiki.lib.wizard' shared service.
     *
     * @return \WizardLib
     */
    protected static function getTiki_Lib_WizardService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/wizard/wizardlib.php';

        return $container->services['tiki.lib.wizard'] = new \WizardLib();
    }

    /**
     * Gets the public 'tiki.lib.wysiwyg' shared service.
     *
     * @return \WYSIWYGLib
     */
    protected static function getTiki_Lib_WysiwygService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/ckeditor_tiki/wysiwyglib.php';

        return $container->services['tiki.lib.wysiwyg'] = new \WYSIWYGLib();
    }

    /**
     * Gets the public 'tiki.lib.xmpp' shared service.
     *
     * @return \XMPPLib
     */
    protected static function getTiki_Lib_XmppService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/xmpp/xmpplib.php';

        return $container->services['tiki.lib.xmpp'] = new \XMPPLib();
    }

    /**
     * Gets the public 'tiki.lib.zotero' shared service.
     *
     * @return \ZoteroLib
     */
    protected static function getTiki_Lib_ZoteroService($container)
    {
        include_once '/home/ushindi/tikipack/27.4/tiki-27.4/lib/zoterolib.php';

        return $container->services['tiki.lib.zotero'] = new \ZoteroLib();
    }

    /**
     * Gets the public 'tiki.mailin.provider.articleput' shared service.
     *
     * @return \Tiki\MailIn\Provider\ArticlePutProvider
     */
    protected static function getTiki_Mailin_Provider_ArticleputService($container)
    {
        return $container->services['tiki.mailin.provider.articleput'] = new \Tiki\MailIn\Provider\ArticlePutProvider();
    }

    /**
     * Gets the public 'tiki.mailin.provider.fileput' shared service.
     *
     * @return \Tiki\MailIn\Provider\FilePutProvider
     */
    protected static function getTiki_Mailin_Provider_FileputService($container)
    {
        return $container->services['tiki.mailin.provider.fileput'] = new \Tiki\MailIn\Provider\FilePutProvider();
    }

    /**
     * Gets the public 'tiki.mailin.provider.replyhandler' shared service.
     *
     * @return \Tiki\MailIn\Provider\ReplyHandlerProvider
     */
    protected static function getTiki_Mailin_Provider_ReplyhandlerService($container)
    {
        return $container->services['tiki.mailin.provider.replyhandler'] = new \Tiki\MailIn\Provider\ReplyHandlerProvider();
    }

    /**
     * Gets the public 'tiki.mailin.provider.tracker' shared service.
     *
     * @return \Tiki\MailIn\Provider\TrackerProvider
     */
    protected static function getTiki_Mailin_Provider_TrackerService($container)
    {
        return $container->services['tiki.mailin.provider.tracker'] = new \Tiki\MailIn\Provider\TrackerProvider();
    }

    /**
     * Gets the public 'tiki.mailin.provider.wiki' shared service.
     *
     * @return \Tiki\MailIn\Provider\WikiMultipleProvider
     */
    protected static function getTiki_Mailin_Provider_WikiService($container)
    {
        return $container->services['tiki.mailin.provider.wiki'] = new \Tiki\MailIn\Provider\WikiMultipleProvider();
    }

    /**
     * Gets the public 'tiki.mailin.provider.wikiappend' shared service.
     *
     * @return \Tiki\MailIn\Provider\BasicWikiProvider
     */
    protected static function getTiki_Mailin_Provider_WikiappendService($container)
    {
        return $container->services['tiki.mailin.provider.wikiappend'] = new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-append', 'Append to wiki page', 'Tiki\\MailIn\\Action\\WikiAppend');
    }

    /**
     * Gets the public 'tiki.mailin.provider.wikiget' shared service.
     *
     * @return \Tiki\MailIn\Provider\BasicWikiProvider
     */
    protected static function getTiki_Mailin_Provider_WikigetService($container)
    {
        return $container->services['tiki.mailin.provider.wikiget'] = new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-get', 'Send page to user', 'Tiki\\MailIn\\Action\\WikiPut');
    }

    /**
     * Gets the public 'tiki.mailin.provider.wikiprepend' shared service.
     *
     * @return \Tiki\MailIn\Provider\BasicWikiProvider
     */
    protected static function getTiki_Mailin_Provider_WikiprependService($container)
    {
        return $container->services['tiki.mailin.provider.wikiprepend'] = new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-prepend', 'Prepend to wiki page', 'Tiki\\MailIn\\Action\\WikiPrepend');
    }

    /**
     * Gets the public 'tiki.mailin.provider.wikiput' shared service.
     *
     * @return \Tiki\MailIn\Provider\BasicWikiProvider
     */
    protected static function getTiki_Mailin_Provider_WikiputService($container)
    {
        return $container->services['tiki.mailin.provider.wikiput'] = new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-put', 'Create or update wiki page', 'Tiki\\MailIn\\Action\\WikiPut');
    }

    /**
     * Gets the public 'tiki.mailin.providerlist' shared service.
     *
     * @return \Tiki\MailIn\Provider\ProviderList
     */
    protected static function getTiki_Mailin_ProviderlistService($container)
    {
        $container->services['tiki.mailin.providerlist'] = $instance = new \Tiki\MailIn\Provider\ProviderList();

        $instance->addProvider(($container->services['tiki.mailin.provider.wikiput'] ??= new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-put', 'Create or update wiki page', 'Tiki\\MailIn\\Action\\WikiPut')));
        $instance->addProvider(($container->services['tiki.mailin.provider.wikiget'] ??= new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-get', 'Send page to user', 'Tiki\\MailIn\\Action\\WikiPut')));
        $instance->addProvider(($container->services['tiki.mailin.provider.wikiappend'] ??= new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-append', 'Append to wiki page', 'Tiki\\MailIn\\Action\\WikiAppend')));
        $instance->addProvider(($container->services['tiki.mailin.provider.wikiprepend'] ??= new \Tiki\MailIn\Provider\BasicWikiProvider('wiki-prepend', 'Prepend to wiki page', 'Tiki\\MailIn\\Action\\WikiPrepend')));
        $instance->addProvider(($container->services['tiki.mailin.provider.wiki'] ??= new \Tiki\MailIn\Provider\WikiMultipleProvider()));
        $instance->addProvider(($container->services['tiki.mailin.provider.replyhandler'] ??= new \Tiki\MailIn\Provider\ReplyHandlerProvider()));
        $instance->addProvider(($container->services['tiki.mailin.provider.articleput'] ??= new \Tiki\MailIn\Provider\ArticlePutProvider()));
        $instance->addProvider(($container->services['tiki.mailin.provider.fileput'] ??= new \Tiki\MailIn\Provider\FilePutProvider()));
        $instance->addProvider(($container->services['tiki.mailin.provider.tracker'] ??= new \Tiki\MailIn\Provider\TrackerProvider()));

        return $instance;
    }

    /**
     * Gets the public 'tiki.recommendation.activity.store' shared service.
     *
     * @return \Tiki\Recommendation\Store\ActivityStore
     */
    protected static function getTiki_Recommendation_Activity_StoreService($container)
    {
        return $container->services['tiki.recommendation.activity.store'] = new \Tiki\Recommendation\Store\ActivityStore(($container->services['tiki.lib.unifiedsearch'] ?? self::getTiki_Lib_UnifiedsearchService($container)), ($container->services['tiki.lib.relation'] ?? self::getTiki_Lib_RelationService($container)), ($container->services['tiki.lib.events'] ??= new \Tiki_Event_Manager()));
    }

    /**
     * Gets the public 'tiki.recommendation.content.set' shared service.
     *
     * @return \Tiki\Recommendation\EngineSet
     */
    protected static function getTiki_Recommendation_Content_SetService($container)
    {
        return $container->services['tiki.recommendation.content.set'] = new \Tiki\Recommendation\EngineSet();
    }

    /**
     * Gets the public 'tiki.wiki.slug.dash' shared service.
     *
     * @return \Tiki\Wiki\SlugManager\DashGenerator
     */
    protected static function getTiki_Wiki_Slug_DashService($container)
    {
        return $container->services['tiki.wiki.slug.dash'] = new \Tiki\Wiki\SlugManager\DashGenerator();
    }

    /**
     * Gets the public 'tiki.wiki.slug.underscore' shared service.
     *
     * @return \Tiki\Wiki\SlugManager\UnderscoreGenerator
     */
    protected static function getTiki_Wiki_Slug_UnderscoreService($container)
    {
        return $container->services['tiki.wiki.slug.underscore'] = new \Tiki\Wiki\SlugManager\UnderscoreGenerator();
    }

    /**
     * Gets the public 'tiki.wiki.slug.urlencode' shared service.
     *
     * @return \Tiki\Wiki\SlugManager\UrlencodeGenerator
     */
    protected static function getTiki_Wiki_Slug_UrlencodeService($container)
    {
        return $container->services['tiki.wiki.slug.urlencode'] = new \Tiki\Wiki\SlugManager\UrlencodeGenerator();
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name);
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        throw new ParameterNotFoundException($name);
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.root_dir' => '/home/ushindi/tikipack/27.4/tiki-27.4',
            'tiki.version' => '27.4',
            'tiki.packages.extensions' => [

            ],
        ];
    }
}
