<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
function prefs_home_list($partial = false)
{

    return [
        'home_blog' => [
            'name' => tra('Home blog (main blog)'),
            'type' => 'list',
            'options' => $partial ? [] : listblog_pref(),
            'default' => 0,
            'profile_reference' => 'blog',
        ],
        'home_forum' => [
            'name' => tra('Home forum (main forum)'),
            'type' => 'text',
            'default' => 0,
            'profile_reference' => 'forum',
        ],
        'home_file_gallery' => [
            'name' => tra('Home file gallery (main file gallery)'),
            'description' => tra('Select the default file gallery'),
            'type' => 'list',
            'options' => $partial ? [] : listfgal_pref(),
            'default' => 1,
            'profile_reference' => 'file_gallery',
        ],
    ];
}

/**
 * listfgal_pref: retrieve the list of file galleries for the home_file_gallery preference
 *
 * @access public
 * @return array: galleryId => name(truncated)
 */
function listfgal_pref()
{
    $filegallib = TikiLib::lib('filegal');

    global $prefs;
    $allfgals = $filegallib->getSubGalleries($prefs['fgal_root_id']);
    $rootgal = $filegallib->get_file_gallery($prefs['fgal_root_id']);
    if ($rootgal) {
        array_unshift($allfgals['data'], $rootgal);
        $allfgals['data'][0]['id'] = $allfgals['data'][0]['galleryId']; // sometimes galleries have a galleryId, sometimes it's in id :(
    }

    $listfgals = [];

    if ($allfgals['cant'] > 0) {
        foreach ($allfgals['data'] as $onefgal) {
            $listfgals[ $onefgal['id'] ] = substr($onefgal['name'], 0, 30);
        }
    } else {
        $listfgals[''] = tra('No file gallery available (create one first)');
    }

    return $listfgals;
}

/**
 * listblog_pref: retrieve the list of blogs for the home_blog preference
 *
 * @access public
 * @return array: blogId => title(truncated)
 */
function listblog_pref()
{
    $bloglib = TikiLib::lib('blog');

    $allblogs = $bloglib->list_blogs(0, -1, 'created_desc', '');
    $listblogs = ['' => 'None'];

    if ($allblogs['cant'] > 0) {
        foreach ($allblogs['data'] as $blog) {
            $listblogs[ $blog['blogId'] ] = substr($blog['title'], 0, 30);
        }
    } else {
        $listblogs[''] = tra('No blog available (create one first)');
    }

    return $listblogs;
}
