<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
class Services_User_SocialController
{
    private $lib;

    public function setUp()
    {
        global $user;
        Services_Exception_Disabled::check('feature_friends');

        if (! $user) {
            throw new Services_Exception_Denied(tr('Must be registered'));
        }

        $this->lib = TikiLib::lib('social');
    }

    public function action_list_friends($input)
    {
        global $user;
        // Checks if the username param was passed, if so return that user's friend list
        // otherwise it returns the active user's friend list
        if (empty($input->username->text()) || $input->username->text() == $user) {
            $username = $user;
            $incoming = $this->lib->listIncomingRequests($username);
            $outgoing = $this->lib->listOutgoingRequests($username);
        } else {
            $username = $input->username->text();
        }

        if (empty($input->show_add_friend->text())) {
            $show_add_friend = 'y';
        } else {
            $show_add_friend = $input->show_add_friend->text();
        }

        $friends = $this->lib->listFriends($username);

        return [
            'title' => tr('Friend List'),
            'friends' => $friends,
            'incoming' => $incoming,
            'outgoing' => $outgoing,
            'showbutton' => $show_add_friend,
            'username' => $username,
        ];
    }

    public function action_add_friend($input)
    {
        global $user;

        $username = $input->username->email();
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            if ($username) {
                if (! $this->lib->addFriend($user, $username)) {
                    throw new Services_Exception_FieldError('username', tr('User not found.'));
                }
            }
        }

        return [
            'title' => tr('Add Friend'),
            'username' => $username,
        ];
    }

    public function action_approve_friend($input)
    {
        global $user;

        $username = $input->friend->email();
        $status = null;
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            if ($username) {
                $this->lib->approveFriend($user, $username);
                $status = 'DONE';
            }
        }

        return [
            'title' => tr('Approve Friend'),
            'username' => $username,
            'status' => $status,
        ];
    }

    public function action_remove_friend($input)
    {
        global $user;

        $status = null;
        $username = $input->friend->email();

        if (! $username) {
            throw new Services_Exception_MissingValue('friend');
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $this->lib->removeFriend($user, $username);
            $status = 'DONE';
        }

        return [
            'title' => tr('Remove Friend'),
            'status' => $status,
            'friend' => $username,
        ];
    }

    public function action_like($input)
    {
        global $user;

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $this->lib->addLike($user, $input->type->text(), $input->id->none());
        }

        return [];
    }

    public function action_unlike($input)
    {
        global $user;

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $this->lib->removeLike($user, $input->type->text(), $input->id->none());
        }

        return [];
    }
}
