<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id$

/**
 * @return array
 */
function module_last_created_faqs_info()
{
    return [
        'name' => tra('Newest FAQs'),
        'description' => tra('Displays the specified number of FAQs from newest to oldest.'),
        'prefs' => ["feature_faqs"],
        'params' => [],
        'common_params' => ['nonums', 'rows']
    ];
}

/**
 * @param $mod_reference
 * @param $module_params
 */
function module_last_created_faqs($mod_reference, $module_params)
{
    $smarty = TikiLib::lib('smarty');

    $faqlib = TikiLib::lib('faq');
    $ranking = $faqlib->list_faqs(0, $mod_reference["rows"], 'created_desc', '');

    $smarty->assign('modLastCreatedFaqs', $ranking["data"]);
}
