<?php

/**
 * The Japanese language file - try to be the best of Japanese
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Tadashi Jokagi <https://poyo.jp/>
 * @author Minoru TODA <todam@netjapan.co.jp>
 * @copyright 2004-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2004-02-19
 * @codingStandardsIgnoreFile
 */

$PMF_LANG['metaCharset'] = 'UTF-8';
$PMF_LANG['metaLanguage'] = 'ja';
$PMF_LANG['language'] = '日本語';
$PMF_LANG['direction']= 'ltr';
$PMF_LANG['nplurals'] = '0';
$PMF_LANG['msgCategory'] = 'カテゴリー';
$PMF_LANG['msgShowAllCategories'] = '全カテゴリーを表示する';
$PMF_LANG['msgSearch'] = '検索';
$PMF_LANG['msgAddContent'] = '内容の追加';
$PMF_LANG['msgQuestion'] = '質問をする';
$PMF_LANG['msgOpenQuestions'] = '質問を開く';
$PMF_LANG['msgHelp'] = 'ヘルプ';
$PMF_LANG['msgContact'] = '問い合わせ';
$PMF_LANG['msgHome'] = 'FAQ ホーム';
$PMF_LANG['msgNews'] = 'お知らせ';
$PMF_LANG['msgUserOnline'] = 'ユーザーがオンライン';
$PMF_LANG['msgBack2Home'] = 'メイン ページに戻る';
$PMF_LANG['msgFullCategories'] = 'FAQ とカテゴリー';
$PMF_LANG['msgFullCategoriesIn'] = 'カテゴリー';
$PMF_LANG['msgSubCategories'] = '下位カテゴリー';
$PMF_LANG['msgEntries'] = 'FAQ';
$PMF_LANG['msgEntriesIn'] = 'カテゴリー名: ';
$PMF_LANG['msgViews'] = '回の閲覧';
$PMF_LANG['msgPage'] = 'ページ ';
$PMF_LANG['msgPages'] = 'ページ中';
$PMF_LANG['msgPrevious'] = '前へ';
$PMF_LANG['msgNext'] = '次へ';
$PMF_LANG['msgCategoryUp'] = '上位カテゴリーへ';
$PMF_LANG['msgLastUpdateArticle'] = '最終更新: ';
$PMF_LANG['msgAuthor'] = '製作者';
$PMF_LANG['msgPrinterFriendly'] = '印刷用バージョン';
$PMF_LANG['msgPrintArticle'] = 'このレコードを印刷する';
$PMF_LANG['msgMakeXMLExport'] = 'XML ファイルとしてエクスポート';
$PMF_LANG['msgAverageVote'] = '評価点数:';
$PMF_LANG['msgVoteUsability'] = 'この FAQ を評価';
$PMF_LANG['msgVoteFrom'] = ' - ';
$PMF_LANG['msgVoteBad'] = '完全に役に立たない';
$PMF_LANG['msgVoteGood'] = '最も価値がある';
$PMF_LANG['msgVotings'] = '個の投票 ';
$PMF_LANG['msgVoteSubmit'] = '投票';
$PMF_LANG['msgVoteThanks'] = '投票を非常に感謝します!';
$PMF_LANG['msgYouCan'] = '';
$PMF_LANG['msgWriteComment'] = 'この FAQ にコメントする';
$PMF_LANG['msgShowCategory'] = '内容の概要: ';
$PMF_LANG['msgCommentBy'] = 'コメント作成は';
$PMF_LANG['msgCommentHeader'] = 'この FAQ にコメント';
$PMF_LANG['msgYourComment'] = 'あなたのコメント:';
$PMF_LANG['msgCommentThanks'] = 'コメントを非常に感謝します!';
$PMF_LANG['msgSend2Friend'] = '友達に教える';
$PMF_LANG['msgS2FButton'] = 'メール送信';
$PMF_LANG['msgSearchWord'] = 'キーワード';
$PMF_LANG['msgSearchFind'] = '検索結果 ';
$PMF_LANG['msgSearchAmount'] = ' 検索結果';
$PMF_LANG['msgSearchAmounts'] = ' 検索結果';
$PMF_LANG['msgSearchCategory'] = 'カテゴリー: ';
$PMF_LANG['msgSearchContent'] = '回答: ';
$PMF_LANG['msgNewContentHeader'] = '新しい FAQ を提案する';
$PMF_LANG['msgNewContentAddon'] = "あなたの提案はすぐには表示されませんが、公開前に当社によってチェックされます。必須フィールドは、* でマークされたフィールドです。";
$PMF_LANG['msgNewContentName'] = '名前:';
$PMF_LANG['msgNewContentMail'] = '電子メールアドレス:';
$PMF_LANG['msgNewContentCategory'] = 'カテゴリー:';
$PMF_LANG['msgNewContentTheme'] = '質問:';
$PMF_LANG['msgNewContentArticle'] = '回答:';
$PMF_LANG['msgNewContentKeywords'] = 'キーワード:';
$PMF_LANG['msgNewContentLink'] = '関連リンク先:';
$PMF_LANG['msgNewContentSubmit'] = '送信';
$PMF_LANG['msgInfo'] = '追加情報: ';
$PMF_LANG['msgNewContentThanks'] = 'ご提案ありがとうございます!';
$PMF_LANG['msgNoQuestionsAvailable'] = '現在処理すべき質問がありません。';
$PMF_LANG['msgNewQuestion'] = '質問したい内容を入力してください:';
$PMF_LANG['msgAskCategory'] = 'カテゴリー:';
$PMF_LANG['msgAskYourQuestion'] = '質問:';
$PMF_LANG['msgAskThx4Mail'] = '<h2>ご質問、ありがとうございます!</h2>';
$PMF_LANG['msgDate_User'] = '日付 / ユーザー';
$PMF_LANG['msgQuestion2'] = '質問';
$PMF_LANG['msg2answer'] = '回答';
$PMF_LANG['msgQuestionText'] = '他のユーザーが質問した内容を確認することができます。質問に答えた場合、管理者の確認後、FAQに追加されます。';
$PMF_LANG['msgHelpText'] = 'このFAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions) の利用方法が簡単です。<strong><a href="?action=show">カテゴリー</a></strong> から関連内容を項目別に探すか <strong><a href="?action=search">検索</a></strong> からキーワードを入力して探すことができます。';
$PMF_LANG['msgContactEMail'] = '管理者に電子メール:';
$PMF_LANG['msgMessage'] = 'メッセージ:';
$PMF_LANG['msgTopTen'] = '最も人気の FAQ';
$PMF_LANG['msgHomeThereAre'] = '合計 ';
$PMF_LANG['msgHomeArticlesOnline'] = ' 個の FAQ があります。';
$PMF_LANG['msgNoNews'] = '新しいお知らせはありません。';
$PMF_LANG['msgLatestArticles'] = '最近の FAQ';
$PMF_LANG['msgMailThanks'] = 'FAQ へのご提案ありがとうございます。';
$PMF_LANG['msgMailCheck'] = '新しい質問があります。管理者ページを確認してください。';
$PMF_LANG['msgMailContact'] = 'メッセージは管理者に送信されました。';
$PMF_LANG['err_noDatabase'] = 'データベース接続が有効ではありません。';
$PMF_LANG['err_noHeaders'] = 'カテゴリーが見つかりません。';
$PMF_LANG['msgErrorNoRecords'] = '登録されている FAQ がありません。';
$PMF_LANG['err_badID'] = '間違った ID です。';
$PMF_LANG['err_noTopTen'] = '人気の FAQ がまだ利用できません。';
$PMF_LANG['err_nothingFound'] = 'エントリーが見つかりません。';
$PMF_LANG['err_SaveEntries'] = '<strong>名前</strong>、<strong>メールアドレス</strong>、<strong>カテゴリー</strong>、<strong>件名</strong>、<strong>FAQ 内容</strong>、要求された場合は <strong><a href="https://ja.wikipedia.org/wiki/Captcha" title="Wikipedia で Captcha について読む" target="_blank">Captcha</a> コード</strong> は必須フィールドです!<br><br><a href="javascript:history.back();">戻る</a><br><br>';
$PMF_LANG['err_SaveComment'] = '<strong>名前</strong>、<strong>メールアドレス</strong>、<strong>コメント</strong>と要求された場合は <strong><a href="https://ja.wikipedia.org/wiki/Captcha" title="Wikipedia で Captcha について読む" target="_blank">Captcha</a> コード</strong> は必須項目です!<br><br><a href="javascript:history.back();">戻る</a><br><br>';
$PMF_LANG['err_VoteTooMuch'] = '複数回の評価はできません。ここをクリックすると戻ります。';
$PMF_LANG['err_noVote'] = '<strong>評価点数を選択してください。</strong> 評価をするためには<a href="javascript:history.back();">ここ</a>をクリックしてください。';
$PMF_LANG['err_noMailAdress'] = 'メールアドレスが正しくありません。<br><a href="javascript:history.back();">戻る</a>';
$PMF_LANG['err_sendMail'] = '<strong>名前</strong>、<strong>メールアドレス</strong>、<strong>質問</strong>と要求された場合は <strong><a href="https://ja.wikipedia.org/wiki/Captcha" title="Wikipedia で Captcha について読む" target="_blank">Captcha</a> コード</strong> は必須項目です!';
$PMF_LANG['help_search'] = '<strong>内容検索: </strong><br><strong style="color: Red;">言葉1 言葉2</strong>のように検索すると、2 個以上の検索結果が関連度が高い順番で表示されます。<strong>注意:</strong> 英文を検索する際には、少なくとも 4 文字以上を入力してください。';
$PMF_LANG['ad'] = '管理者ページ';
$PMF_LANG['ad_menu_user_administration'] = 'ユーザー';
$PMF_LANG['ad_menu_entry_aprove'] = 'FAQ の認証';
$PMF_LANG['ad_menu_entry_edit'] = 'FAQ の編集';
$PMF_LANG['ad_menu_categ_add'] = 'カテゴリーの追加';
$PMF_LANG['msgHeaderCategoryOverview'] = 'カテゴリー';
$PMF_LANG['ad_menu_news_add'] = 'お知らせの追加';
$PMF_LANG['ad_menu_news_edit'] = 'お知らせの変更';
$PMF_LANG['ad_menu_open'] = '質問を開く';
$PMF_LANG['ad_menu_stat'] = '評価統計';
$PMF_LANG['ad_menu_cookie'] = 'Cookie の設定';
$PMF_LANG['ad_menu_session'] = 'セッションの閲覧';
$PMF_LANG['ad_menu_adminlog'] = '管理ログの閲覧';
$PMF_LANG['ad_menu_passwd'] = 'パスワードの変更';
$PMF_LANG['ad_menu_logout'] = 'ログアウト';
$PMF_LANG['ad_menu_startpage'] = '開始ページ';
$PMF_LANG['ad_msg_identify'] = 'ログインをしてください。';
$PMF_LANG['ad_msg_passmatch'] = 'パスワードは必ず <strong>一致</strong> する必要があります。';
$PMF_LANG['ad_msg_savedsuc_1'] = '';
$PMF_LANG['ad_msg_savedsuc_2'] = '　のプロフィールの保存に成功しました。';
$PMF_LANG['ad_msg_mysqlerr'] = '<strong>データベースのエラー</strong>のため、プロフィールが保存できません。';
$PMF_LANG['ad_msg_noauth'] = '使用権限がありません。';
$PMF_LANG['ad_gen_page'] = 'ページ';
$PMF_LANG['ad_gen_of'] = 'of';
$PMF_LANG['ad_gen_lastpage'] = '前のページ';
$PMF_LANG['ad_gen_nextpage'] = '次のページ';
$PMF_LANG['ad_gen_save'] = '保存';
$PMF_LANG['ad_gen_reset'] = 'リセット';
$PMF_LANG['ad_gen_yes'] = 'はい';
$PMF_LANG['ad_gen_no'] = 'いいえ';
$PMF_LANG['ad_gen_top'] = 'ページの先頭';
$PMF_LANG['ad_gen_ncf'] = 'カテゴリーが見つかりません!';
$PMF_LANG['ad_gen_delete'] = '削除';
$PMF_LANG['ad_user'] = 'ユーザー管理';
$PMF_LANG['ad_user_username'] = '登録済みユーザー一覧';
$PMF_LANG['ad_user_rights'] = '権限一覧';
$PMF_LANG['ad_user_edit'] = '変更';
$PMF_LANG['ad_user_delete'] = '削除';
$PMF_LANG['ad_user_add'] = 'ユーザー追加';
$PMF_LANG['ad_user_profou'] = 'ユーザーのプロフィール';
$PMF_LANG['ad_user_name'] = 'ID';
$PMF_LANG['ad_user_password'] = 'パスワード';
$PMF_LANG['ad_user_confirm'] = 'パスワードの確認';
$PMF_LANG['ad_user_del_1'] = 'ユーザー';
$PMF_LANG['ad_user_del_2'] = 'を削除しますか?';
$PMF_LANG['ad_user_del_3'] = '本当に削除しますか?';
$PMF_LANG['ad_user_deleted'] = 'ユーザーの削除に成功しました。';
$PMF_LANG['ad_user_checkall'] = 'すべて選択';
$PMF_LANG['msgHeaderFAQOverview'] = 'レコードの管理';
$PMF_LANG['ad_entry_id'] = 'ID';
$PMF_LANG['ad_entry_topic'] = 'トピック';
$PMF_LANG['ad_entry_action'] = '操作';
$PMF_LANG['ad_entry_edit_1'] = 'レコードの変更';
$PMF_LANG['ad_entry_edit_2'] = '';
$PMF_LANG['ad_entry_theme'] = '質問:';
$PMF_LANG['ad_entry_content'] = '回答:';
$PMF_LANG['ad_entry_keywords'] = 'キーワード:';
$PMF_LANG['ad_entry_author'] = '作成者:';
$PMF_LANG['ad_entry_category'] = 'カテゴリー:';
$PMF_LANG['ad_entry_active'] = '有効にする';
$PMF_LANG['ad_entry_date'] = '日付';
$PMF_LANG['ad_entry_status'] = 'Status der FAQ';
$PMF_LANG['ad_entry_changed'] = '変更しますか?';
$PMF_LANG['ad_entry_changelog'] = '変更履歴';
$PMF_LANG['ad_entry_commentby'] = 'コメント作成者';
$PMF_LANG['ad_entry_comment'] = 'コメント:';
$PMF_LANG['ad_entry_save'] = '保存';
$PMF_LANG['msgDelete'] = '削除';
$PMF_LANG['ad_entry_delcom_1'] = ' ';
$PMF_LANG['ad_entry_delcom_2'] = '　さんのコメントを削除しますか？';
$PMF_LANG['ad_entry_commentdelsuc'] = 'コメントの<strong>削除に成功</strong>しました。';
$PMF_LANG['ad_entry_back'] = '戻る';
$PMF_LANG['ad_entry_commentdelfail'] = 'コメントの<strong>削除に失敗</strong>しました。';
$PMF_LANG['ad_entry_savedsuc'] = '変更の保存に <strong>成功</strong>しました。';
$PMF_LANG['ad_entry_savedfail   '] = '<strong>データベースのエラー</strong>が発生しました。';
$PMF_LANG['ad_entry_del_1'] = ' ';
$PMF_LANG['ad_entry_del_2'] = 'に関する';
$PMF_LANG['ad_entry_del_3'] = ' さんのレコードを削除しますか？';
$PMF_LANG['ad_entry_delsuc'] = '削除に<strong>成功</strong>しました。';
$PMF_LANG['ad_entry_delfail'] = '削除に<strong>失敗</strong>しました。';
$PMF_LANG['ad_news_header'] = 'お知らせの件名:';
$PMF_LANG['ad_news_text'] = '内容:';
$PMF_LANG['ad_news_link_url'] = '関連リンク:';
$PMF_LANG['ad_news_link_title'] = 'リンクのタイトル:';
$PMF_LANG['ad_news_link_target'] = 'リンクのターゲット:';
$PMF_LANG['ad_news_link_window'] = '新規ウィンドウでリンクを開く';
$PMF_LANG['ad_news_link_faq'] = 'FAQ 内のリンク';
$PMF_LANG['ad_news_add'] = 'お知らせの追加';
$PMF_LANG['ad_news_id'] = '#';
$PMF_LANG['ad_news_headline'] = '件名';
$PMF_LANG['ad_news_date'] = '日付';
$PMF_LANG['ad_news_action'] = '操作';
$PMF_LANG['ad_news_update'] = '更新';
$PMF_LANG['ad_news_delete'] = '削除';
$PMF_LANG['ad_news_nodata'] = 'データベースにデータが見つかりませんでした。';
$PMF_LANG['ad_news_updatesuc'] = '更新しました。';
$PMF_LANG['ad_news_del'] = 'これを削除しますか?';
$PMF_LANG['ad_news_yesdelete'] = 'はい、削除します!';
$PMF_LANG['ad_news_nodelete'] = 'いいえ!';
$PMF_LANG['ad_news_delsuc'] = '削除しました。';
$PMF_LANG['ad_news_updatenews'] = 'お知らせの項目を更新しました';
$PMF_LANG['ad_categ_new'] = '新しいカテゴリーの追加';
$PMF_LANG['ad_categ_catnum'] = 'カテゴリー番号:';
$PMF_LANG['ad_categ_subcatnum'] = 'サブカテゴリー番号:';
$PMF_LANG['ad_categ_nya'] = '<em>利用できません!</em>';
$PMF_LANG['ad_categ_titel'] = 'カテゴリー名';
$PMF_LANG['ad_categ_add'] = 'カテゴリー追加';
$PMF_LANG['ad_categ_existing'] = '存在するカテゴリー一覧';
$PMF_LANG['ad_categ_id'] = '#';
$PMF_LANG['ad_categ_categ'] = 'カテゴリー';
$PMF_LANG['ad_categ_subcateg'] = '下位カテゴリー';
$PMF_LANG['ad_categ_action'] = '操作';
$PMF_LANG['ad_categ_update'] = '更新';
$PMF_LANG['ad_categ_delete'] = '削除';
$PMF_LANG['ad_categ_updatecateg'] = 'カテゴリーの変更';
$PMF_LANG['ad_categ_nodata'] = 'データベースにデータが見つかりません。';
$PMF_LANG['msgCategoryRemark'] = 'カテゴリーを削除すると、該当カテゴリーのレコード(FAQ)も削除されます。カテゴリーを削除する前に、レコード(FAQ)を他のカテゴリーに指定してください。';
$PMF_LANG['ad_categ_edit_1'] = '変更';
$PMF_LANG['ad_categ_edit_2'] = 'カテゴリー';
$PMF_LANG['ad_categ_added'] = 'カテゴリーを追加しました。';
$PMF_LANG['ad_categ_updated'] = 'カテゴリーを変更しました。';
$PMF_LANG['ad_categ_del_yes'] = 'はい、削除します!';
$PMF_LANG['ad_categ_del_no'] = 'いいえ!';
$PMF_LANG['ad_categ_deletesure'] = '本当にこのカテゴリーを削除しますか?';
$PMF_LANG['ad_categ_deleted'] = 'カテゴリーを削除しました。';
$PMF_LANG['ad_cookie_cookiesuc'] = 'Cookie の設定に<strong>成功</strong>しました。';
$PMF_LANG['ad_cookie_already'] = 'Cookie は既に設定されています。現在次のオプションがあります:';
$PMF_LANG['ad_cookie_again'] = 'もう一度 Cookie を設定する';
$PMF_LANG['ad_cookie_delete'] = 'Cookie を削除する';
$PMF_LANG['ad_cookie_no'] = '保存されている Cookie がありません。Cookie にてログインスクリプトを保存します。再びあなたのログイン詳細を覚えることはありません。次のようなオプションがあります:';
$PMF_LANG['ad_cookie_set'] = 'Cookie の設定';
$PMF_LANG['ad_cookie_deleted'] = 'Cookie の削除に成功しました。';
$PMF_LANG['ad_adminlog'] = '管理ログ';
$PMF_LANG['ad_passwd_cop'] = 'パスワード変更';
$PMF_LANG['ad_passwd_old'] = '現在のパスワード:';
$PMF_LANG['ad_passwd_new'] = '新しいパスワード:';
$PMF_LANG['ad_passwd_con'] = '新しいパスワードの再確認:';
$PMF_LANG['ad_passwd_change'] = 'パスワード変更';
$PMF_LANG['ad_passwd_suc'] = 'パスワードの変更に成功しました。';
$PMF_LANG['ad_passwd_remark'] = '<strong>注意:</strong><br>もう一度Cookieを設定してください。';
$PMF_LANG['ad_passwd_fail'] = '「現在のパスワード」を <strong>正しく</strong> 入力し、「新しいパスワード」と「新しいパスワードの再確認」は必ず <strong>一致</strong>するように入力してください。';
$PMF_LANG['ad_adus_adduser'] = 'ユーザーの追加';
$PMF_LANG['ad_adus_name'] = 'ID:';
$PMF_LANG['ad_adus_password'] = 'パスワード:';
$PMF_LANG['ad_adus_add'] = 'ユーザー追加';
$PMF_LANG['ad_adus_suc'] = 'ユーザーの追加に<strong>成功</strong>しました。';
$PMF_LANG['ad_adus_edit'] = 'プロフィールの変更';
$PMF_LANG['ad_adus_dberr'] = '<strong>データベースエラーです!</strong>';
$PMF_LANG['ad_adus_exerr'] = 'ユーザーは既に<strong>存在します</strong>。';
$PMF_LANG['ad_sess_id'] = 'ID';
$PMF_LANG['ad_sess_sid'] = 'セッション ID';
$PMF_LANG['ad_sess_ip'] = 'IP アドレス';
$PMF_LANG['ad_sess_time'] = '時間';
$PMF_LANG['ad_sess_pageviews'] = 'ページビュー';
$PMF_LANG['ad_sess_search'] = '検索';
$PMF_LANG['ad_sess_sfs'] = 'セッションから検索';
$PMF_LANG['ad_sess_s_ip'] = 'IP アドレス:';
$PMF_LANG['ad_sess_s_minct'] = 'min. actions:';
$PMF_LANG['ad_sess_s_date'] = '日付';
$PMF_LANG['ad_sess_s_after'] = '以後';
$PMF_LANG['ad_sess_s_before'] = '以前';
$PMF_LANG['ad_sess_s_search'] = '検索';
$PMF_LANG['ad_sess_session'] = 'セッション';
$PMF_LANG['ad_sess_r'] = '検索結果 - ';
$PMF_LANG['ad_sess_referer'] = 'リファラー:';
$PMF_LANG['ad_sess_browser'] = 'ブラウザー:';
$PMF_LANG['ad_sess_ai_rubrik'] = 'カテゴリー:';
$PMF_LANG['ad_sess_ai_artikel'] = 'レコード:';
$PMF_LANG['ad_sess_ai_sb'] = '検索文字列:';
$PMF_LANG['ad_sess_ai_sid'] = 'セッション ID:';
$PMF_LANG['ad_sess_back'] = '戻る';
$PMF_LANG['ad_rs'] = '評価統計';
$PMF_LANG['ad_rs_rating_1'] = '';
$PMF_LANG['ad_rs_rating_2'] = 'ランクのユーザーを見る:';
$PMF_LANG['ad_rs_red'] = '赤';
$PMF_LANG['ad_rs_green'] = '緑';
$PMF_LANG['ad_rs_altt'] = '平均で 2 以下';
$PMF_LANG['ad_rs_ahtf'] = '平均で 2 以上';
$PMF_LANG['ad_rs_no'] = '有効な評価は有効ありません。';
$PMF_LANG['ad_auth_insert'] = 'ID とパスワードを入力してください。';
$PMF_LANG['ad_auth_user'] = 'ID:';
$PMF_LANG['ad_auth_passwd'] = 'パスワード:';
$PMF_LANG['ad_auth_ok'] = 'OK';
$PMF_LANG['ad_auth_reset'] = 'リセット';
$PMF_LANG['ad_auth_fail'] = 'IDかパスワードが正しくありません。';
$PMF_LANG['ad_auth_sess'] = 'セッション ID が終了しました。';
$PMF_LANG['ad_config_edit'] = '環境設定';
$PMF_LANG['ad_config_save'] = '保存';
$PMF_LANG['ad_config_reset'] = 'リセット';
$PMF_LANG['ad_config_saved'] = '環境設定の保存に成功しました。';
$PMF_LANG['ad_menu_editconfig'] = '環境設定';
$PMF_LANG['ad_att_none'] = 'ファイルの添付ができません。';
$PMF_LANG['ad_att_att'] = 'ファイル:';
$PMF_LANG['ad_att_add'] = '添付ファイル';
$PMF_LANG['ad_entryins_suc'] = '保存に成功しました。';
$PMF_LANG['ad_entryins_fail'] = 'エラーが発生しました。';
$PMF_LANG['ad_att_del'] = '削除';
$PMF_LANG['ad_att_nope'] = '添付ファイルは内容の変更中にのみ追加できます。';
$PMF_LANG['ad_att_delsuc'] = '添付ファイルの削除に成功しました。';
$PMF_LANG['ad_att_delfail'] = '添付ファイルの削除中にエラーが発生しました。';
$PMF_LANG['ad_entry_add'] = 'FAQ の追加';
$PMF_LANG['ad_csv_make'] = 'データベースの内容をそのままバックアップします。少なくとも月 1 回のバックアップをするようにしてください。バックアップファイルは MySQL のファイル形式で、phpMyAdmin または、MySQL クライアントからも読むことが可能です。 ';
$PMF_LANG['ad_csv_link'] = 'バックアップダウンロード';
$PMF_LANG['ad_csv_head'] = 'バックアップ作成';
$PMF_LANG['ad_att_addto'] = 'ファイルを添付';
$PMF_LANG['ad_att_addto_2'] = '';
$PMF_LANG['ad_att_butt'] = 'OK';
$PMF_LANG['ad_att_suc'] = 'ファイルの添付に成功しました。';
$PMF_LANG['ad_att_fail'] = 'ファイルの添付中にエラーが発生しました。';
$PMF_LANG['ad_att_close'] = 'このウィンドウを閉じる';
$PMF_LANG['ad_csv_restore'] = 'phpMyFAQ でバックアップしたデータをリストアします。リストアする場合、既存のデータは復元することはできません。 ';
$PMF_LANG['ad_csv_file'] = 'ファイル';
$PMF_LANG['ad_csv_ok'] = 'OK';
$PMF_LANG['ad_csv_linklog'] = 'ログバックアップ';
$PMF_LANG['ad_csv_linkdat'] = 'データバックアップ';
$PMF_LANG['ad_csv_head2'] = '復元する';
$PMF_LANG['ad_csv_no'] = 'phpMyFAQのバックアップファイルのフォーマットではありません。';
$PMF_LANG['ad_csv_prepare'] = 'データーベース照会の準備中...';
$PMF_LANG['ad_csv_process'] = '照会中...';
$PMF_LANG['ad_csv_of'] = '';
$PMF_LANG['ad_csv_suc'] = ' が成功しました。';
$PMF_LANG['ad_csv_backup'] = 'バックアップ';
$PMF_LANG['ad_csv_rest'] = 'バックアップ復元';
$PMF_LANG['ad_menu_backup'] = 'バックアップ';
$PMF_LANG['ad_logout'] = 'セッションが終了されました。';
$PMF_LANG['ad_news_edit'] = 'お知らせの変更';
$PMF_LANG['ad_cookie'] = 'Cookie';
$PMF_LANG['ad_sess_head'] = 'セッション閲覧';
$PMF_LANG['msgAddCategory'] = 'メインカテゴリーの追加';
$PMF_LANG['ad_kateg_rename'] = '名称変更';
$PMF_LANG['ad_adminlog_date'] = '日付';
$PMF_LANG['ad_adminlog_user'] = 'ユーザー';
$PMF_LANG['ad_adminlog_ip'] = 'IP アドレス';
$PMF_LANG['ad_stat_sess'] = 'セッション';
$PMF_LANG['ad_stat_days'] = '日数';
$PMF_LANG['ad_stat_vis'] = 'セッション (訪問数)';
$PMF_LANG['ad_stat_vpd'] = '1日中の訪問数';
$PMF_LANG['ad_stat_fien'] = '最初のログ';
$PMF_LANG['ad_stat_laen'] = '最後のログ';
$PMF_LANG['ad_stat_browse'] = 'セッション情報表示';
$PMF_LANG['ad_stat_ok'] = 'OK';
$PMF_LANG['ad_ques_take'] = '質問と編集を受け付ける';
$PMF_LANG['no_cats'] = 'カテゴリーが見つかりません。';
$PMF_LANG['ad_log_lger'] = 'IDまたはパスワードが正しくありません。';
$PMF_LANG['ad_log_sess'] = 'セッションは終了しました。';
$PMF_LANG['ad_log_edit'] = '-次のユーザーの「ユーザー編集」フォーム: ';
$PMF_LANG['ad_log_crea'] = '「新規記事」フォーム.';
$PMF_LANG['ad_log_crsa'] = '新規エントリーを作成しました。';
$PMF_LANG['ad_log_ussa'] = '次のユーザーのデータを更新しました: ';
$PMF_LANG['ad_log_usde'] = '次のユーザーを削除しました: ';
$PMF_LANG['ad_log_beed'] = '次のユーザーの変更フォーム: ';
$PMF_LANG['ad_log_bede'] = '次のエントリーを削除: ';
$PMF_LANG['msgVisits'] = '訪問数';
$PMF_LANG['ad_start_articles'] = '記事数';
$PMF_LANG['ad_start_comments'] = 'コメント数';
$PMF_LANG['ad_categ_paste'] = '貼り付け';
$PMF_LANG['ad_categ_cut'] = '切り取り';
$PMF_LANG['msgCopy'] = 'コピー';
$PMF_LANG['ad_categ_process'] = 'カテゴリー処理中...';
$PMF_LANG['err_NotAuth'] = '<strong>使用権限がありません。</strong>';
$PMF_LANG['msgPreviusPage'] = '前のページ';
$PMF_LANG['msgNextPage'] = '次のページ';
$PMF_LANG['msgPageDoublePoint'] = 'ページ: ';
$PMF_LANG['msgMainCategory'] = 'メインカテゴリー';
$PMF_LANG['ad_passwdsuc'] = 'パスワードを変更しました。';
$PMF_LANG['msgPDF'] = 'PDF ファイルで表示する';
$PMF_LANG['ad_xml_head'] = 'XML にバックアップする';
$PMF_LANG['ad_xml_hint'] = 'FAQ の全レコードを 1 つの XML ファイルに保存する';
$PMF_LANG['ad_xml_gen'] = 'XML ファイルを生成する';
$PMF_LANG['ad_entry_locale'] = '言語';
$PMF_LANG['msgLanguageSubmit'] = '言語を選択する';
$PMF_LANG['ad_entry_preview'] = 'プレビュー';
$PMF_LANG['ad_attach_1'] = '環境設定から添付ファイルを保存するディレクトリを先に設定してください。';
$PMF_LANG['ad_attach_2'] = '環境設定から添付ファイルのリンクを先に設定してください。';
$PMF_LANG['ad_attach_3'] = 'attachment.php ファイルを権限なしではオープンできません。';
$PMF_LANG['ad_attach_4'] = '添付ファイルのサイズは %s バイト以下にしてください。';
$PMF_LANG['ad_menu_export'] = 'FAQ エクスポート';
$PMF_LANG['ad_export_file'] = 'エラー: ファイルの書き込みができません。';
$PMF_LANG['ad_export_pdf'] = '全レコードの PDF エクスポート';
$PMF_LANG['permission::add_user'] = 'ユーザーの追加';
$PMF_LANG['permission::edit_user'] = 'ユーザーの編集';
$PMF_LANG['permission::delete_user'] = 'ユーザーの削除';
$PMF_LANG['permission::add_faq'] = 'レコードの追加';
$PMF_LANG['permission::edit_faq'] = 'レコードの編集';
$PMF_LANG['permission::delete_faq'] = 'レコードの削除';
$PMF_LANG['permission::viewlog'] = 'ログの閲覧';
$PMF_LANG['permission::adminlog'] = '管理ログの閲覧';
$PMF_LANG['permission::delcomment'] = 'コメントの削除';
$PMF_LANG['permission::addnews'] = 'ニュースの追加';
$PMF_LANG['permission::editnews'] = 'ニュースの編集';
$PMF_LANG['permission::delnews'] = 'ニュースの削除';
$PMF_LANG['permission::addcateg'] = 'カテゴリーの追加';
$PMF_LANG['permission::editcateg'] = 'カテゴリーの編集';
$PMF_LANG['permission::delcateg'] = 'カテゴリーの削除';
$PMF_LANG['permission::passwd'] = 'パスワードの編集';
$PMF_LANG['permission::editconfig'] = '構成の編集';
$PMF_LANG['permission::addatt'] = '添付の追加';
$PMF_LANG['permission::delatt'] = '添付の削除';
$PMF_LANG['permission::backup'] = 'バックアップの作成';
$PMF_LANG['permission::restore'] = 'バックアップの復元';
$PMF_LANG['permission::delquestion'] = '開いた質問の削除';
$PMF_LANG['permission::changebtrevs'] = '改訂の編集';
$PMF_LANG['msgAttachedFiles'] = '添付ファイル:';
$PMF_LANG['ad_user_action'] = '操作';
$PMF_LANG['msgEmail'] = 'メールアドレス:';
$PMF_LANG['ad_entry_allowComments'] = 'コメントを許可する';
$PMF_LANG['msgWriteNoComment'] = 'このエントリーにコメントできません。';
$PMF_LANG['msgRealname'] = '本名:';
$PMF_LANG['ad_export_generate_pdf'] = 'PDF ファイル生成';
$PMF_LANG['ad_export_full_faq'] = 'FAQ を PDF ファイルにする: ';
$PMF_LANG['err_bannedIP'] = 'あなたのIPアドレスからのアクセスは遮断されています。';
$PMF_LANG['err_SaveQuestion'] = '<strong>名前</strong>、<strong>メールアドレス</strong>、<strong>質問</strong>と要求された場合は <strong><a href="https://ja.wikipedia.org/wiki/Captcha" title="Wikipedia で Captcha について読む" target="_blank">Captcha</a> コード</strong> は必須項目です。<br><br><a href="javascript:history.back();">戻る</a><br><br>';
$PMF_LANG['ad_entry_fontcolor'] = 'フォント色: ';
$PMF_LANG['ad_entry_fontsize'] = 'フォントサイズ: ';
$LANG_CONF['main.language'] = array("select", "言語");
$LANG_CONF['main.languageDetection'] = array("checkbox", "言語の自動認識を有効にする");
$LANG_CONF['main.titleFAQ'] = array("input", "FAQ の題名");
$LANG_CONF['main.currentVersion'] = array("print", "FAQ バージョン");
$LANG_CONF['main.metaDescription'] = array('input', 'ページの説明');
$LANG_CONF['main.metaPublisher'] = array('input', '管理者名');
$LANG_CONF['main.administrationMail'] = array('input', '管理者の電子メールアドレス');
$LANG_CONF['main.contactInformation'] = array('area', '問い合わせ情報');
$LANG_CONF['main.send2friendText'] = array('area', '友達に送信ページのテキスト');
$LANG_CONF['records.maxAttachmentSize'] = array('input', '添付ファイルの最大サイズ (最大 %s バイト)');
$LANG_CONF['records.disableAttachments'] = array('checkbox', 'エントリーの下に添付のリンクを表示する');
$LANG_CONF['main.enableUserTracking'] = array('checkbox', '追跡機能を使用する');
$LANG_CONF['main.enableAdminLog'] = array('checkbox', '管理ログを使用する');
$LANG_CONF['security.ipCheck'] = array('checkbox', 'admin.php で UIN のチェック時に IP アドレスを確認するか');
$LANG_CONF['main.numberOfRecordsPerPage'] = array("input", "ページ毎に表示するトピック数");
$LANG_CONF['main.numberOfShownNewsEntries'] = array("input", "お知らせの表示数");
$LANG_CONF['security.bannedIPs'] = array('area', '拒否する IP アドレス');
$LANG_CONF['ldap.ldapSupport'] = array('checkbox', 'LDAP のサポートを有効にしますか? (初期値: 無効)');
$LANG_CONF['main.referenceURL'] = array('input', 'リンク確認の基準 URL (例: https://www.example.org/faq/)');
$LANG_CONF['records.enableVisibilityQuestions'] = array('checkbox', '新しい質問の表示を無効にする');
$LANG_CONF['security.permLevel'] = array('select', 'パーミッションレベル');
$PMF_LANG['ad_categ_new_main_cat'] = 'ROOT の下位カテゴリーへ';
$PMF_LANG['ad_categ_paste_error'] = 'このカテゴリーは移動できません。';
$PMF_LANG['ad_categ_move'] = 'カテゴリー移動';
$PMF_LANG['ad_categ_lang'] = '言語';
$PMF_LANG['ad_categ_desc'] = '説明';
$PMF_LANG['ad_categ_change'] = '選択したカテゴリーと入れ替え';
$PMF_LANG['lostPassword'] = 'パスワードを忘れましたか? その時はここをクリックしてください。';
$PMF_LANG['lostpwd_err_1'] = 'エラー: ユーザー名と電子メールアドレスが見つかりません。';
$PMF_LANG['lostpwd_err_2'] = 'エラー: 不正な入力です!';
$PMF_LANG['lostpwd_text_1'] = 'アカウント情報の要求頂きありがとうございます。';
$PMF_LANG['lostpwd_text_2'] = 'FAQ の管理セクションの中で新しい個人のパスワードを設定してください。';
$PMF_LANG['lostpwd_mail_okay'] = '電子メールを送信しました。';
$PMF_LANG['msgButtonFetchLatestVersion'] = '最新の phpMyFAQ バージョンをウェブで確認する';
$PMF_LANG['ad_xmlrpc_latest'] = '最新バージョンを次のサイトから利用することができます:';
$PMF_LANG['ad_categ_select'] = 'カテゴリー言語を選択する';
$PMF_LANG['msgSitemap'] = 'サイトマップ';
$PMF_LANG['err_inactiveArticle'] = 'このエントリーは改訂中で、表示できません。';
$PMF_LANG['msgArticleCategories'] = 'このエントリーのカテゴリー';
$PMF_LANG['ad_entry_solution_id'] = '一意的なソリューション ID';
$PMF_LANG['ad_entry_faq_record'] = 'FAQ レコード';
$PMF_LANG['ad_entry_new_revision'] = '新しい改訂を作成しますか?';
$PMF_LANG['ad_entry_record_administration'] = 'レコード管理';
$PMF_LANG['ad_entry_revision'] = '改訂';
$PMF_LANG['ad_changerev'] = '改訂の選択';
$PMF_LANG['msgCaptcha'] = '画像の中で読める文字を入力してください';
$PMF_LANG['msgSelectCategories'] = '検索 ...';
$PMF_LANG['msgAllCategories'] = '... すべてのカテゴリー';
$PMF_LANG['ad_you_should_update'] = 'インストールされている phpMyFAQ は旧式です。最新版へのバージョンアップをお勧めします。';
$PMF_LANG['msgAdvancedSearch'] = '高度な検索';
$PMF_LANG['spamControlCenter'] = 'スパム制御センター';
$LANG_CONF['spam.enableSafeEmail'] = array("checkbox", "安全にユーザーの電子メールを表示する (初期値: 有効)");
$LANG_CONF['spam.checkBannedWords'] = array("checkbox", "公開フォームの内容に対する禁止単語を確認する (初期値: 有効)");
$LANG_CONF['spam.enableCaptchaCode'] = array("checkbox", "公開フォームの送信を許可するために captcha を使用する (初期値: 有効)");
$PMF_LANG['ad_session_expiring'] = 'セッションの期限切れは %d 分です: 作業しますか?';
$PMF_LANG['ad_stat_management'] = 'セッション管理';
$PMF_LANG['ad_stat_choose'] = '月の選択';
$PMF_LANG['ad_stat_delete'] = '選択されたセッションを直接削除します。';
$PMF_LANG['ad_menu_glossary'] = '用語集';
$PMF_LANG['ad_glossary_add'] = '用語集のエントリーの追加';
$PMF_LANG['ad_glossary_edit'] = '用語集のエントリーの編集';
$PMF_LANG['ad_glossary_item'] = '項目';
$PMF_LANG['ad_glossary_definition'] = '定義';
$PMF_LANG['ad_glossary_save'] = 'エントリーの保存';
$PMF_LANG['ad_glossary_save_success'] = '用語集のエントリーの保存に成功しました!';
$PMF_LANG['ad_glossary_save_error'] = '用語集のエントリーはエラーが発生したために保存できませんでした。';
$PMF_LANG['ad_glossary_update_success'] = '用語集のエントリーの更新に成功しました!';
$PMF_LANG['ad_glossary_update_error'] = '用語集のエントリーはエラーが発生したために更新できませんでした。';
$PMF_LANG['ad_glossary_delete'] = 'エントリーの削除';
$PMF_LANG['ad_glossary_delete_success'] = '用語集のエントリーの削除に成功しました!';
$PMF_LANG['ad_glossary_delete_error'] = '用語集のエントリーはエラーが発生したために削除できませんでした。';
$PMF_LANG['msgNewQuestionVisible'] = '質問は公開の前にはじめにレビューします。';
$PMF_LANG['msgQuestionsWaiting'] = '管理者による公開を待っています: ';
$PMF_LANG['ad_entry_visibility'] = '公開しますか?';
$PMF_LANG['ad_user_error_password'] = 'パスワードを入力してください。 ';
$PMF_LANG['ad_user_error_passwordsDontMatch'] = 'パスワードが一致しません。';
$PMF_LANG['ad_user_error_loginInvalid'] = '指定されたユーザーIDは無効です。';
$PMF_LANG['ad_user_error_noEmail'] = '有効なメールアドレスを入力してください。';
$PMF_LANG['ad_user_error_noRealName'] = '本名を入力してください。';
$PMF_LANG['ad_user_error_delete'] = 'ユーザーアカウントを削除できませんでした。';
$PMF_LANG['ad_user_error_noId'] = 'ID を指定していません。';
$PMF_LANG['ad_user_error_protectedAccount'] = 'このユーザーは保護されています。';
$PMF_LANG['ad_user_deleteUser'] = 'ユーザーの削除';
$PMF_LANG['ad_user_status'] = '状態:';
$PMF_LANG['ad_user_lastModified'] = '最終変更日時:';
$PMF_LANG['ad_gen_cancel'] = '取り消す';
$PMF_LANG['permission::addglossary'] = '用語の追加';
$PMF_LANG['permission::editglossary'] = '用語の編集';
$PMF_LANG['permission::delglossary'] = '用語の削除';
$PMF_LANG['ad_menu_group_administration'] = 'グループの管理';
$PMF_LANG['ad_user_loggedin'] = '次の名前でログイン中: ';
$PMF_LANG['ad_group_details'] = 'グループの詳細';
$PMF_LANG['ad_group_add'] = 'グループの追加';
$PMF_LANG['ad_group_add_link'] = 'グループを追加する';
$PMF_LANG['ad_group_name'] = '名称:';
$PMF_LANG['ad_group_description'] = '説明:';
$PMF_LANG['ad_group_autoJoin'] = '自動参加:';
$PMF_LANG['ad_group_suc'] = 'グループの追加に<strong>成功</strong>しました。';
$PMF_LANG['ad_group_error_noName'] = 'グループの名称を指定してください。';
$PMF_LANG['ad_group_error_delete'] = 'グループを削除できません。';
$PMF_LANG['ad_group_deleted'] = 'グループを削除しました。';
$PMF_LANG['ad_group_deleteGroup'] = 'グループの削除';
$PMF_LANG['ad_group_deleteQuestion'] = 'このグループを本当に削除しますか？';
$PMF_LANG['ad_user_uncheckall'] = '全て解除';
$PMF_LANG['ad_group_membership'] = 'グループのメンバー設定';
$PMF_LANG['ad_group_members'] = 'グループのメンバー一覧';
$PMF_LANG['ad_group_addMember'] = '追加 >>';
$PMF_LANG['ad_group_removeMember'] = '<< 削除';
$PMF_LANG['ad_export_which_cat'] = 'エクスポートする FAQ データの制限 (オプション)';
$PMF_LANG['ad_export_cat_downwards'] = 'ダウンロードしますか?';
$PMF_LANG['ad_export_type'] = 'エクスポートの形式';
$PMF_LANG['ad_export_type_choose'] = 'サポートされる形式をひとつ選びます:';
$PMF_LANG['ad_export_download_view'] = 'インライン表示かダウンロードしますか?';
$PMF_LANG['ad_export_download'] = 'ダウンロード';
$PMF_LANG['ad_export_view'] = 'インライン表示';
$PMF_LANG['ad_export_gen_xhtml'] = 'XHTML ファイルを作成する';
$PMF_LANG['ad_export_gen_docbook'] = 'Docbook ファイルを作成する';
$PMF_LANG['ad_news_data'] = 'お知らせデータ';
$PMF_LANG['ad_news_author_name'] = '制作者名:';
$PMF_LANG['ad_news_author_email'] = 'メールアドレス:';
$PMF_LANG['ad_news_set_active'] = '有効化';
$PMF_LANG['ad_news_allowComments'] = 'コメントの許可:';
$PMF_LANG['ad_news_expiration_window'] = 'お知らせの表示期限指定 (オプション)';
$PMF_LANG['ad_news_from'] = '開始日:';
$PMF_LANG['ad_news_to'] = '終了日:';
$PMF_LANG['ad_news_insertfail'] = 'データベースへのお知らせ項目追加中にエラーです。';
$PMF_LANG['ad_news_updatefail'] = 'データベースへのお知らせ項目更新中にエラーです。';
$PMF_LANG['newsShowCurrent'] = '現在のお知らせを表示します。';
$PMF_LANG['newsShowArchive'] = '過去のお知らせを表示します。';
$PMF_LANG['newsArchive'] = ' 過去のお知らせ';
$PMF_LANG['newsWriteComment'] = 'このエントリーのコメント';
$PMF_LANG['newsCommentDate'] = '追加日時: ';
$PMF_LANG['ad_record_expiration_window'] = 'レコード表示期限指定 (オプション)';
$PMF_LANG['adminHeaderDashboard'] = 'ダッシュボード';
$PMF_LANG['admin_mainmenu_users'] = 'ユーザー';
$PMF_LANG['admin_mainmenu_content'] = 'コンテンツ';
$PMF_LANG['admin_mainmenu_statistics'] = '統計';
$PMF_LANG['admin_mainmenu_backup'] = 'バックアップ';
$PMF_LANG['admin_mainmenu_configuration'] = '設定';
$PMF_LANG['admin_mainmenu_logout'] = 'ログアウト';
$PMF_LANG['ad_categ_owner'] = 'カテゴリー所有者';
$PMF_LANG['adminSection'] = '管理';
$PMF_LANG['err_expiredArticle'] = 'このエントリーは期限切れで表示できません';
$PMF_LANG['err_expiredNews'] = 'このお知らせは期限切れで表示できません';
$PMF_LANG['err_inactiveNews'] = 'このお知らせは改訂中で表示できません';
$PMF_LANG['msgSearchOnAllLanguages'] = 'すべての言語での検索:';
$PMF_LANG['ad_entry_tags'] = 'タグ';
$PMF_LANG['msg_tags'] = 'タグ';
$PMF_LANG['msg_related_articles'] = '関連エントリー';
$LANG_CONF['records.numberOfRelatedArticles'] = array("input", "関連エントリーの数");
$PMF_LANG['ad_categ_trans_1'] = '翻訳';
$PMF_LANG['ad_categ_trans_2'] = 'カテゴリー';
$PMF_LANG['ad_categ_translatecateg'] = 'カテゴリーの翻訳';
$PMF_LANG['ad_categ_translate'] = '翻訳';
$PMF_LANG['ad_categ_transalready'] = '翻訳済みカテゴリー: ';
$PMF_LANG['ad_categ_deletealllang'] = 'すべての言語を削除しますか?';
$PMF_LANG['ad_categ_deletethislang'] = 'この言語のみ削除しますか?';
$PMF_LANG['ad_categ_translated'] = 'カテゴリーを翻訳しました。';
$PMF_LANG['msgCategoryMatrix'] = '概要';
$PMF_LANG['ad_menu_categ_structure'] = '言語を含むカテゴリー概要';
$PMF_LANG['ad_entry_userpermission'] = 'ユーザー権限:';
$PMF_LANG['ad_entry_grouppermission'] = 'グループ権限:';
$PMF_LANG['ad_entry_all_users'] = 'すべてのユーザーのアクセス';
$PMF_LANG['ad_entry_restricted_users'] = '次のアクセスを制限:';
$PMF_LANG['ad_entry_all_groups'] = 'すべてのグループのアクセス';
$PMF_LANG['ad_entry_restricted_groups'] = '次のアクセスを制限:';
$PMF_LANG['ad_session_expiration'] = 'セッションの期限切れ時間';
$PMF_LANG['ad_user_active'] = '有効';
$PMF_LANG['ad_user_blocked'] = 'ブロック';
$PMF_LANG['ad_user_protected'] = '保護';
$PMF_LANG['ad_entry_intlink'] = 'リンクとして挿入する FAQ レコードを選択します...';
$PMF_LANG['ad_categ_paste2'] = '次のカテゴリー配下に貼り付け';
$PMF_LANG['msgCategoryRemark_overview'] = 'カテゴリーがすべて実際の言語に対して定義された場合、カテゴリーの順序は正しく表示されるでしょう。 (はじめのカラム).';
$PMF_LANG['msgUsersOnline'] = '%d 人のゲストと %d 人の登録者です';
$PMF_LANG['ad_adminlog_del_older_30d'] = '30日より古いログをすぐに削除する';
$PMF_LANG['ad_adminlog_delete_success'] = 'より古いログの削除に成功しました。';
$PMF_LANG['ad_adminlog_delete_failure'] = '削除したログはありません: 要求の実行時にエラーが発生しました。';
$PMF_LANG['ad_quicklinks'] = 'クイックリンク';
$PMF_LANG['ad_quick_category'] = '新規カテゴリーの追加';
$PMF_LANG['ad_quick_record'] = 'FAQ の追加';
$PMF_LANG['ad_quick_user'] = '新規ユーザーの追加';
$PMF_LANG['ad_quick_group'] = '新規グループの追加';
$PMF_LANG['msgNewTranslationHeader'] = '提案する翻訳';
$PMF_LANG['msgNewTranslationAddon'] = '提案頂いた内容は、管理者による承認後に反映されます。提案に必要な項目は、<strong>名前・メールアドレス・質問・回答</strong>です。キーワードは半角スペースで区切ってください。';
$PMF_LANG['msgNewTransSourcePane'] = '元ペイン';
$PMF_LANG['msgNewTranslationPane'] = '翻訳ペイン';
$PMF_LANG['msgNewTranslationName'] = '名前:';
$PMF_LANG['msgNewTranslationMail'] = '電子メールアドレス:';
$PMF_LANG['msgNewTranslationKeywords'] = 'キーワード:';
$PMF_LANG['msgNewTranslationSubmit'] = '提案の送信';
$PMF_LANG['msgTranslate'] = '次の言語への翻訳提案';
$PMF_LANG['msgTranslateSubmit'] = '翻訳の開始...';
$PMF_LANG['msgNewTranslationThanks'] = '翻訳の提案ありがとうございます!';
$PMF_LANG['permission::addgroup'] = 'グループアカウントの追加';
$PMF_LANG['permission::editgroup'] = 'グループアカウントの編集';
$PMF_LANG['permission::delgroup'] = 'グループアカウントの削除';
$PMF_LANG['ad_news_link_parent'] = '親ウィンドウでリンクを開く';
$PMF_LANG['ad_menu_comments'] = 'コメント';
$PMF_LANG['adminHeaderComments'] = 'コメント管理';
$PMF_LANG['msgAdminCommentFaqs'] = 'FAQ レコードのコメント:';
$PMF_LANG['msgAdminCommentNews'] = '新規レコードのコメント:';
$PMF_LANG['ad_groups'] = 'グループ';
$LANG_CONF['records.orderby'] = array('select', 'レコードの並び替え (優先度に従う)');
$LANG_CONF['records.sortby'] = array('select', 'レコードの並び替え (降順もしくは昇順)');
$PMF_LANG['ad_conf_order_id'] = 'ID (デフォルト)';
$PMF_LANG['ad_conf_order_thema'] = '題名';
$PMF_LANG['ad_conf_order_visits'] = '訪問者数';
$PMF_LANG['ad_conf_order_updated'] = '日付';
$PMF_LANG['ad_conf_order_author'] = '制作者';
$PMF_LANG['ad_conf_desc'] = '降順';
$PMF_LANG['ad_conf_asc'] = '昇順';
$PMF_LANG['mainControlCenter'] = 'メイン設定';
$PMF_LANG['recordsControlCenter'] = 'FAQ レコード設定';
$LANG_CONF['records.defaultActivation'] = array("checkbox", "新規レコードを有効にする (初期値: 無効)");
$LANG_CONF['records.defaultAllowComments'] = array("checkbox", "新規レコードへのコメントを許可する (初期値: 許可しない)");
$PMF_LANG['msgAllCatArticles'] = 'このカテゴリー内のレコード';
$PMF_LANG['msgTagSearch'] = 'タグ付けされたエントリー';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ 情報';
$PMF_LANG['msgOnlineVersionCheck'] = 'オンラインのバージョン確認';
$PMF_LANG['ad_system_info'] = 'システム情報';
$PMF_LANG['msgRegisterUser'] = '登録しますか?';
$PMF_LANG['msgUsername'] = 'ログイン名:';
$PMF_LANG['errorRegistration'] = 'この項目は必須です!';
$PMF_LANG['submitRegister'] = '登録';
$PMF_LANG['msgUserData'] = '登録にはユーザー情報が必要です';
$PMF_LANG['captchaError'] = '次のCaptchaコードを入力してください!';
$PMF_LANG['msgRegError'] = '次のエラーが発生しました。正しくしてください:';
$PMF_LANG['successMessage'] = '登録に成功しました。ログインデータを含む確認メールが送られます!';
$PMF_LANG['msgRegThankYou'] = '登録ありがとうございます';
$PMF_LANG['emailRegSubject'] = '[%sitename%] 登録: 新規ユーザー';
$PMF_LANG['msgMostPopularSearches'] = 'もっとも人気の検索:';
$LANG_CONF['main.enableWysiwygEditor'] = array("checkbox", "同梱の WYSIWYG エディターを有効にする (初期値: 有効)");
$PMF_LANG['ad_menu_searchstats'] = '統計の検索';
$PMF_LANG['ad_searchstats_search_term'] = 'キーワード';
$PMF_LANG['ad_searchstats_search_term_count'] = '回数';
$PMF_LANG['ad_searchstats_search_term_lang'] = '言語';
$PMF_LANG['ad_searchstats_search_term_percentage'] = '達成率';
$PMF_LANG['ad_record_sticky'] = 'スティッキー';
$PMF_LANG['ad_entry_sticky'] = 'スティッキー';
$PMF_LANG['stickyRecordsHeader'] = 'スティッキー FAQ';
$PMF_LANG['ad_menu_stopwordsconfig'] = 'ストップワード';
$PMF_LANG['ad_config_stopword_input'] = '新規ストップワードの追加';
$PMF_LANG['msgSendMailDespiteEverything'] = 'No, there is still no adequate answer (will send the mail)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'Is the wanted answer listed in the results above?';
$PMF_LANG['msgChooseLanguageToTranslate'] = '翻訳する言語を選んでください';
$PMF_LANG['msgLangDirIsntWritable'] = '翻訳ディレクトリーを書き込めません';
$PMF_LANG['ad_menu_translations'] = '翻訳インターフェース';
$PMF_LANG['ad_start_notactive'] = '有効化待ち';
$PMF_LANG['msgTransToolAddNewTranslation'] = '新規翻訳の追加';
$PMF_LANG['msgTransToolLanguage'] = '言語';
$PMF_LANG['msgTransToolActions'] = '操作';
$PMF_LANG['msgTransToolWritable'] = '書き込み可能';
$PMF_LANG['msgEdit'] = '編集';
$PMF_LANG['msgDelete'] = '削除';
$PMF_LANG['msgYes'] = 'はい';
$PMF_LANG['msgNo'] = 'いいえ';
$PMF_LANG['msgVariable'] = '表示';
$PMF_LANG['msgCancel'] = '取り消し';
$PMF_LANG['msgSave'] = '保存';
$PMF_LANG['msgSaving3Dots'] = '保存しています ...';
$PMF_LANG['msgRemoving3Dots'] = '削除しています ...';
$PMF_LANG['msgLanguage'] = '言語';
$PMF_LANG['msgTransToolLanguageCharset'] = '言語の文字セット';
$PMF_LANG['msgTransToolLanguageDir'] = '言語の方向';
$PMF_LANG['msgTransToolLanguageDesc'] = '言語の説明';
$PMF_LANG['msgTransToolAddAuthor'] = '製作者の追加';
$PMF_LANG['msgTransToolCreateTranslation'] = '翻訳の作成';
$PMF_LANG['msgTransToolTransCreated'] = '新規翻訳の作成に成功しました';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = '新規翻訳の作成ができません';
$PMF_LANG['msgAdding3Dots'] = '追加しています ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'phpMyFAQ チームに送る';
$PMF_LANG['msgSending3Dots'] = '送信しています ...';
$PMF_LANG['msgTransToolFileSent'] = '言語ファイルを phpMyFAQ チームに送ることに成功しました。共有をありがとうございます。';
$PMF_LANG['msgTransToolErrorSendingFile'] = '翻訳ファイルの送信中にエラーです';
$PMF_LANG['msgTransToolPercent'] = '達成率';
$LANG_CONF['records.attachmentsPath'] = array("input", "添付ファイルを保存するパスを指定してください。<br><small>相対パスの場合は、Webサーバのルートフォルダ配下となります</small>");
$PMF_LANG['msgAttachmentNotFound'] = 'ダウンロードを試みたファイルはサーバ上に存在しません';
$PMF_LANG['ad_sess_noentry'] = 'エントリーがありません';
$PMF_LANG['plmsgUserOnline']['0'] = '%d 人がオンライン';
$PMF_LANG['plmsgUserOnline']['1'] = '%d 人がオンライン';
$LANG_CONF['layout.templateSet'] = array("select", "使用するテンプレート");
$PMF_LANG['plmsgHomeArticlesOnline']['0'] = '%d 件の FAQ があります';
$PMF_LANG['plmsgHomeArticlesOnline']['1'] = '%d 件の FAQ があります';
$PMF_LANG['plmsgViews']['0'] = '%d 回の閲覧';
$PMF_LANG['plmsgViews']['1'] = '%d 回の閲覧';
$PMF_LANG['plmsgGuestOnline']['0'] = '%d 人のゲスト';
$PMF_LANG['plmsgGuestOnline']['1'] = '%d 人のゲスト';
$PMF_LANG['plmsgRegisteredOnline']['0'] = ' , %d 人の登録済みユーザ';
$PMF_LANG['plmsgRegisteredOnline']['1'] = ' , %d 人の登録済みユーザ';
$PMF_LANG['plmsgSearchAmount']['0'] = '%d 件の検索結果';
$PMF_LANG['plmsgSearchAmount']['1'] = '%d 件の検索結果';
$PMF_LANG['plmsgPagesTotal']['0'] = ' %d ページ';
$PMF_LANG['plmsgPagesTotal']['1'] = ' %d ページ';
$PMF_LANG['plmsgVotes']['0'] = '%d 件の投票';
$PMF_LANG['plmsgVotes']['1'] = '%d 件の投票';
$PMF_LANG['plmsgEntries']['0'] = '%d FAQ';
$PMF_LANG['plmsgEntries']['1'] = '%d FAQ';
$PMF_LANG['permission::addtranslation'] = '翻訳の追加';
$PMF_LANG['permission::edittranslation'] = '翻訳の編集';
$PMF_LANG['permission::deltranslation'] = '翻訳の削除';
$PMF_LANG['permission::approverec'] = 'レコードの承認';
$LANG_CONF['records.enableAttachmentEncryption'] = array("checkbox", "添付の暗号化を有効にする <br><small>添付が無効のときは無視</small>");
$LANG_CONF['records.defaultAttachmentEncKey'] = array("input", "標準の添付暗号化鍵 <br><small>添付の暗号化が無効の場合は無視</small><br><small><font color=&quot;red&quot;>警告: 一度設定しファイルが暗号化されている場合、既存設定の変更はしないでください!!!</font></small>");
$PMF_LANG['ad_menu_upgrade'] = 'phpMyFAQ アップグレード';
$PMF_LANG['ad_you_shouldnt_update'] = 'phpMyFAQ のバージョンは最新です。アップグレードの必要はありません。';
$LANG_CONF['security.useSslForLogins'] = array("checkbox", "セキュア接続のログインのみ許可しますか? (初期値: 無効)");
$PMF_LANG['msgSecureSwitch'] = 'セキュア モードのログインに切り替えます!';
$PMF_LANG['msgTransToolNoteFileSaving'] = '保存ボタンを押さない限り、変更内容はファイルに書き込まれませんのでご注意ください';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'ページ %d バッファの格納に成功しました';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'ページ %d バッファの格納に失敗しました';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'ページ %d バッファを格納します';
$PMF_LANG['ad_record_active'] = '有効';
$PMF_LANG['msgAttachmentInvalid'] = '添付ファイルは無効です、管理者に確認してください';
$LANG_CONF['search.numberSearchTerms'] = array('input', '一覧に出す検索件数');
$LANG_CONF['main.orderingPopularFaqs'] = array("select", "トップ FAQ の並び替え方法");
$PMF_LANG['list_all_users'] = '全ユーザーの一覧';
$PMF_LANG['main.orderingPopularFaqs.visits'] = '最も訪問があるエントリーの一覧';
$PMF_LANG['main.orderingPopularFaqs.voting'] = '最も投票のあるエントリーの一覧';
$PMF_LANG['msgShowHelp'] = '単語をカンマで区切ってください。';
$PMF_LANG['msgUpdateFaqDate'] = '更新';
$PMF_LANG['msgKeepFaqDate'] = '維持';
$PMF_LANG['msgEditFaqDat'] = '編集';
$PMF_LANG['ad_entry_savedfail'] = '<strong>データベースエラー</strong>が発生しました。';
$PMF_LANG['searchControlCenter'] = '検索';
$PMF_LANG['search.relevance.thema-content-keywords'] = '質問 - 回答 - キーワード';
$PMF_LANG['search.relevance.thema-keywords-content'] = '質問 - キーワード - 回答';
$PMF_LANG['search.relevance.content-thema-keywords'] = '回答 - 質問 - キーワード';
$PMF_LANG['search.relevance.content-keywords-thema'] = '回答 - キーワード - 質問';
$PMF_LANG['search.relevance.keywords-content-thema'] = 'キーワード - 回答 - 質問';
$PMF_LANG['search.relevance.keywords-thema-content'] = 'キーワード - 質問 - 回答';
$PMF_LANG['msgLoginUser'] = 'ログイン';
$LANG_CONF['search.relevance'] = array('select', '関連度による並び替え');
$LANG_CONF['search.enableRelevance'] = array('checkbox', '関連度サポートを有効化する (初期値:無効)');
$PMF_LANG['ad_menu_attachments'] = '添付ファイル';
$PMF_LANG['ad_menu_attachment_admin'] = '添付ファイル管理';
$PMF_LANG['msgAttachmentsFilename'] = 'ファイル名';
$PMF_LANG['msgAttachmentsFilesize'] = 'サイズ';
$PMF_LANG['msgAttachmentsMimeType'] = 'MIMEタイプ';
$PMF_LANG['msgAttachmentsWannaDelete'] = 'この添付ファイルを削除しても良いですか?';
$PMF_LANG['msgAttachmentsDeleted'] = '添付ファイルの削除は <strong>成功</strong> しました。';
$PMF_LANG['ad_menu_reports'] = 'レポート';
$PMF_LANG['ad_stat_report_fields'] = 'フィールド';
$PMF_LANG['ad_stat_report_category'] = 'カテゴリー';
$PMF_LANG['ad_stat_report_sub_category'] = 'サブカテゴリー';
$PMF_LANG['ad_stat_report_translations'] = '翻訳';
$PMF_LANG['ad_stat_report_language'] = '言語';
$PMF_LANG['ad_stat_report_id'] = 'FAQ ID';
$PMF_LANG['ad_stat_report_sticky'] = 'スティッキー FAQ';
$PMF_LANG['ad_stat_report_title'] = '質問';
$PMF_LANG['ad_stat_report_creation_date'] = '日付';
$PMF_LANG['ad_stat_report_owner'] = 'オリジナル作成者';
$PMF_LANG['ad_stat_report_last_modified_person'] = '最近の修正者';
$PMF_LANG['ad_stat_report_url'] = 'URL';
$PMF_LANG['ad_stat_report_visits'] = '訪問者';
$PMF_LANG['ad_stat_report_make_report'] = 'レポート生成';
$PMF_LANG['ad_stat_report_make_csv'] = 'CSV にエクスポート';
$PMF_LANG['msgRegistration'] = '登録';
$PMF_LANG['msgRegistrationCredentials'] = '登録するには、名前・ログイン名・有効なメールアドレスを入力してください!';
$PMF_LANG['msgRegistrationNote'] = 'あなたの登録が管理者に認証された後、登録が成功し回答を受け取ることが可能となります。';
$PMF_LANG['ad_entry_changelog_history'] = '改編履歴';
$LANG_CONF['security.ssoSupport'] = array('checkbox', 'シングルサインオンサポート (初期値:無効)');
$LANG_CONF['security.ssoLogoutRedirect'] = array('input', 'シングルサインオン ログアウトのリダイレクトサービスURL');
$LANG_CONF['main.dateFormat'] = array('input', '日付フォーマット (初期値: Y-m-d H:i)');
$LANG_CONF['security.enableLoginOnly'] = array('checkbox', 'FAQ閲覧にログインを必要とする (初期値: 無効)');
$PMF_LANG['securityControlCenter'] = 'セキュリティ構成';
$PMF_LANG['ad_search_delsuc'] = 'The searchterm was successfully deleted.';
$PMF_LANG['ad_search_delfail'] = 'The seachterm was not deleted.';
$PMF_LANG['msg_about_faq'] = 'この FAQ について';
$LANG_CONF['security.useSslOnly'] = array('checkbox', 'FAQ with SSL only (初期値: 無効)');
$PMF_LANG['msgTableOfContent'] = '目次';
$PMF_LANG['msgShowMore'] = 'さらに表示';
$PMF_LANG['msgQuestionAnswered'] = 'Question answered';
$PMF_LANG['msgMessageQuestionAnswered'] = 'Your question at %s was answered. Please check it here:';
$PMF_LANG['ad_stopwords_desc'] = 'Please select a language to add or edit stopwords.';
$PMF_LANG['ad_visits_per_day'] = '一日の訪問者数';
$PMF_LANG['ad_instance_add'] = 'Add a new phpMyFAQ multi site instance';
$PMF_LANG['ad_instance_error_notwritable'] = 'The folder /multisite isn\'t writable.';
$PMF_LANG['ad_instance_url'] = 'インスタンスURL';
$PMF_LANG['ad_instance_path'] = 'インスタンスパス';
$PMF_LANG['ad_instance_name'] = 'インスタンス名';
$PMF_LANG['ad_instance_email'] = '管理者メール';
$PMF_LANG['ad_instance_admin'] = '管理者ログイン名';
$PMF_LANG['ad_instance_password'] = '管理者パスワード';
$PMF_LANG['ad_instance_hint'] = 'Caution: It will take some seconds to create a new phpMyFAQ instance!';
$PMF_LANG['ad_instance_button'] = 'インスタンスを保存';
$PMF_LANG['ad_instance_error_cannotdelete'] = 'インスタンスを削除できません';
$PMF_LANG['ad_instance_config'] = 'インスタンスを編集';
$PMF_LANG['msgAboutThisNews'] = 'このニュースについて';
$PMF_LANG['msgAccessDenied'] = '許可されていません';
$LANG_CONF['records.randomSort'] = array('checkbox', 'Sort FAQs randomly (default: deactivated)');
$LANG_CONF['main.enableWysiwygEditorFrontend'] = array('checkbox', 'Enable bundled WYSIWYG editor in frontend (default: disabled)');
$LANG_CONF['main.enableGravatarSupport'] = array('checkbox', 'Gravatar Support (default: disabled)');
$PMF_LANG['msgSeeFAQinFrontend'] = '現在のFAQページを確認';
$PMF_LANG['records.orderingPopularFaqs.visits'] = '訪問者数順';
$PMF_LANG['records.orderingPopularFaqs.voting'] = '投票数順';
$LANG_CONF['records.orderingPopularFaqs'] = array('select', 'Sorting of the top FAQ\'s');
$PMF_LANG['msgExportAllFaqs'] = 'Print all as PDF';
$PMF_LANG['msgOnlineVerificationCheck'] = 'Online verification check';
$PMF_LANG['msgOnlineVerificationCheckButton'] = 'Click to verify your phpMyFAQ installation';
$PMF_LANG['ad_verification_notokay'] = 'Your version of phpMyFAQ has local changes:';
$PMF_LANG['ad_verification_okay'] = 'Your version of phpMyFAQ was successfully verified.';
$PMF_LANG['cacheControlCenter'] = 'Cache configuration';
$PMF_LANG['msgAdminSearchFaqs'] = 'FAQ の検索';
$PMF_LANG['msg2answerFAQ'] = 'Answered';
$PMF_LANG['headerUserControlPanel'] = 'ユーザー情報の編集';
$PMF_LANG['rememberMe'] = 'ログイン情報を記憶する';
$PMF_LANG['ad_menu_instances'] = 'FAQ マルチサイト';
$PMF_LANG['ad_record_inactive'] = '件の無効なFAQ';
$PMF_LANG['msgMode'] = 'Modus';
$PMF_LANG['msgMaintenanceMode'] = 'FAQ メンテナンス中';
$PMF_LANG['msgOnlineMode'] = 'FAQ 稼働中';
$LANG_CONF['records.enableCloseQuestion'] = array('checkbox', 'Close open question after answer?');
$LANG_CONF['records.enableDeleteQuestion'] = array('checkbox', 'Delete open question after answer?');
$LANG_CONF['main.maintenanceMode'] = array('checkbox', 'Set FAQ in maintenance mode');
$LANG_CONF['records.numberOfRecordsPerPage'] = array('input', 'ページ毎に表示するトピック数');
$LANG_CONF['records.numberOfShownNewsEntries'] = array('input', 'お知らせの表示数');

// added v.2.9.0-alpha
$PMF_LANG["msgRelatedTags"] = 'キーワードを追加';
$PMF_LANG["msgPopularTags"] = '人気の検索';
$LANG_CONF["search.enableHighlighting"] = ["checkbox", "検索語句をハイライト"];
$LANG_CONF["records.allowCommentsForGuests"] = ["checkbox", "ゲストユーザからのコメントを許可"];
$LANG_CONF["records.allowQuestionsForGuests"] = ["checkbox", "ゲストユーザからの質問を許可"];
$LANG_CONF["records.allowNewFaqsForGuests"] = ["checkbox", "ゲストユーザからのFAQ追加を許可"];
$PMF_LANG["ad_searchterm_del"] = '保存された検索語句をすべて削除';
$PMF_LANG["ad_searchterm_del_suc"] = '検索語句をすべて削除しました。';
$PMF_LANG["ad_searchterm_del_err"] = '検索語句を削除できませんでした。';
$LANG_CONF["records.hideEmptyCategories"] = ["checkbox", "空のカテゴリーを非表示"];
$LANG_CONF["search.searchForSolutionId"] = ["checkbox", "ソリューションIDで検索"];
$LANG_CONF["socialnetworks.disableAll"] = ["checkbox", "SNS連携を無効にする"];

// added v2.9.0-alpha2
$PMF_LANG["ad_tag_delete_success"] = "タグは削除されました。";
$PMF_LANG["ad_tag_delete_error"] = "エラーが発生したためタグを削除できませんでした。";
$PMF_LANG["seoCenter"] = "SEO";
$LANG_CONF["seo.metaTagsHome"] = ["select", "トップページのメタタグ"];
$LANG_CONF["seo.metaTagsFaqs"] = ["select", "FAQページのメタタグ"];
$LANG_CONF["seo.metaTagsCategories"] = ["select", "カテゴリーページのメタタグ"];
$LANG_CONF["seo.metaTagsPages"] = ["select", "静的ページのメタタグ"];
$LANG_CONF["seo.metaTagsAdmin"] = ["select", "管理ページのメタタグ"];
$PMF_LANG["msgMatchingQuestions"] = "質問内容に類似した結果一覧";
$PMF_LANG["msgFinishSubmission"] = "上記一覧に質問内容と一致した結果が無い場合、下記のボタンを押して質問投稿を完了してください。";
$LANG_CONF['spam.manualActivation'] = ['checkbox', '新規ユーザを手動で承認(デフォルト: 有効)'];

// added v2.9.0-alpha2
$PMF_LANG['mailControlCenter'] = 'メール設定';
$LANG_CONF['mail.remoteSMTP'] = ['checkbox', 'リモートのSMTPサーバーを利用 (デフォルト: 無効)'];
$LANG_CONF['mail.remoteSMTPServer'] = ['input', 'サーバーアドレス'];
$LANG_CONF['mail.remoteSMTPUsername'] = ['input', 'ユーザー名'];
$LANG_CONF['mail.remoteSMTPPassword'] = ['password', 'パスワード'];
$LANG_CONF['security.enableRegistration'] = ['checkbox', '閲覧者のユーザ登録を有効化'];

// added v2.9.0-alpha3
$LANG_CONF['main.customPdfHeader'] = ['area', 'カスタムPDFヘッダー (HTML利用可能)'];
$LANG_CONF['main.customPdfFooter'] = ['area', 'カスタムPDFフッター (HTML利用可能)'];
$LANG_CONF['records.allowDownloadsForGuests'] = ['checkbox', 'ゲストユーザーによるダウンロードを許可'];
$PMF_LANG["ad_msgNoteAboutPasswords"] = "警告: パスワードを入力した場合、ユーザーのパスワードは上書きされます。";
$PMF_LANG["ad_delete_all_votings"] = "すべての投票を削除";
$PMF_LANG["ad_categ_moderator"] = "モデレーター";
$PMF_LANG['ad_clear_all_visits'] = "すべての閲覧履歴をリセット";
$PMF_LANG['ad_reset_visits_success'] = '閲覧履歴をリセットしました。';
$LANG_CONF['main.enableMarkdownEditor'] = ['checkbox', '内蔵Markdownエディタの有効化'];

// added v2.9.0-beta
$PMF_LANG['faqOverview'] = 'FAQ概要';
$PMF_LANG['ad_dir_missing'] = 'ディレクトリ( %s )がみつかりません。';
$LANG_CONF['main.enableSmartAnswering'] = ['checkbox', 'スマート回答を有効化'];

// added v2.9.0-beta2
$LANG_CONF['search.enableElasticsearch'] = ['checkbox', 'Elasticsearchを有効化'];
$PMF_LANG['ad_menu_elasticsearch'] = 'Elasticsearch設定';
$PMF_LANG['ad_es_create_index'] = 'Index作成';
$PMF_LANG['ad_es_drop_index'] = 'Index削除';
$PMF_LANG['ad_es_bulk_index'] = '全件インポート';
$PMF_LANG['ad_es_create_index_success'] = 'Indexを作成しました。';
$PMF_LANG['ad_es_create_import_success'] = 'インポートに成功しました。';
$PMF_LANG['ad_es_drop_index_success'] = 'Indexを削除しました。';
$PMF_LANG['ad_export_generate_json'] = 'JSONファイルの作成';
$PMF_LANG['ad_media_name_search'] = 'メディア名で検索';

// added v2.9.0-RC
$PMF_LANG['ad_admin_notes'] = 'プライベートメモ';
$PMF_LANG['ad_admin_notes_hint'] = ' (編集者のみ閲覧可)';

// added v2.9.10
$PMF_LANG['ad_quick_entry'] = 'このカテゴリーにFAQを追加';

// added 2.10.0-alpha
$LANG_CONF['ldap.ldap_mapping.name'] = ['input', 'LDAP mapping for name, "cn" when using an ADS'];
$LANG_CONF['ldap.ldap_mapping.username'] = ['input', 'LDAP mapping for username, "samAccountName" when using an ADS'];
$LANG_CONF['ldap.ldap_mapping.mail'] = ['input', 'LDAP mapping for email, "mail" when using an ADS'];
$LANG_CONF['ldap.ldap_mapping.memberOf'] = ['input', 'LDAP mapping for "member of" when using LDAP groups'];
$LANG_CONF['ldap.ldap_use_domain_prefix'] = ['checkbox', 'LDAP domain prefix, e.g. "DOMAIN\username"'];
$LANG_CONF['ldap.ldap_options.LDAP_OPT_PROTOCOL_VERSION'] = ['input', 'LDAP protocol version (default: 3)'];
$LANG_CONF['ldap.ldap_options.LDAP_OPT_REFERRALS'] = ['input', 'LDAP referrals (default: 0)'];
$LANG_CONF['ldap.ldap_use_memberOf'] = ['checkbox', 'Enable LDAP group support, e.g. "DOMAIN\username"'];
$LANG_CONF['ldap.ldap_use_sasl'] = ['checkbox', 'Enable LDAP SASL support'];
$LANG_CONF['ldap.ldap_use_multiple_servers'] = ['checkbox', 'Enable multiple LDAP servers support'];
$LANG_CONF['ldap.ldap_use_anonymous_login'] = ['checkbox', 'Enable anonymous LDAP connections'];
$LANG_CONF['ldap.ldap_use_dynamic_login'] = ['checkbox', 'Enable LDAP dynamic user binding'];
$LANG_CONF['ldap.ldap_dynamic_login_attribute'] = ['input', 'LDAP attribute for dynamic user binding, "uid" when using an ADS'];
$LANG_CONF['seo.enableXMLSitemap'] = ['checkbox', 'Enable XML sitemap'];
$PMF_LANG['ad_category_image'] = 'カテゴリー画像';
$PMF_LANG["ad_user_show_home"] = "トップページに表示";

// added v.2.10.0-alpha
$PMF_LANG['ad_view_faq'] = 'FAQを表示';

// added 3.0.0-alpha
$LANG_CONF['main.enableCategoryRestrictions'] = ['checkbox', 'カテゴリー制限を有効化'];
$LANG_CONF['main.enableSendToFriend'] = ['checkbox', 'Enable send to friends'];
$PMF_LANG['msgUserRemovalText'] = 'あなたのアカウント情報の削除を申請できます。あなたのアカウント情報（アカウント、コメント、質問）を削除するように、管理者宛にメールを送信します。手動での削除となるため、対応されるまで24時間ほどかかる場合があります。削除が完了した際は、メールにて完了通知が行われます。';
$PMF_LANG["msgUserRemoval"] = "ユーザ削除申請";
$PMF_LANG["ad_menu_RequestRemove"] = "ユーザ削除申請";
$PMF_LANG["msgContactRemove"] = "管理者からの削除依頼";
$PMF_LANG["msgContactPrivacyNote"] = "プライバシーノート";
$PMF_LANG["msgPrivacyNote"] = "プライバシー情報の状態";

// added 3.0.0-alpha2
$LANG_CONF['main.enableAutoUpdateHint'] = ['checkbox', '最新バージョンを自動確認'];
$PMF_LANG['ad_user_is_superadmin'] = '特権管理者';
$PMF_LANG['ad_user_overwrite_passwd'] = 'パスワードを上書き';
$LANG_CONF['records.enableAutoRevisions'] = ['checkbox', 'FAQの変更履歴を有効化'];
$PMF_LANG['permission::view_faqs'] = 'FAQを表示';
$PMF_LANG['permission::view_categories'] = 'カテゴリーを表示';
$PMF_LANG['permission::view_sections'] = 'セクションを表示';
$PMF_LANG['permission::view_news'] = 'ニュースを表示';
$PMF_LANG['permission::add_section'] = 'セクションを追加';
$PMF_LANG['permission::edit_section'] = 'セクションを編集';
$PMF_LANG['permission::delete_section'] = 'セクションを削除';
$PMF_LANG['permission::administrate_sections'] = 'セクション管理';
$PMF_LANG['permission::administrate_groups'] = 'グループ管理';
$PMF_LANG['ad_group_rights'] = 'グループ権限';

// added v3.0.0-alpha.3
$PMF_LANG['ad_menu_section_administration'] = "セクションの管理";
$PMF_LANG['ad_section_add'] = "セクションの追加";
$PMF_LANG['ad_section_add_link'] = "セクションを追加する";
$PMF_LANG['ad_sections'] = 'セクション';
$PMF_LANG['ad_section_details'] = "セクションの詳細";
$PMF_LANG['ad_section_name'] = "名称:";
$PMF_LANG['ad_section_description'] = "説明:";
$PMF_LANG['ad_section_membership'] = "セクションのメンバー設定";
$PMF_LANG['ad_section_members'] = "セクションのメンバー一覧";
$PMF_LANG['ad_section_addMember'] = "追加 >>";
$PMF_LANG['ad_section_removeMember'] = "<< 削除";
$PMF_LANG['ad_section_deleteSection'] = "セクションの削除";
$PMF_LANG['ad_section_deleteQuestion'] = "このセクションを本当に削除しますか？";
$PMF_LANG['ad_section_error_delete'] = "セクションを削除できません。";
$PMF_LANG['ad_section_error_noName'] = "セクションの名称を指定して下さい。";
$PMF_LANG['ad_section_suc'] = "セクションの追加に<strong>成功</strong>しました。";
$PMF_LANG['ad_section_deleted'] = "セクションを削除しました。";
$PMF_LANG['permission::viewadminlink'] = '管理リンクを表示';

// added v3.0.0-beta.3
$LANG_CONF['mail.remoteSMTPPort'] = ['input', 'SMTPサーバーのポート'];
$PMF_LANG['ad_record_faq'] = '質問と回答';
$PMF_LANG['ad_record_permissions'] = '権限';
$PMF_LANG['loginPageMessage'] = 'ログイン先: ';

// added v3.0.5
$PMF_LANG['ad_menu_faq_meta'] = 'FAQメタデータ';

// added v3.0.8
$LANG_CONF['main.privacyURL'] = ['input', 'プライバシーノートのURL'];

// added v3.1.0-alpha
$PMF_LANG['msgUserDataVisible'] = 'ユーザー名の公開';
$PMF_LANG['ad_user_is_visible'] = '公開';
$PMF_LANG['ad_categ_save_order'] = '順序の保存';
$PMF_LANG['ad_add_user_change_password'] = '初回ログイン時にはパスワード変更が必要です。';
$LANG_CONF['api.enableAccess'] = ['checkbox', 'REST API有効化'];
$LANG_CONF['api.apiClientToken'] = ['input', 'API Client Token'];
$LANG_CONF['security.domainWhiteListForRegistrations'] = ['area', 'ユーザー登録の許可ホワイトリスト'];
$LANG_CONF['security.loginWithEmailAddress'] = ['checkbox', 'メールアドレスによるログインのみ許可'];

return $PMF_LANG;
