define("tiny_recordrtc/convert_to_mp3",["exports","./lame.all"],(function(_exports,_lame){var obj;
/**
   * Convert audio to MP3.
   *
   * @module     tiny_recordrtc/convert_to_mp3
   * @copyright  Meirza <meirza.arson@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.convertMp3=void 0,_lame=(obj=_lame)&&obj.__esModule?obj:{default:obj};const extractPCM=audioBuffer=>{const channelData=[],numberOfChannels=audioBuffer.numberOfChannels,audioBufferLength=audioBuffer.length;for(let channel=0;channel<numberOfChannels;channel++){const rawChannelData=audioBuffer.getChannelData(channel);channelData[channel]=new Int16Array(audioBufferLength);for(let i=0;i<audioBufferLength;i++)channelData[channel][i]=32768*rawChannelData[i]}return channelData},getAudioBuffer=async sourceUrl=>{const response=await fetch(sourceUrl),arrayBuffer=await response.arrayBuffer();return(new(window.AudioContext||window.webkitAudioContext)).decodeAudioData(arrayBuffer)},convertAudioBuffer=function(lamejs,channels,sampleRate,bitRate,left){let right=arguments.length>5&&void 0!==arguments[5]?arguments[5]:null;const mp3Data=[],mp3Encoder=new lamejs.Mp3Encoder(channels,sampleRate,bitRate),sampleBlockSize=1152;for(let i=0;i<left.length;i+=sampleBlockSize){const leftChunk=left.subarray(i,i+sampleBlockSize),mp3Buf=right?mp3Encoder.encodeBuffer(leftChunk,right.subarray(i,i+sampleBlockSize)):mp3Encoder.encodeBuffer(leftChunk);mp3Buf.length&&mp3Data.push(mp3Buf)}const mp3Buf=mp3Encoder.flush();return mp3Buf.length&&mp3Data.push(new Int8Array(mp3Buf)),new Blob(mp3Data,{type:"audio/mp3"})};_exports.convertMp3=async function(sourceUrl){let bitRate=arguments.length>1&&void 0!==arguments[1]?arguments[1]:128;const audioBuffer=await getAudioBuffer(sourceUrl),[left,right]=extractPCM(audioBuffer);return convertAudioBuffer(_lame.default,audioBuffer.numberOfChannels,audioBuffer.sampleRate,bitRate,left,right)}}));

//# sourceMappingURL=convert_to_mp3.min.js.map