﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['tr']={"application":"Rich Text Editor","editor":"Zengin Metin Editörü","editorPanel":"Zengin Metin Editör Paneli","common":{"editorHelp":"Yardım için ALT 0 tuşlarına basın","browseServer":"Sunucuya Gözat","url":"URL","protocol":"Protokol","upload":"Karşıya Yükle","uploadSubmit":"Sunucuya Gönder","image":"Resim","form":"Form","checkbox":"Seçim Kutusu","radio":"Seçenek Düğmesi","textField":"Metin Kutusu","textarea":"Metin Alanı","hiddenField":"Gizli Alan","button":"Düğme","select":"Seçme Alanı","imageButton":"Resim Düğmesi","notSet":"<tanımlanmamış>","id":"Kimlik","name":"İsim","langDir":"Dil Yönü","langDirLtr":"Soldan Sağa (LTR)","langDirRtl":"Sağdan Sola (RTL)","langCode":" Dil Kodu","longDescr":"Uzun Açıklamalı URL","cssClass":"Stil Sınıfları","advisoryTitle":"Öneri Başlığı","cssStyle":"Stil","ok":"Tamam","cancel":"İptal","close":"Kapat","preview":"Önizleme","resize":"Yeniden Boyutlandır","generalTab":"Genel","advancedTab":"Gelişmiş","validateNumberFailed":"Bu değer bir sayı değildir.","confirmNewPage":"Bu içerikle ilgili kaydedilmemiş tüm bilgiler kaybolacaktır. Yeni bir sayfa yüklemek istediğinizden emin misiniz?","confirmCancel":"Bazı seçenekleri değiştirdiniz. İletişim penceresini kapatmak istediğinizden emin misiniz?","options":"Seçenekler","target":"Hedef","targetNew":"Yeni Pencere (_blank)","targetTop":"En Üstteki Pencere (_top)","targetSelf":"Aynı Pencere (_self)","targetParent":"Üst Pencere (_parent)","langDirLTR":"Soldan Sağa (LTR)","langDirRTL":"Sağdan Sola (RTL)","styles":"Stil","cssClasses":"Stil Sınıfları","width":"Genişlik","height":"Yükseklik","align":"Hizalama","left":"Sol","right":"Sağ","center":"Ortala","justify":"İki Kenara Yaslanmış","alignLeft":"Sola Dayalı","alignRight":"Sağa Dayalı","alignCenter":"Ortaya Hizala","alignTop":"Üst","alignMiddle":"Orta","alignBottom":"Alt","alignNone":"Hiçbiri","invalidValue":"Geçersiz değer.","invalidHeight":"Yükseklik değeri bir sayı olmalıdır.","invalidWidth":"Genişlik değeri bir sayı olmalıdır.","invalidLength":"\"%1\" alanı için belirtilen değer, geçerli bir ölçü birimi olsun veya olmasın (%2) pozitif bir sayı olmalıdır.","invalidCssLength":"\"%1\" alanı için verilen değer, geçerli bir CSS ölçü birimi (px, %, in, cm, mm, em, ex, pt, veya pc) içeren veya içermeyen pozitif bir sayı olmalıdır.","invalidHtmlLength":"\"%1\" alanı için belirttiğiniz sayı, HTML (px veya %) birimi olsun yada olmasın pozitif bir değeri olmalıdır.","invalidInlineStyle":"Satıriçi stil için verilen değer, \"isim : değer\" biçiminde birbirinden noktalı virgüllerle ayrılan bir veya daha fazla değişkenler grubundan oluşmalıdır.","cssLengthTooltip":"Piksel türünde bir sayı veya geçerli bir CSS ölçü birimi (px, %, in, cm, mm, em, ex, pt veya pc) içeren bir sayı girin.","unavailable":"%1<span class=\"cke_accessibility\">, kullanılamaz</span>","keyboard":{"8":"Silme Tuşu","13":"Giriş Tuşu","16":"Üst Karater Tuşu","17":"Kontrol Tuşu","18":"Alt Tuşu","32":"Boşluk Tuşu","35":"En Sona Tuşu","36":"En Başa Tuşu","46":"Silme Tuşu","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Komut Tuşu"},"keyboardShortcut":"Klavye Kısayolu","optionDefault":"Varsayılan"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Tüm hakları saklıdır.","dlgTitle":"CKEditor Hakkında","moreInfo":"Lisanslama hakkında daha fazla bilgi almak için lütfen sitemizi ziyaret edin:"},"basicstyles":{"bold":"Kalın","italic":"İtalik","strike":"Üstü Çizgili","subscript":"Alt Simge","superscript":"Üst Simge","underline":"Altı Çizgili"},"bidi":{"ltr":"Metin yönü soldan sağa","rtl":"Metin yönü sağdan sola"},"blockquote":{"toolbar":"Blok Oluştur"},"notification":{"closed":"Uyarılar kapatıldı."},"toolbar":{"toolbarCollapse":"Araç çubuklarını topla","toolbarExpand":"Araç çubuklarını aç","toolbarGroups":{"document":"Belge","clipboard":"Pano/Geri al","editing":"Düzenleme","forms":"Formlar","basicstyles":"Temel Stiller","paragraph":"Paragraf","links":"Bağlantılar","insert":"Ekle","styles":"Stiller","colors":"Renkler","tools":"Araçlar"},"toolbars":"Araç çubukları Editörü"},"clipboard":{"copy":"Kopyala","copyError":"Tarayıcı yazılımınızın güvenlik ayarları düzenleyicinin otomatik kopyalama işlemine izin vermiyor. İşlem için (Ctrl/Cmd+C) tuşlarını kullanın.","cut":"Kes","cutError":"Tarayıcı yazılımınızın güvenlik ayarları düzenleyicinin otomatik kesme işlemine izin vermiyor. İşlem için (Ctrl/Cmd+X) tuşlarını kullanın.","paste":"Yapıştır","pasteNotification":"%1 tuşuna yapıştırmak için tıklayın. Tarayıcınız, Araç Çubuğu yada İçerik Menüsünü kullanarak yapıştırmayı desteklemiyor.","pasteArea":"Yapıştırma Alanı","pasteMsg":"İçeriğinizi alttaki bulunan alana yapıştırın ve TAMAM butonuna tıklayın","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Otomatik","bgColorTitle":"Arka Renk","colors":{"000":"Siyah","800000":"Kestane","8B4513":"Koyu Kahverengi","2F4F4F":"Koyu Kurşuni Gri","008080":"Teal","000080":"Mavi","4B0082":"Çivit Mavisi","696969":"Silik Gri","B22222":"Ateş Tuğlası","A52A2A":"Kahverengi","DAA520":"Altun Sırık","006400":"Koyu Yeşil","40E0D0":"Turkuaz","0000CD":"Orta Mavi","800080":"Pembe","808080":"Gri","F00":"Kırmızı","FF8C00":"Koyu Portakal","FFD700":"Altın","008000":"Yeşil","0FF":"Ciyan","00F":"Mavi","EE82EE":"Menekşe","A9A9A9":"Loş Gri","FFA07A":"Açık Sarımsı","FFA500":"Portakal","FFFF00":"Sarı","00FF00":"Açık Yeşil","AFEEEE":"Sönük Turkuaz","ADD8E6":"Açık Mavi","DDA0DD":"Mor","D3D3D3":"Açık Gri","FFF0F5":"Eflatun Pembe","FAEBD7":"Antik Beyaz","FFFFE0":"Açık Sarı","F0FFF0":"Balsarısı","F0FFFF":"Gök Mavisi","F0F8FF":"Reha Mavi","E6E6FA":"Eflatun","FFF":"Beyaz","1ABC9C":"Koyu Camgöbeği","2ECC71":"Zümrüt Yeşili","3498DB":"Parlak Mavi","9B59B6":"Ametist Moru","4E5F70":"Kirli Gri Mavi","F1C40F":"Canlı Sarı","16A085":"Koyu Camgöbeği","27AE60":"Koyu Zümrüt Yeşili","2980B9":"Koyu Mavi","8E44AD":"Koyu Menekşe","2C3E50":"Koyu Lacivert","F39C12":"Turuncu","E67E22":"Havuç Turuncusu","E74C3C":"Soluk Kırmızı","ECF0F1":"Parlak Gümüş","95A5A6":"Açık Kirli Gri Camgöbeği","DDD":"Açık Gri","D35400":"Balkabağı Turuncusu","C0392B":"Kan Kırmızı","BDC3C7":"Gümüş","7F8C8D":"Kirli Gri Camgöbeği","999":"Koyu Gri"},"more":"Diğer renkler...","panelTitle":"Renkler","textColorTitle":"Yazı Rengi"},"colordialog":{"clear":"Temizle","highlight":"İşaretle","options":"Renk Seçenekleri","selected":"Seçilmiş","title":"Renk seç"},"templates":{"button":"Şablonlar","emptyListMsg":"(Belirli bir şablon seçilmedi)","insertOption":"Mevcut içerik ile değiştir","options":"Şablon Seçenekleri","selectPromptMsg":"Düzenleyicide açmak için lütfen bir şablon seçin.<br>(hali hazırdaki içerik kaybolacaktır.):","title":"İçerik Şablonları"},"contextmenu":{"options":"İçerik Menüsü Seçenekleri"},"copyformatting":{"label":"Formatı Kopyala","notification":{"copied":"Formatlama Kopyalandı","applied":"Formatlama Uygulandı","canceled":"Formatlama İptal Edildi","failed":"Formatlama hatası. İlk önce onları kopyalamadan stilleri uygulayamazsınız."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Tavsiye Başlığı","cssClassInputLabel":"Stilltipi Sınıfı","edit":"Div Düzenle","inlineStyleInputLabel":"Inline Stili","langDirLTRLabel":"Soldan sağa (LTR)","langDirLabel":"Dil Yönü","langDirRTLLabel":"Sağdan sola (RTL)","languageCodeInputLabel":" Dil Kodu","remove":"Div Kaldır","styleSelectLabel":"Stil","title":"Div İçeriği Oluştur","toolbar":"Div İçeriği Oluştur"},"elementspath":{"eleLabel":"Elementlerin yolu","eleTitle":"%1 elementi"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Dosya okunurken hata oluştu.","networkError":"Dosya gönderilirken ağ hatası oluştu.","httpError404":"Dosya gönderilirken HTTP hatası oluştu (404: Dosya bulunamadı).","httpError403":"Dosya gönderilirken HTTP hatası oluştu (403: Yasaklı).","httpError":"Dosya gönderilirken HTTP hatası oluştu (hata durumu: %1).","noUrlError":"Gönderilecek URL belirtilmedi.","responseError":"Sunucu cevap veremedi."},"find":{"find":"Bul","findOptions":"Seçenekleri Bul","findWhat":"Aranan:","matchCase":"Büyük/küçük harf duyarlı","matchCyclic":"Eşleşen döngü","matchWord":"Kelimenin tamamı uysun","notFoundMsg":"Belirtilen yazı bulunamadı.","replace":"Değiştir","replaceAll":"Tümünü Değiştir","replaceSuccessMsg":"%1 bulunanlardan değiştirildi.","replaceWith":"Bununla değiştir:","title":"Bul ve Değiştir"},"font":{"fontSize":{"label":"Boyut","voiceLabel":"Font Size","panelTitle":"Boyut"},"label":"Yazı Türü","panelTitle":"Yazı Türü","voiceLabel":"Font"},"fakeobjects":{"anchor":"Bağlantı","hiddenfield":"Gizli Alan","iframe":"IFrame","unknown":"Bilinmeyen Nesne"},"forms":{"button":{"title":"Düğme Özellikleri","text":"Metin (Değer)","type":"Tip","typeBtn":"Düğme","typeSbm":"Gönder","typeRst":"Sıfırla"},"checkboxAndRadio":{"checkboxTitle":"Onay Kutusu Özellikleri","radioTitle":"Seçenek Düğmesi Özellikleri","value":"Değer","selected":"Seçili","required":"Zorunlu"},"form":{"title":"Form Özellikleri","menu":"Form Özellikleri","action":"İşlem","method":"Yöntem","encoding":"Kodlama"},"hidden":{"title":"Gizli Veri Özellikleri","name":"Ad","value":"Değer"},"select":{"title":"Seçim Menüsü Özellikleri","selectInfo":"Bilgi","opAvail":"Mevcut Seçenekler","value":"Değer","size":"Boyut","lines":"satır","chkMulti":"Çoklu seçime izin ver","required":"Zorunlu","opText":"Metin","opValue":"Değer","btnAdd":"Ekle","btnModify":"Düzenle","btnUp":"Yukarı","btnDown":"Aşağı","btnSetValue":"Seçili değer olarak ata","btnDelete":"Sil"},"textarea":{"title":"Çok Satırlı Metin Özellikleri","cols":"Sütunlar","rows":"Satırlar"},"textfield":{"title":"Metin Girişi Özellikleri","name":"Ad","value":"Değer","charWidth":"Karakter Genişliği","maxChars":"En Fazla Karakter","required":"Zorunlu","type":"Tür","typeText":"Metin","typePass":"Şifre","typeEmail":"E-posta","typeSearch":"Ara","typeTel":"Telefon Numarası","typeUrl":"URL"}},"format":{"label":"Biçim","panelTitle":"Biçim","tag_address":"Adres","tag_div":"Paragraf (DIV)","tag_h1":"Başlık 1","tag_h2":"Başlık 2","tag_h3":"Başlık 3","tag_h4":"Başlık 4","tag_h5":"Başlık 5","tag_h6":"Başlık 6","tag_p":"Normal","tag_pre":"Biçimli"},"horizontalrule":{"toolbar":"Yatay Satır Ekle"},"iframe":{"border":"Çerceve sınırlarını göster","noUrl":"Lütfen IFrame köprü (URL) bağlantısını yazın","scrolling":"Kaydırma çubuklarını aktif et","title":"IFrame Özellikleri","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Alternatif Yazı","border":"Kenar","btnUpload":"Sunucuya Yolla","button2Img":"Seçili resim butonunu basit resime çevirmek istermisiniz?","hSpace":"Yatay Boşluk","img2Button":"Seçili olan resimi, resimli butona çevirmek istermisiniz?","infoTab":"Resim Bilgisi","linkTab":"Köprü","lockRatio":"Oranı Kilitle","menu":"Resim Özellikleri","resetSize":"Boyutu Başa Döndür","title":"Resim Özellikleri","titleButton":"Resimli Düğme Özellikleri","upload":"Karşıya Yükle","urlMissing":"Resmin URL kaynağı eksiktir.","vSpace":"Dikey Boşluk","validateBorder":"Çerçeve tam sayı olmalıdır.","validateHSpace":"HSpace tam sayı olmalıdır.","validateVSpace":"VSpace tam sayı olmalıdır."},"indent":{"indent":"Sekme Arttır","outdent":"Sekme Azalt"},"smiley":{"options":"İfade Seçenekleri","title":"İfade Ekle","toolbar":"İfade"},"language":{"button":"Dili seç","remove":"Dili kaldır"},"link":{"acccessKey":"Erişim Tuşu","advanced":"Gelişmiş","advisoryContentType":"Danışma İçerik Türü","advisoryTitle":"Danışma Başlığı","anchor":{"toolbar":"Bağlantı Ekle/Düzenle","menu":"Bağlantı Özellikleri","title":"Bağlantı Özellikleri","name":"Bağlantı Adı","errorName":"Lütfen bağlantı için ad giriniz","errorWhitespace":"Anchor name cannot contain space characters","remove":"Bağlantıyı Kaldır"},"anchorId":"Eleman Kimlik Numarası ile","anchorName":"Bağlantı Adı ile","charset":"Bağlı Kaynak Karakter Gurubu","cssClasses":"Biçem Sayfası Sınıfları","download":"İndirmeye Zorla","displayText":"Gösterim Metni","emailAddress":"E-Posta Adresi","emailBody":"İleti Gövdesi","emailSubject":"İleti Konusu","id":"Id","info":"Link Bilgisi","langCode":"Dil Yönü","langDir":"Dil Yönü","langDirLTR":"Soldan Sağa (LTR)","langDirRTL":"Sağdan Sola (RTL)","menu":"Link Düzenle","name":"Ad","noAnchors":"(Bu belgede hiç çapa yok)","noEmail":"Lütfen E-posta adresini yazın","noUrl":"Lütfen Link URL'sini yazın","noTel":"Lütfen telefon numaranızı yazınız","other":"<diğer>","phoneNumber":"Telefon numarası","popupDependent":"Bağımlı (Netscape)","popupFeatures":"Yeni Açılan Pencere Özellikleri","popupFullScreen":"Tam Ekran (IE)","popupLeft":"Sola Göre Konum","popupLocationBar":"Yer Çubuğu","popupMenuBar":"Menü Çubuğu","popupResizable":"Resizable","popupScrollBars":"Kaydırma Çubukları","popupStatusBar":"Durum Çubuğu","popupToolbar":"Araç Çubuğu","popupTop":"Yukarıya Göre Konum","rel":"İlişki","selectAnchor":"Bağlantı Seç","styles":"Biçem","tabIndex":"Sekme İndeksi","target":"Hedef","targetFrame":"<çerçeve>","targetFrameName":"Hedef Çerçeve Adı","targetPopup":"<yeni açılan pencere>","targetPopupName":"Yeni Açılan Pencere Adı","title":"Link","toAnchor":"Bu sayfada çapa","toEmail":"E-Posta","toUrl":"URL","toPhone":"Telefon","toolbar":"Link Ekle/Düzenle","type":"Link Türü","unlink":"Köprü Kaldır","upload":"Karşıya Yükle"},"list":{"bulletedlist":"Simgeli Liste","numberedlist":"Numaralı Liste"},"liststyle":{"bulletedTitle":"Simgeli Liste Özellikleri","circle":"Daire","decimal":"Ondalık (1, 2, 3, vs.)","disc":"Disk","lowerAlpha":"Küçük Alpha (a, b, c, d, e, vs.)","lowerRoman":"Küçük Roman (i, ii, iii, iv, v, vs.)","none":"Yok","notset":"<ayarlanmamış>","numberedTitle":"Sayılandırılmış Liste Özellikleri","square":"Kare","start":"Başla","type":"Tipi","upperAlpha":"Büyük Alpha (A, B, C, D, E, vs.)","upperRoman":"Büyük Roman (I, II, III, IV, V, vs.)","validateStartNumber":"Liste başlangıcı tam sayı olmalıdır."},"magicline":{"title":"Parağrafı buraya ekle"},"maximize":{"maximize":"Büyült","minimize":"Küçült"},"newpage":{"toolbar":"Yeni Sayfa"},"pagebreak":{"alt":"Sayfa Sonu","toolbar":"Sayfa Sonu Ekle"},"pastetext":{"button":"Düz metin olarak yapıştır","pasteNotification":"%1 tuşuna yapıştırmak için tıklayın. Tarayıcınız, Araç Çubuğu yada İçerik Menüsünü kullanarak yapıştırmayı desteklemiyor.","title":"Düz metin olarak yapıştır"},"pastefromword":{"confirmCleanup":"Yapıştırmaya çalıştığınız metin Word'den kopyalanmıştır. Yapıştırmadan önce silmek istermisiniz?","error":"Yapıştırmadaki veri bilgisi hata düzelene kadar silinmeyecektir","title":"Word'den Yapıştır","toolbar":"Word'den Yapıştır"},"preview":{"preview":"Ön İzleme"},"print":{"toolbar":"Yazdır"},"removeformat":{"toolbar":"Biçimi Kaldır"},"save":{"toolbar":"Kaydet"},"selectall":{"toolbar":"Tümünü Seç"},"showblocks":{"toolbar":"Blokları Göster"},"sourcearea":{"toolbar":"Kaynak"},"specialchar":{"options":"Özel Karakter Seçenekleri","title":"Özel Karakter Seç","toolbar":"Özel Karakter Ekle"},"scayt":{"btn_about":"SCAYT'ı hakkında","btn_dictionaries":"Sözlükler","btn_disable":"SCAYT'ı pasifleştir","btn_enable":"SCAYT'ı etkinleştir","btn_langs":"Diller","btn_options":"Seçenekler","text_title":"Girmiş olduğunuz kelime denetimi"},"stylescombo":{"label":"Biçem","panelTitle":"Stilleri Düzenliyor","panelTitle1":"Blok Stilleri","panelTitle2":"Inline Stilleri","panelTitle3":"Nesne Stilleri"},"table":{"border":"Kenar Kalınlığı","caption":"Başlık","cell":{"menu":"Hücre","insertBefore":"Hücre Ekle - Önce","insertAfter":"Hücre Ekle - Sonra","deleteCell":"Hücre Sil","merge":"Hücreleri Birleştir","mergeRight":"Birleştir - Sağdaki İle ","mergeDown":"Birleştir - Aşağıdaki İle ","splitHorizontal":"Hücreyi Yatay Böl","splitVertical":"Hücreyi Dikey Böl","title":"Hücre Özellikleri","cellType":"Hücre Tipi","rowSpan":"Satırlar Mesafesi (Span)","colSpan":"Sütünlar Mesafesi (Span)","wordWrap":"Kelime Kaydırma","hAlign":"Düşey Hizalama","vAlign":"Yataş Hizalama","alignBaseline":"Tabana","bgColor":"Arkaplan Rengi","borderColor":"Çerçeve Rengi","data":"Veri","header":"Başlık","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Evet","no":"Hayır","invalidWidth":"Hücre genişliği sayı olmalıdır.","invalidHeight":"Hücre yüksekliği sayı olmalıdır.","invalidRowSpan":"Satırların mesafesi tam sayı olmalıdır.","invalidColSpan":"Sütünların mesafesi tam sayı olmalıdır.","chooseColor":"Seçiniz"},"cellPad":"Izgara yazı arası","cellSpace":"Izgara kalınlığı","column":{"menu":"Sütun","insertBefore":"Kolon Ekle - Önce","insertAfter":"Kolon Ekle - Sonra","deleteColumn":"Sütun Sil"},"columns":"Sütunlar","deleteTable":"Tabloyu Sil","headers":"Başlıklar","headersBoth":"Her İkisi","headersColumn":"İlk Sütun","headersNone":"Yok","headersRow":"İlk Satır","heightUnit":"yükseklik birimi","invalidBorder":"Çerceve büyüklüklüğü sayı olmalıdır.","invalidCellPadding":"Hücre aralığı (padding) sayı olmalıdır.","invalidCellSpacing":"Hücre boşluğu (spacing) sayı olmalıdır.","invalidCols":"Sütün sayısı 0 sayısından büyük olmalıdır.","invalidHeight":"Tablo yüksekliği sayı olmalıdır.","invalidRows":"Satır sayısı 0 sayısından büyük olmalıdır.","invalidWidth":"Tablo genişliği sayı olmalıdır.","menu":"Tablo Özellikleri","row":{"menu":"Satır","insertBefore":"Satır Ekle - Önce","insertAfter":"Satır Ekle - Sonra","deleteRow":"Satır Sil"},"rows":"Satırlar","summary":"Özet","title":"Tablo Özellikleri","toolbar":"Tablo","widthPc":"yüzde","widthPx":"piksel","widthUnit":"genişlik birimi"},"undo":{"redo":"Tekrarla","undo":"Geri Al"},"widget":{"move":"Taşımak için, tıklayın ve sürükleyin","label":"%1 Grafik Beleşeni"},"uploadwidget":{"abort":"Gönderme işlemi kullanıcı tarafından durduruldu.","doneOne":"Gönderim işlemi başarılı şekilde tamamlandı.","doneMany":"%1 dosya başarılı şekilde gönderildi.","uploadOne":"Dosyanın ({percentage}%) gönderildi...","uploadMany":"Toplam {current} / {max} dosyanın ({percentage}%) gönderildi..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Kaynak","searchCode":"Search Source","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection","commentSelectedRange":"Comment Selection","uncommentSelectedRange":"Uncomment Selection","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Emoji ara...","searchLabel":"Panel içindeki emojiyi aramaya ve filtrelemeye ait giriş alanı.","navigationLabel":"Emoji bölümleri için gezinti grupları","title":"Emoji Listesi","groups":{"people":"İnsanlar","nature":"Doğa ve hayvanlar","food":"Yiyecek ve içecekler","travel":"Seyahat ve mekanlar","activities":"Faaliyetler","objects":"Nesneler","symbols":"Semboller","flags":"Bayraklar"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Kaynak","title":"Kaynak"}};