﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['es-mx']={"application":"Rich Text Editor","editor":"Editor de texto enriquecido","editorPanel":"Panel del editor de texto","common":{"editorHelp":"Presiona ALT + 0 para ayuda","browseServer":"Examinar servidor","url":"URL","protocol":"Protocolo","upload":"Subir","uploadSubmit":"Enviar al servidor","image":"Imagen","form":"Formulario","checkbox":"Casilla de verificación","radio":"Botón de opción","textField":"Campo de texto","textarea":"Área de texto","hiddenField":"Campo oculto","button":"Botón","select":"Campo de selección","imageButton":"Botón de imagen","notSet":"<not set>","id":"Id","name":"Nombre","langDir":"Dirección de idiomas","langDirLtr":"Izquierda a derecha (LTR)","langDirRtl":"Derecha a izquierda (RTL)","langCode":"Código de lenguaje","longDescr":"URL descripción larga","cssClass":"Clases de hoja de estilo","advisoryTitle":"Título del anuncio","cssStyle":"Estilo","ok":"OK","cancel":"Cancelar","close":"Cerrar","preview":"Vista previa","resize":"Redimensionar","generalTab":"General","advancedTab":"Avanzada","validateNumberFailed":"Este valor no es un número.","confirmNewPage":"Se perderán todos los cambios no guardados en este contenido. ¿Seguro que quieres cargar nueva página?","confirmCancel":"Ha cambiado algunas opciones. ¿Está seguro de que desea cerrar la ventana de diálogo?","options":"Opciones","target":"Objetivo","targetNew":"Nueva ventana (_blank)","targetTop":"Ventana superior (_top)","targetSelf":"Misma ventana (_self)","targetParent":"Ventana principal (_parent)","langDirLTR":"Izquierda a Derecha (LTR)","langDirRTL":"Derecha a Izquierda (RTL)","styles":"Estilo","cssClasses":"Clases de hojas de estilo","width":"Ancho","height":"Alto","align":"Alineación","left":"Izquierda","right":"Derecha","center":"Centrado","justify":"Justificado","alignLeft":"Alinear a la izquierda","alignRight":"Alinear a la derecha","alignCenter":"Align Center","alignTop":"Arriba","alignMiddle":"En medio","alignBottom":"Abajo","alignNone":"Ninguno","invalidValue":"Valor inválido","invalidHeight":"La altura debe ser un número.","invalidWidth":"La anchura debe ser un número.","invalidLength":"Value specified for the \"%1\" field must be a positive number with or without a valid measurement unit (%2).","invalidCssLength":"El valor especificado para el campo \"% 1\" debe ser un número positivo con o sin una unidad de medida CSS válida (px, %, in, cm, mm, em, ex, pt, or pc).","invalidHtmlLength":"El valor especificado para el campo \"% 1\" debe ser un número positivo con o sin una unidad de medición HTML válida (px or %).","invalidInlineStyle":"El valor especificado para el estilo en línea debe constar de una o más tuplas con el formato de \"nombre: valor\", separados por punto y coma","cssLengthTooltip":"Introduzca un número para un valor en píxeles o un número con una unidad CSS válida  (px, %, in, cm, mm, em, ex, pt, or pc).","unavailable":"%1<span class=\"cke_accessibility\">, no disponible</span>","keyboard":{"8":"Retroceso","13":"Intro","16":"Shift","17":"Ctrl","18":"Alt","32":"Espacio","35":"Fin","36":"Inicio","46":"Borrar","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Comando"},"keyboardShortcut":"Atajo de teclado","optionDefault":"Default"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Derechos reservados &copy; $1. Todos los derechos reservados","dlgTitle":"Acerca de CKEditor 4","moreInfo":"Para información sobre la licencia por favor visita nuestro sitio web:"},"basicstyles":{"bold":"Negrita","italic":"Cursiva","strike":"Tachado","subscript":"subíndice","superscript":"Sobrescrito","underline":"Subrayada"},"bidi":{"ltr":"Dirección del texto de izquierda a derecha","rtl":"Dirección del texto de derecha a izquierda"},"blockquote":{"toolbar":"Entrecomillado"},"notification":{"closed":"Notificación cerrada."},"toolbar":{"toolbarCollapse":"Colapsar barra de herramientas","toolbarExpand":"Expandir barra de herramientas","toolbarGroups":{"document":"Documento","clipboard":"Portapapeles/deshacer","editing":"Editando","forms":"Formularios","basicstyles":"Estilo básico","paragraph":"Párrafo","links":"Enlaces","insert":"Insertar","styles":"Estilos","colors":"Colores","tools":"Herramientas"},"toolbars":"Editor de barra de herramientas"},"clipboard":{"copy":"Copiar","copyError":"La configuración de seguridad de su navegador no permite al editor ejecutar automáticamente operaciones de copiado. Por favor, utilice el teclado para (Ctrl/Cmd+C).","cut":"Cortar","cutError":"La configuración de seguridad de su navegador no permite al editor ejecutar automáticamente operaciones de corte. Por favor, utilice el teclado para (Ctrl/Cmd+X).","paste":"Pegar","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","pasteArea":"Paste Area","pasteMsg":"Paste your content inside the area below and press OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automático","bgColorTitle":"Color de fondo","colors":{"000":"Negro","800000":"Marrón","8B4513":"Café sucio","2F4F4F":"Gris pizarra oscuro","008080":"Teal","000080":"Armada","4B0082":"Indigo","696969":"Gris oscuro","B22222":"Ladrillo de fuego","A52A2A":"Café","DAA520":"Barra de oro","006400":"Verde oscuro","40E0D0":"Turquesa","0000CD":"Azul medio","800080":"Morado","808080":"Gris","F00":"Rojo","FF8C00":"Naranja oscuro","FFD700":"Oro","008000":"Verde","0FF":"Cian","00F":"Azul","EE82EE":"Violeta","A9A9A9":"Gris oscuro","FFA07A":"Salmón claro","FFA500":"Naranja","FFFF00":"Amarillo","00FF00":"Lima","AFEEEE":"Turquesa pálido","ADD8E6":"Azul claro","DDA0DD":"Ciruela","D3D3D3":"Gris claro","FFF0F5":"Rubor de lavanda","FAEBD7":"Blanco antiguo","FFFFE0":"Amarillo claro","F0FFF0":"Gotas de miel","F0FFFF":"Azul celeste","F0F8FF":"Azul Alicia","E6E6FA":"Lavanda","FFF":"Blanco","1ABC9C":"Cian fuerte","2ECC71":"Esmeralda","3498DB":"Azul brillante","9B59B6":"Amatista","4E5F70":"Azul grisáceo","F1C40F":"Amarillo vívido","16A085":"Cian oscuro","27AE60":"Esmeralda oscuro","2980B9":"Azul fuerte","8E44AD":"Violeta oscuro","2C3E50":"Azul Desaturado","F39C12":"Naranja","E67E22":"Zanahoria","E74C3C":"Rojo pálido","ECF0F1":"Plata brillante","95A5A6":"Cian grisáceo claro","DDD":"Gris claro","D35400":"Calabaza","C0392B":"Rojo fuerte","BDC3C7":"Plata","7F8C8D":"Cian grisáceo","999":"Gris oscuro"},"more":"Más colores...","panelTitle":"Colores","textColorTitle":"Color de texto"},"colordialog":{"clear":"Borrar","highlight":"Realce","options":"Opciones de color","selected":"Color seleccionado","title":"Selecciona un color"},"templates":{"button":"Plantillas","emptyListMsg":"(Sin plantilla definida)","insertOption":"Reemplazar contenido actual","options":"Opciones de la plantilla","selectPromptMsg":"Por favor selecciona una plantilla para abrir en el editor","title":"Contenido de las plantillas"},"contextmenu":{"options":"Opciones del menú contextual"},"copyformatting":{"label":"Copiando formato","notification":{"copied":"Formato copiado","applied":"Aplicando formato","canceled":"Cancelando formato","failed":"Formato falló. No puede aplicar estilos sin copiarlos primero."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Título del anuncio","cssClassInputLabel":"Clases de la hoja de estilos","edit":"Editar Div","inlineStyleInputLabel":"Estilo de línea","langDirLTRLabel":"Izquierda a Derecha (LTR)","langDirLabel":"Dirección de idiomas","langDirRTLLabel":"Derecha a Izquierda (RTL)","languageCodeInputLabel":"Código del idioma","remove":"Remover Div","styleSelectLabel":"Estilo","title":"Crear contenedor Div","toolbar":"Crear contenedor Div"},"elementspath":{"eleLabel":"Ruta de los elementos","eleTitle":"%1 elemento"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Ha ocurrido un error al leer el archivo","networkError":"Ha ocurrido un error de red durante la carga del archivo.","httpError404":"Se ha producido un error HTTP durante la subida de archivos (404: archivo no encontrado).","httpError403":"Se ha producido un error HTTP durante la subida de archivos (403: Prohibido).","httpError":"Se ha producido un error HTTP durante la subida de archivos (error: %1).","noUrlError":"La URL de subida no está definida.","responseError":"Respuesta incorrecta del servidor."},"find":{"find":"Buscar","findOptions":"Opciones de busqueda","findWhat":"Buscar que:","matchCase":"Comparar mayúsculas","matchCyclic":"Comparación cíclica","matchWord":"Compare la palabra completa","notFoundMsg":"El texto especificado no fue encontrado.","replace":"Remplazar","replaceAll":"Remplazar todo","replaceSuccessMsg":"%1 ","replaceWith":"Reemplazar con:","title":"Busca y reemplaza"},"font":{"fontSize":{"label":"Tamaño","voiceLabel":"Tamaño de letra","panelTitle":"Tamaño de letra"},"label":"Letra","panelTitle":"Nombre de letra","voiceLabel":"Letra"},"fakeobjects":{"anchor":"Ancla","hiddenfield":"Campo oculto","iframe":"IFrame","unknown":"Objeto desconocido"},"forms":{"button":{"title":"Propiedades del botón","text":"Texto (valor)","type":"Tipo","typeBtn":"Botón","typeSbm":"Enviar","typeRst":"Reiniciar"},"checkboxAndRadio":{"checkboxTitle":"Propiedades de la casilla de verificación","radioTitle":"Propiedades de botón de opciones","value":"Valor","selected":"Seleccionado","required":"Requerido"},"form":{"title":"Propiedades del formulario","menu":"Propiedades del formulario","action":"Acción","method":"Método","encoding":"Codificación"},"hidden":{"title":"Propiedades del campo oculto","name":"Nombre","value":"Valor"},"select":{"title":"Propiedades del campo de selección","selectInfo":"Seleccionar información","opAvail":"Opciones disponobles","value":"Valor","size":"Tamaño","lines":"líneas","chkMulti":"Permitir múltiple selección","required":"Requerido","opText":"Texto","opValue":"Valor","btnAdd":"Agregar","btnModify":"Modificar","btnUp":"Subir","btnDown":"Bajar","btnSetValue":"Establecer como valor seleccionado","btnDelete":"Borrar"},"textarea":{"title":"Propiedades del área de texto","cols":"Columnas","rows":"Filas"},"textfield":{"title":"Propiedades del campo texto","name":"Nombre","value":"Valor","charWidth":"Ancho de caracteres","maxChars":"Máximo de caracteres","required":"Requerido","type":"Tipo","typeText":"Texto","typePass":"Contraseña","typeEmail":"Correo electrónico","typeSearch":"Busqueda","typeTel":"Número telefónico","typeUrl":"URL"}},"format":{"label":"Formato","panelTitle":"Formato de párrafo","tag_address":"Dirección","tag_div":"Normal (DIV)","tag_h1":"Encabezado 1","tag_h2":"Encabezado 2","tag_h3":"Encabezado 3","tag_h4":"Encabezado 4","tag_h5":"Encabezado 5","tag_h6":"Encabezado 6","tag_p":"Normal","tag_pre":"Formateado"},"horizontalrule":{"toolbar":"Insertar una línea horizontal"},"iframe":{"border":"Mostrar el borde del marco","noUrl":"Ingresa la URL del iframe","scrolling":"Habilitar la barra de desplazamiento","title":"Propiedades del IFrame","toolbar":"Iframe","tabindex":"Remove from tabindex"},"image":{"alt":"Texto alternativo","border":"Borde","btnUpload":"Enviar al servidor","button2Img":"¿Desea transformar el botón de imagen seleccionado en una imagen simple?","hSpace":"Espacio horizontal","img2Button":"¿Desea transformar la imagen seleccionada en un botón de imagen?","infoTab":"Información de imagen","linkTab":"Enlace","lockRatio":"Bloquear aspecto","menu":"Propiedades de la imagen","resetSize":"Reiniciar tamaño","title":"Propiedades de la imagen","titleButton":"Propiedades del botón de imagen","upload":"Cargar","urlMissing":"Falta la URL de origen de la imagen.","vSpace":"Espacio vertical","validateBorder":"El borde debe ser un número entero.","validateHSpace":"El espacio horizontal debe ser un número entero.","validateVSpace":"El espacio vertical debe ser un número entero."},"indent":{"indent":"Incrementar sangría","outdent":"Decrementar sangría"},"smiley":{"options":"Opciones de smiley","title":"Insertar un smiley","toolbar":"Smiley"},"language":{"button":"Establecer idioma","remove":"Remover idioma"},"link":{"acccessKey":"Llave de acceso","advanced":"Avanzada","advisoryContentType":"Tipo de contenido consultivo","advisoryTitle":"Título asesor","anchor":{"toolbar":"Ancla","menu":"Editar ancla","title":"Propiedades del ancla","name":"Nombre del ancla","errorName":"Escriba el nombre del ancla","errorWhitespace":"Anchor name cannot contain space characters","remove":"Remover ancla"},"anchorId":"Por Id del elemento","anchorName":"Por nombre del ancla","charset":"Recurso relacionado Charset","cssClasses":"Clases de estilo de hoja","download":"Forzar la descarga","displayText":"Mostrar texto","emailAddress":"Dirección de correo electrónico","emailBody":"Cuerpo del mensaje","emailSubject":"Asunto del mensaje","id":"Id","info":"Información del enlace","langCode":"Código del idioma","langDir":"Dirección del idioma","langDirLTR":"Izquierda a Derecha (LTR)","langDirRTL":"Derecha a Izquierda (RTL)","menu":"Editar enlace","name":"Nombre","noAnchors":"(No hay anclas disponibles en el documento)","noEmail":"Escriba la dirección de correo electrónico","noUrl":"Escriba la URL del enlace","noTel":"Please type the phone number","other":"<other>","phoneNumber":"Phone number","popupDependent":"Dependiente (Netscape)","popupFeatures":"Ventana emergente","popupFullScreen":"Pantalla completa (IE)","popupLeft":"Posición Izquierda","popupLocationBar":"Ubicación de la barra","popupMenuBar":"Barra de menú","popupResizable":"Redimensionable","popupScrollBars":"Barras de desplazamiento","popupStatusBar":"Barra de estado","popupToolbar":"Barra de herramienta","popupTop":"Posición superior","rel":"Relación","selectAnchor":"Selecciona un ancla","styles":"Estilo","tabIndex":"Indice de tabulación","target":"Objetivo","targetFrame":"<frame>","targetFrameName":"Nombre del marco de destino","targetPopup":"<popup window>","targetPopupName":"Nombre de ventana emergente","title":"Enlace","toAnchor":"Enlace al ancla en el texto","toEmail":"Correo electrónico","toUrl":"URL","toPhone":"Phone","toolbar":"Enlace","type":"Tipo de enlace","unlink":"Desconectar","upload":"Subir"},"list":{"bulletedlist":"Insertar/Remover Lista con viñetas","numberedlist":"Insertar/Remover Lista numerada"},"liststyle":{"bulletedTitle":"Propiedades de la lista con viñetas","circle":"Círculo","decimal":"Decimal (1, 2, 3, etc.)","disc":"Desc","lowerAlpha":"Alfabeto minúscula (a, b, c, d, e, etc.)","lowerRoman":"Romano minúscula (i, ii, iii, iv, v, etc.)","none":"Ninguno","notset":"<not set>","numberedTitle":"Propiedades de la lista numerada","square":"Cuadrado","start":"Inicio","type":"Tipo","upperAlpha":"Abecedario mayúscula (A, B, C, D, E, etc.)","upperRoman":"Romanos mayúscula (I, II, III, IV, V, etc.)","validateStartNumber":"El número de inicio de la lista debe ser un número entero."},"magicline":{"title":"Insertar un párrafo aquí"},"maximize":{"maximize":"Maximizar","minimize":"Minimizar"},"newpage":{"toolbar":"Página nueva"},"pagebreak":{"alt":"Salto de página","toolbar":"Insertar un salto de página para imprimir"},"pastetext":{"button":"Pegar como texto plano","pasteNotification":"Press %1 to paste. Your browser doesn‘t support pasting with the toolbar button or context menu option.","title":"Paste as Plain Text"},"pastefromword":{"confirmCleanup":"El texto que desea pegar parece estar copiado de Word. ¿Quieres limpiarlo antes de pegarlo?","error":"No fue posible limpiar los datos pegados debido a un error interno","title":"Pegar desde word","toolbar":"Pegar desde word"},"preview":{"preview":"Vista previa"},"print":{"toolbar":"Imprimir"},"removeformat":{"toolbar":"Remover formato"},"save":{"toolbar":"Guardar"},"selectall":{"toolbar":"Seleccionar todo"},"showblocks":{"toolbar":"Mostrar bloques"},"sourcearea":{"toolbar":"Fuente"},"specialchar":{"options":"Opciones de carácteres especiales","title":"Seleccione un carácter especial","toolbar":"Inserta un carácter especial"},"scayt":{"btn_about":"About SCAYT","btn_dictionaries":"Dictionaries","btn_disable":"Disable SCAYT","btn_enable":"Enable SCAYT","btn_langs":"Languages","btn_options":"Options","text_title":"Spell Check As You Type"},"stylescombo":{"label":"Estilos","panelTitle":"Estilos de formatos","panelTitle1":"Estilos de bloques","panelTitle2":"Estilos de líneas","panelTitle3":"Estilo de objetos"},"table":{"border":"Tamaño del borde","caption":"Subtítulo","cell":{"menu":"Celda","insertBefore":"Insertar una celda antes","insertAfter":"Insertar una celda despues","deleteCell":"Borrar celdas","merge":"Unir celdas","mergeRight":"Unir a la derecha","mergeDown":"Unir abajo","splitHorizontal":"Dividir celda horizontalmente","splitVertical":"Dividir celda verticalmente","title":"Propiedades de la celda","cellType":"Tipo de celda","rowSpan":"Extensión de las filas","colSpan":"Extensión de las columnas","wordWrap":"Ajuste de línea","hAlign":"Alineación horizontal","vAlign":"Alineación vertical","alignBaseline":"Base","bgColor":"Color de fondo","borderColor":"Color de borde","data":"Datos","header":"Encabezado","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Si","no":"No","invalidWidth":"El ancho de la celda debe ser un número entero.","invalidHeight":"El alto de la celda debe ser un número entero.","invalidRowSpan":"El intervalo de filas debe ser un número entero.","invalidColSpan":"El intervalo de columnas debe ser un número entero.","chooseColor":"Escoger"},"cellPad":"relleno de celda","cellSpace":"Espacio de celda","column":{"menu":"Columna","insertBefore":"Insertar columna antes","insertAfter":"Insertar columna después","deleteColumn":"Borrar columnas"},"columns":"Columnas","deleteTable":"Borrar tabla","headers":"Encabezados","headersBoth":"Ambos","headersColumn":"Primera columna","headersNone":"Ninguna","headersRow":"Primera fila","heightUnit":"height unit","invalidBorder":"El tamaño del borde debe ser un número entero.","invalidCellPadding":"El relleno de la celda debe ser un número positivo.","invalidCellSpacing":"El espacio de la celda debe ser un número positivo.","invalidCols":"El número de columnas debe ser un número mayo que 0.","invalidHeight":"La altura de la tabla debe ser un número.","invalidRows":"El número de filas debe ser mayor a 0.","invalidWidth":"El ancho de la tabla debe ser un número.","menu":"Propiedades de la tabla","row":{"menu":"Fila","insertBefore":"Inserta una fila antes","insertAfter":"Inserta una fila después","deleteRow":"Borrar filas"},"rows":"Filas","summary":"Resumen","title":"Propiedades de la tabla","toolbar":"Tabla","widthPc":"porcentaje","widthPx":"pixeles","widthUnit":"Unidad de ancho"},"undo":{"redo":"Rehacer","undo":"Deshacer"},"widget":{"move":"Presiona y arrastra para mover","label":"%1 widget"},"uploadwidget":{"abort":"La carga ha sido abortada por el usuario.","doneOne":"El archivo ha sido cargado completamente.","doneMany":"%1 archivos cargados completamente.","uploadOne":"Cargando archivo ({percentage}%)...","uploadMany":"Cargando archivos, {current} de {max} listo ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Source","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Fuente","title":"Fuente"}};