## About A11yFirst

### Project Description & Goals

The A11yFirst Project is a collection of modifications to CKEditor, an
HTML-embedded WYSIWYG editor typically used within content management
systems. Its goal is to make the process of creating and editing web documents
one that proactively results in accessible content.

In the past, authors have had to rely upon remediation tools used at the end
of the authoring process that ‘fix’ accessibility problems without offering
much guidance on how to prevent them. The A11yFirst editor takes a different
approach.

For example, by prompting the author to provide information regarding links
and images as they are added to the document, accessibility problems are not
only avoided, but authors learn on a feature-by-feature basis some of the
important requirements for accessible content.

Other design features in A11yFirst promote the use of blocks such as headings
and lists that carry with them semantics that are communicated to screen
reader users and that result in documents that are more easily navigated and
understood by all readers.

### Project Information

* Version: %version

* GitHub Repositories: <a href="https://github.com/a11yfirst"
target="_resource">https://github.com/a11yfirst</a>

### Contributors

* Lucy Chang     (UX, Usability Testing)
* Jon Gunderson  (Requirements, Development, Usability Testing,
  Project Management)
* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,
  Project Management)
* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,
  Project Management)
* Eileen Lopez   (UX, Usability Testing)
* Mark McCarthy  (UX, Usability Testing)
* Robert Slater  (Requirements)
* Dena Strong    (UX, Usability Testing)

### Sponsors

* Disability Resources and Educational Services (DRES), College of Applied
  Health Sciences (AHS), University of Illinois at Urbana-Champaign
* Illinois Extension, College of Agricultural, Consumer and Environmental
  Sciences (ACES), University of Illinois at Urbana-Champaign
* The University Library, Innovation Fund (Jemma Ku, P.I.), University of
  Illinois at Urbana-Champaign
* Administrative Information Technology Services (AITS), University of
  Illinois at Urbana-Champaign
* School of Information Sciences (iSchool), University of Illinois at
  Urbana-Champaign

### Acknowledgements

Many of the ideas and motivations for the A11yFirst Project were the result
of work done previously by a group of software developers at the Illinois
Department of Human Services (DHS), led by Mike Scott, who created the OneNet
content management system, which includes as its centerpiece an accessible
WYSIWYG editor.

The OneNet CMS has been in use by the Illinois DHS since 2006 to promote
accessible authoring for their intranet and main website.

Mr. Scott also participated in the requirements gathering phase of the
A11yFirst Project.
